/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.IFilterStrings;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.ViewFilterDialog;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerConfigXmlParser;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.markers.MarkerUtils;
import org.eclipse.tracecompass.internal.tmf.ui.util.TimeGraphStyleUtil;
import org.eclipse.tracecompass.internal.tmf.ui.views.ITmfTimeNavigationProvider;
import org.eclipse.tracecompass.internal.tmf.ui.views.ITmfTimeZoomProvider;
import org.eclipse.tracecompass.internal.tmf.ui.views.ITmfZoomToSelectionProvider;
import org.eclipse.tracecompass.internal.tmf.ui.views.timegraph.TimeEventFilterDialog;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.model.ICoreElementResolver;
import org.eclipse.tracecompass.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.IAnnotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.annotations.TraceAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfDataModelSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfMarkerEventSourceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.views.ITmfAllowMultiple;
import org.eclipse.tracecompass.tmf.ui.views.ITmfFilterableControl;
import org.eclipse.tracecompass.tmf.ui.views.ITmfPinnable;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.SaveImageUtil;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphEntryComparator;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphLegendProvider;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ShowFindDialogAction;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphBookmarkListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphBookmarkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class AbstractTimeGraphView
extends TmfView
implements ITmfTimeAligned,
ITmfAllowMultiple,
ITmfPinnable,
IResourceChangeListener,
ITmfFilterableControl {
    private static final String TIMEGRAPH_UI_CONTEXT = "org.eclipse.tracecompass.tmf.ui.view.timegraph.context";
    private static final String TMF_VIEW_UI_CONTEXT = "org.eclipse.tracecompass.tmf.ui.view.context";
    private static final String DIRTY_UNDERFLOW_ERROR = "Dirty underflow error";
    protected static final int ALL_LEVELS = -1;
    private static final Pattern RGBA_PATTERN = Pattern.compile("RGBA \\{(\\d+), (\\d+), (\\d+), (\\d+)\\}");
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(AbstractTimeGraphView.class);
    private static final int DEFAULT_BUFFER_SIZE = 3;
    private static final String HIDE_LABELS_KEY = "hide.labels";
    private TimeGraphViewer fTimeGraphViewer;
    private AtomicInteger fDirty = new AtomicInteger();
    private final Object fZoomThreadResultLock = new Object();
    private ITmfTrace fTrace;
    private @Nullable IFile fEditorFile;
    private List<TimeGraphEntry> fEntryList;
    private final Map<ITmfTrace, List<@NonNull TimeGraphEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TimeGraphEntry>>();
    private final Map<ITmfTrace, @NonNull ViewerFilter[]> fFiltersMap = new HashMap<ITmfTrace, ViewerFilter[]>();
    private final Map<ITmfTrace, ViewContext> fViewContext = new HashMap<ITmfTrace, ViewContext>();
    private final Map<ITmfTrace, List<IMarkerEventSource>> fMarkerEventSourcesMap = new HashMap<ITmfTrace, List<IMarkerEventSource>>();
    private final Map<ITmfTrace, Job> fBuildJobMap = new HashMap<ITmfTrace, Job>();
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    private final int fDisplayWidth;
    private ZoomThread fZoomThread;
    private Action fNextResourceAction;
    private Action fPreviousResourceAction;
    private HideEmptyRowsAction fHideEmptyRowsAction;
    private Comparator<ITimeGraphEntry> fEntryComparator = null;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();
    private final TimeGraphPresentationProvider fPresentation;
    private String[] fColumns;
    private Comparator<ITimeGraphEntry>[] fColumnComparators;
    private ITableLabelProvider fLabelProvider = new TreeLabelProvider();
    private @NonNull ITimeGraphContentProvider fTimeGraphContentProvider = new TimeGraphContentProvider();
    private int[] fWeight = new int[]{1, 3};
    private String[] fFilterColumns;
    private ITreeContentProvider fFilterContentProvider;
    private TreeLabelProvider fFilterLabelProvider;
    private ITimeGraphLegendProvider fLegendProvider;
    private int fAutoExpandLevel = -1;
    private @Nullable Utils.TimeFormat fTimeFormat = null;
    private int fInitialSortColumn = 0;
    private int fCurrentSortColumn = 0;
    private int fSortDirection = 1024;
    private volatile boolean fIsRevealSelection = false;
    private @NonNull Set<@NonNull TimeGraphEntry> fVisibleEntries = Collections.emptySet();
    private int fPrevTimeSpace = -1;
    private final @NonNull MenuManager fEntryMenuManager = new MenuManager();
    private TimeGraphPartListener fPartListener;
    private static final ShowFindDialogAction FIND_ACTION = new ShowFindDialogAction();
    private ActionHandler fFindActionHandler;
    private IHandlerActivation fFindHandlerActivation;
    private final FindTarget fFindTarget;
    private MenuManager fMarkerSetMenu;
    private String fOriginalTabLabel;
    private Action fTimeEventFilterAction;
    private TimeEventFilterDialog fTimeEventFilterDialog;
    private volatile boolean fIsHideRowsFilterActive;
    private TimeGraphPartListener2 fPartListener2;
    private IContextService fContextService;
    private List<IContextActivation> fActiveContexts = new ArrayList<IContextActivation>();
    private final ITimeGraphSelectionListener fMetadataSelectionListener = event -> {
        Multimap metadata;
        ITimeGraphEntry entry = event.getSelection();
        if (entry instanceof ICoreElementResolver && !(metadata = ((ICoreElementResolver)entry).getMetadata()).isEmpty()) {
            this.broadcast((TmfSignal)new TmfDataModelSelectedSignal((Object)this, metadata));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyResults(Runnable runnable) {
        Object object = this.fZoomThreadResultLock;
        synchronized (object) {
            if (Thread.currentThread() == this.fZoomThread) {
                Display.getDefault().asyncExec(runnable);
            }
        }
    }

    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        this.zoomEntries(entries, zoomStartTime, zoomEndTime, resolution, false, monitor);
    }

    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, boolean fullSearch, @NonNull IProgressMonitor monitor) {
        try {
            Map<Integer, java.util.function.Predicate<Multimap<String, Object>>> predicates = this.generateRegexPredicate();
            for (TimeGraphEntry entry : entries) {
                List<ITimeEvent> zoomedEventList = this.getEventList(entry, zoomStartTime, zoomEndTime, fullSearch ? 1L : resolution, monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                if (zoomedEventList == null) continue;
                this.doFilterEventList(entry, zoomedEventList, predicates);
                this.applyResults(() -> entry.setZoomedEventList(zoomedEventList));
            }
            this.redraw();
        }
        catch (PatternSyntaxException e) {
            Activator.getDefault().logInfo("Invalid regex");
        }
    }

    @NonNullByDefault
    protected void doFilterEventList(TimeGraphEntry entry, List<ITimeEvent> eventList, Map<Integer, java.util.function.Predicate<Multimap<String, Object>>> predicates) {
        if (!predicates.isEmpty()) {
            eventList.forEach(te -> {
                for (Map.Entry mapEntry : predicates.entrySet()) {
                    java.util.function.Predicate value = Objects.requireNonNull((java.util.function.Predicate)mapEntry.getValue());
                    HashMultimap toTest = HashMultimap.create();
                    for (Map.Entry<String, String> filterEntry : this.getPresentationProvider().getFilterInput((ITimeEvent)te).entrySet()) {
                        toTest.put((Object)filterEntry.getKey(), (Object)filterEntry.getValue());
                    }
                    toTest.putAll(te.getMetadata());
                    boolean status = value.test(toTest);
                    Integer property = (Integer)mapEntry.getKey();
                    if (property == 1 || property == 4) {
                        te.setProperty(property, !status);
                        continue;
                    }
                    te.setProperty(property, status);
                }
            });
        }
        this.fillWithNullEvents(entry, eventList);
    }

    private void fillWithNullEvents(TimeGraphEntry entry, List<ITimeEvent> eventList) {
        ArrayList filtered = new ArrayList();
        ViewFilterDialog viewFilterDialog = this.getViewFilterDialog();
        if (!eventList.isEmpty() && viewFilterDialog != null && viewFilterDialog.hasActiveSavedFilters()) {
            eventList.forEach(te -> {
                if (!te.isPropertyActive(4)) {
                    filtered.add(te);
                }
            });
            long prevTime = eventList.get(0).getTime();
            long endTime = eventList.get(eventList.size() - 1).getTime() + eventList.get(eventList.size() - 1).getDuration();
            eventList.clear();
            for (ITimeEvent event : filtered) {
                if (prevTime < event.getTime()) {
                    NullTimeEvent nullTimeEvent = new NullTimeEvent(entry, prevTime, event.getTime() - prevTime);
                    nullTimeEvent.setProperty(1, true);
                    nullTimeEvent.setProperty(4, true);
                    eventList.add(nullTimeEvent);
                }
                eventList.add(event);
                prevTime = event.getTime() + event.getDuration();
            }
            if (prevTime < endTime) {
                NullTimeEvent nullTimeEvent = new NullTimeEvent(entry, prevTime, endTime - prevTime);
                nullTimeEvent.setProperty(1, true);
                nullTimeEvent.setProperty(4, true);
                eventList.add(nullTimeEvent);
            }
        }
    }

    @NonNullByDefault
    protected Map<Integer, java.util.function.Predicate<Multimap<String, Object>>> generateRegexPredicate() {
        Multimap<Integer, String> regexes = this.getRegexes();
        HashMap<Integer, java.util.function.Predicate<Multimap<String, Object>>> predicates = new HashMap<Integer, java.util.function.Predicate<Multimap<String, Object>>>();
        for (Map.Entry entry : regexes.asMap().entrySet()) {
            java.util.function.Predicate predicate;
            String regex = IFilterStrings.mergeFilters((Collection)((Collection)entry.getValue()));
            FilterCu cu = FilterCu.compile((String)regex);
            java.util.function.Predicate predicate2 = predicate = cu != null ? cu.generate() : null;
            if (predicate == null) continue;
            predicates.put((Integer)entry.getKey(), predicate);
        }
        return predicates;
    }

    public AbstractTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id);
        this.fPresentation = pres;
        this.fDisplayWidth = Display.getDefault().getBounds().width;
        this.fFindTarget = new FindTarget();
    }

    @Override
    protected IAction createSaveAction() {
        return SaveImageUtil.createSaveAction(this.getName(), this::getTimeGraphViewer);
    }

    public TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphViewer;
    }

    protected ITimeGraphPresentationProvider getPresentationProvider() {
        return this.fPresentation;
    }

    protected void setTreeColumns(String[] columns) {
        this.setTreeColumns(columns, null, 0);
    }

    protected void setTreeColumns(String[] columns, Comparator<ITimeGraphEntry>[] comparators, int initialSortColumn) {
        this.checkPartNotCreated();
        this.fColumns = columns != null ? Arrays.copyOf(columns, columns.length) : columns;
        this.fColumnComparators = comparators != null ? Arrays.copyOf(comparators, comparators.length) : comparators;
        this.fInitialSortColumn = initialSortColumn;
    }

    protected void setTreeLabelProvider(TreeLabelProvider tlp) {
        this.checkPartNotCreated();
        this.fLabelProvider = tlp;
    }

    protected void setTimeGraphContentProvider(@NonNull ITimeGraphContentProvider tgcp) {
        this.checkPartNotCreated();
        this.fTimeGraphContentProvider = tgcp;
    }

    protected void setWeight(int[] weights) {
        this.fWeight = Arrays.copyOf(weights, weights.length);
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.setWeights(weights);
        }
    }

    protected void setFilterColumns(String[] filterColumns) {
        this.checkPartNotCreated();
        this.fFilterColumns = Arrays.copyOf(filterColumns, filterColumns.length);
    }

    protected void setFilterContentProvider(ITreeContentProvider contentProvider) {
        this.checkPartNotCreated();
        this.fFilterContentProvider = contentProvider;
    }

    protected void setFilterLabelProvider(TreeLabelProvider labelProvider) {
        this.checkPartNotCreated();
        this.fFilterLabelProvider = labelProvider;
    }

    private void checkPartNotCreated() {
        if (this.getParentComposite() != null) {
            throw new IllegalStateException("This method must be called before createPartControl.");
        }
    }

    protected int getDisplayWidth() {
        return this.fDisplayWidth;
    }

    protected Comparator<ITimeGraphEntry> getEntryComparator() {
        return this.fEntryComparator;
    }

    protected void setEntryComparator(Comparator<ITimeGraphEntry> comparator) {
        this.fEntryComparator = comparator;
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    protected long getStartTime() {
        return this.fStartTime;
    }

    protected void setStartTime(long time) {
        this.fStartTime = time;
    }

    protected long getEndTime() {
        return this.fEndTime;
    }

    protected void setEndTime(long time) {
        this.fEndTime = time;
    }

    protected void setAutoExpandLevel(int level) {
        this.fAutoExpandLevel = level;
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.setAutoExpandLevel(level);
        }
    }

    protected void setTimeFormat(Utils.TimeFormat timeFormat) {
        this.fTimeFormat = timeFormat;
        if (this.fTimeGraphViewer != null) {
            this.updateTimeFormat();
            this.fTimeGraphViewer.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable List<@NonNull TimeGraphEntry> getEntryList(ITmfTrace trace) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            return this.fEntryListMap.get(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, List<@NonNull TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEntryList(ITmfTrace trace, List<@NonNull TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList == null) {
                this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                for (TimeGraphEntry entry : list) {
                    if (entryList.contains(entry)) continue;
                    entryList.add(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList != null) {
                entryList.removeAll(list);
            }
        }
    }

    protected String getNextText() {
        return Messages.AbstractTimeGraphtView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.AbstractTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.AbstractTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.AbstractTimeGraphView_PreviousTooltip;
    }

    FindTarget getFindTarget() {
        return this.fFindTarget;
    }

    public void setLegendProvider(ITimeGraphLegendProvider legendProvider) {
        this.fLegendProvider = legendProvider;
    }

    @Override
    public void createPartControl(Composite parent) {
        Action timeEventFilterAction;
        TimeGraphViewer timeGraphViewer;
        super.createPartControl(parent);
        this.fTimeGraphViewer = timeGraphViewer = new TimeGraphViewer(parent, 0);
        if (this.fLabelProvider != null) {
            timeGraphViewer.setTimeGraphLabelProvider(this.fLabelProvider);
        }
        if (this.fLegendProvider != null) {
            timeGraphViewer.setLegendProvider(this.fLegendProvider);
        }
        if (this.fColumns != null) {
            timeGraphViewer.setColumns(this.fColumns);
            if (this.fColumnComparators != null) {
                this.createColumnSelectionListener(timeGraphViewer.getTree());
            }
        }
        timeGraphViewer.setTimeGraphContentProvider(this.fTimeGraphContentProvider);
        timeGraphViewer.setFilterContentProvider((ITreeContentProvider)(this.fFilterContentProvider != null ? this.fFilterContentProvider : this.fTimeGraphContentProvider));
        timeGraphViewer.setFilterLabelProvider(this.fFilterLabelProvider);
        timeGraphViewer.setFilterColumns(this.fFilterColumns);
        timeGraphViewer.addSelectionListener(this.fMetadataSelectionListener);
        ITimeGraphPresentationProvider presentationProvider = this.getPresentationProvider();
        timeGraphViewer.setTimeGraphProvider(presentationProvider);
        presentationProvider.addColorListener(stateItems -> TimeGraphStyleUtil.loadValues(this.getPresentationProvider()));
        presentationProvider.refresh();
        timeGraphViewer.setAutoExpandLevel(this.fAutoExpandLevel);
        timeGraphViewer.setWeights(this.fWeight);
        final TimeGraphControl timeGraphControl = timeGraphViewer.getTimeGraphControl();
        this.fTimeEventFilterAction = timeEventFilterAction = new Action(){

            public void run() {
                int xCoord = timeGraphControl.toControl((Point)timeGraphControl.getDisplay().getCursorLocation()).x;
                if (timeGraphViewer.getNameSpace() < xCoord && xCoord < timeGraphControl.getSize().x) {
                    if (AbstractTimeGraphView.this.fTimeEventFilterDialog != null) {
                        AbstractTimeGraphView.this.fTimeEventFilterDialog.close();
                        AbstractTimeGraphView.this.fTimeEventFilterDialog = null;
                    }
                    AbstractTimeGraphView.this.fTimeEventFilterDialog = new TimeEventFilterDialog(timeGraphControl.getShell(), AbstractTimeGraphView.this, AbstractTimeGraphView.this.getTimeGraphViewer().getTimeGraphControl());
                    AbstractTimeGraphView.this.fTimeEventFilterDialog.open();
                }
            }
        };
        timeGraphViewer.addRangeListener(event -> {
            long startTime = event.getStartTime();
            long endTime = event.getEndTime();
            TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)startTime), TmfTimestamp.fromNanos((long)endTime));
            this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range, this.fTrace));
            this.startZoomThread(startTime, endTime);
        });
        timeGraphViewer.addTimeListener(event -> {
            ITmfTimestamp startTime = TmfTimestamp.fromNanos((long)event.getBeginTime());
            ITmfTimestamp endTime = TmfTimestamp.fromNanos((long)event.getEndTime());
            this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, startTime, endTime, this.fTrace));
        });
        timeGraphViewer.addBookmarkListener(new ITimeGraphBookmarkListener(){

            @Override
            public void bookmarkAdded(final TimeGraphBookmarkEvent event) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            IMarkerEvent bookmark = event.getBookmark();
                            IFile editorFile = (this).AbstractTimeGraphView.this.fEditorFile;
                            if (editorFile == null) {
                                return;
                            }
                            IMarker marker = editorFile.createMarker("org.eclipse.core.resources.bookmark");
                            marker.setAttribute("message", (Object)bookmark.getLabel());
                            marker.setAttribute("time", (Object)Long.toString(bookmark.getTime()));
                            if (bookmark.getDuration() > 0L) {
                                marker.setAttribute("duration", (Object)Long.toString(bookmark.getDuration()));
                                marker.setAttribute("location", (Object)NLS.bind((String)org.eclipse.tracecompass.internal.tmf.ui.Messages.TmfMarker_LocationTimeRange, (Object)TmfTimestamp.fromNanos((long)bookmark.getTime()), (Object)TmfTimestamp.fromNanos((long)(bookmark.getTime() + bookmark.getDuration()))));
                            } else {
                                marker.setAttribute("location", (Object)NLS.bind((String)org.eclipse.tracecompass.internal.tmf.ui.Messages.TmfMarker_LocationTime, (Object)TmfTimestamp.fromNanos((long)bookmark.getTime())));
                            }
                            marker.setAttribute("color", (Object)bookmark.getColor().toString());
                        }
                    }, null);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
            }

            @Override
            public void bookmarkRemoved(TimeGraphBookmarkEvent event) {
                try {
                    IMarker[] markers;
                    IMarkerEvent bookmark = event.getBookmark();
                    IFile editorFile = AbstractTimeGraphView.this.fEditorFile;
                    if (editorFile == null) {
                        return;
                    }
                    IMarker[] iMarkerArray = markers = editorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        if (bookmark.getLabel().equals(marker.getAttribute("message")) && Long.toString(bookmark.getTime()).equals(marker.getAttribute("time", null)) && Long.toString(bookmark.getDuration()).equals(marker.getAttribute("duration", Long.toString(0L))) && bookmark.getColor().toString().equals(marker.getAttribute("color"))) {
                            marker.delete();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
            }
        });
        this.fTimeGraphViewer.addMarkerListener(this::restartZoomThread);
        timeGraphControl.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TmfUiRefreshHandler.getInstance().queueUpdate(this, () -> {
                    if (timeGraphControl.isDisposed()) {
                        return;
                    }
                    int timeSpace = AbstractTimeGraphView.this.getTimeGraphViewer().getTimeSpace();
                    Set<@NonNull TimeGraphEntry> newSet = AbstractTimeGraphView.this.getVisibleItems(3);
                    if (AbstractTimeGraphView.this.fPrevTimeSpace != timeSpace || !AbstractTimeGraphView.this.fVisibleEntries.equals(newSet)) {
                        AbstractTimeGraphView.this.fVisibleEntries = newSet;
                        AbstractTimeGraphView.this.fPrevTimeSpace = timeSpace;
                        AbstractTimeGraphView.this.startZoomThread(AbstractTimeGraphView.this.getTimeGraphViewer().getTime0(), AbstractTimeGraphView.this.getTimeGraphViewer().getTime1());
                    }
                });
            }
        });
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        timeGraphControl.setStatusLineManager(statusLineManager);
        this.makeActions();
        this.contributeToActionBars();
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider(timeGraphViewer.getSelectionProvider());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.createContextMenu();
        this.fPartListener = new TimeGraphPartListener();
        site.getPage().addPartListener((IPartListener)this.fPartListener);
        this.fPartListener2 = new TimeGraphPartListener2();
        site.getPage().addPartListener((IPartListener2)this.fPartListener2);
        this.fOriginalTabLabel = this.getPartName();
        this.fContextService = (IContextService)site.getWorkbenchWindow().getService(IContextService.class);
        if (timeGraphControl.isInFocus()) {
            this.activateContextService();
        }
        timeGraphControl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                AbstractTimeGraphView.this.deactivateContextService();
            }

            public void focusGained(FocusEvent e) {
                AbstractTimeGraphView.this.activateContextService();
            }
        });
        this.updateTimeFormat();
    }

    private void activateContextService() {
        if (this.fActiveContexts.isEmpty()) {
            this.fActiveContexts.add(this.fContextService.activateContext(TIMEGRAPH_UI_CONTEXT));
            this.fActiveContexts.add(this.fContextService.activateContext(TMF_VIEW_UI_CONTEXT));
        }
    }

    private void deactivateContextService() {
        this.fContextService.deactivateContexts(this.fActiveContexts);
        this.fActiveContexts.clear();
    }

    protected @NonNull Set<@NonNull TimeGraphEntry> getVisibleItems(int buffer) {
        TimeGraphControl timeGraphControl = this.fTimeGraphViewer.getTimeGraphControl();
        if (timeGraphControl.isDisposed()) {
            return Collections.emptySet();
        }
        int start = Integer.max(0, this.fTimeGraphViewer.getTopIndex() - buffer);
        int end = Integer.min(this.fTimeGraphViewer.getExpandedElementCount() - 1, this.fTimeGraphViewer.getTopIndex() + timeGraphControl.countPerPage() + buffer);
        HashSet<@NonNull TimeGraphEntry> visible = new HashSet<TimeGraphEntry>(end - start + 1);
        int i = start;
        while (i <= end) {
            TimeGraphEntry element = (TimeGraphEntry)timeGraphControl.getExpandedElement(i);
            if (element != null) {
                visible.add(element);
            }
            ++i;
        }
        return visible;
    }

    public void setFocus() {
        this.fTimeGraphViewer.setFocus();
        this.activateContextService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Map<ITmfTrace, Job> map = this.fBuildJobMap;
        synchronized (map) {
            this.fBuildJobMap.values().forEach(Job::cancel);
        }
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        this.deactivateContextService();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        IWorkbenchPage page = this.getSite().getPage();
        if (this.fPartListener != null) {
            page.removePartListener((IPartListener)this.fPartListener);
        }
        if (this.fPartListener2 != null) {
            page.removePartListener((IPartListener2)this.fPartListener2);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fEditorFile)) {
                this.fTimeGraphViewer.setBookmarks(AbstractTimeGraphView.refreshBookmarks(this.fEditorFile));
                this.redraw();
                return;
            }
            ++n2;
        }
    }

    private static List<IMarkerEvent> refreshBookmarks(IFile editorFile) {
        ArrayList<IMarkerEvent> bookmarks = new ArrayList<IMarkerEvent>();
        if (editorFile == null || !editorFile.exists()) {
            return bookmarks;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = editorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                IMarker marker = iMarkerArray[n2];
                String label = marker.getAttribute("message", null);
                String time = marker.getAttribute("time", null);
                String duration = marker.getAttribute("duration", Long.toString(0L));
                String rgba = marker.getAttribute("color", null);
                if (label != null && time != null && rgba != null && (matcher = RGBA_PATTERN.matcher(rgba)).matches()) {
                    try {
                        int red = Integer.valueOf(matcher.group(1));
                        int green = Integer.valueOf(matcher.group(2));
                        int blue = Integer.valueOf(matcher.group(3));
                        int alpha = Integer.valueOf(matcher.group(4));
                        RGBA color = new RGBA(red, green, blue, alpha);
                        bookmarks.add(new MarkerEvent(null, Long.valueOf(time), Long.valueOf(duration), IMarkerEvent.BOOKMARKS, color, label, true));
                    }
                    catch (NumberFormatException e) {
                        Activator.getDefault().logError(e.getMessage());
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage());
        }
        return bookmarks;
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        this.resetView(signal.getTrace());
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fEditorFile = null;
            this.setStartTime(-1L);
            this.setEndTime(-1L);
            if (this.isPinned()) {
                this.setPinned(null);
            } else {
                this.refresh();
            }
        }
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.setTimeBoundsAndRefresh();
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        ITmfTrace trace = this.fTrace;
        if (signal.getSource() == this || trace == null) {
            return;
        }
        ITmfTrace signalTrace = signal.getTrace();
        if (signalTrace != null && !TmfTraceManager.getInstance().isSynchronized(trace, signalTrace)) {
            return;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(trace);
        long beginTime = ctx.getSelectionRange().getStartTime().toNanos();
        long endTime = ctx.getSelectionRange().getEndTime().toNanos();
        Display.getDefault().asyncExec(() -> {
            if (this.fTimeGraphViewer.getControl().isDisposed()) {
                return;
            }
            if (beginTime == endTime) {
                this.fTimeGraphViewer.setSelectedTime(beginTime, true);
            } else {
                this.fTimeGraphViewer.setSelectionRange(beginTime, endTime, true);
            }
            this.synchingToTime(this.fTimeGraphViewer.getSelectionBegin());
        });
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext((ITmfTrace)NonNullUtils.checkNotNull((Object)this.fTrace));
        long startTime = ctx.getWindowRange().getStartTime().toNanos();
        long endTime = ctx.getWindowRange().getEndTime().toNanos();
        Display.getDefault().asyncExec(() -> {
            if (this.fTimeGraphViewer.getControl().isDisposed()) {
                return;
            }
            if (startTime == this.fTimeGraphViewer.getTime0() && endTime == this.fTimeGraphViewer.getTime1()) {
                return;
            }
            this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
            this.startZoomThread(startTime, endTime);
        });
    }

    @TmfSignalHandler
    public void updateTimeFormat(TmfTimestampFormatUpdateSignal signal) {
        this.updateTimeFormat();
        this.fTimeGraphViewer.refresh();
    }

    @TmfSignalHandler
    public void markerEventSourceUpdated(TmfMarkerEventSourceUpdatedSignal signal) {
        this.getTimeGraphViewer().setMarkerCategories(this.getMarkerCategories());
        this.getTimeGraphViewer().setMarkers(null);
        this.refresh();
    }

    private void updateTimeFormat() {
        if (this.fTimeFormat == null) {
            String datime = (String)TmfTimePreferences.getPreferenceMap().get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime");
            if ("TTT".equals(datime)) {
                this.fTimeGraphViewer.setTimeFormat(Utils.TimeFormat.RELATIVE);
            } else {
                this.fTimeGraphViewer.setTimeFormat(Utils.TimeFormat.CALENDAR);
            }
        } else {
            this.fTimeGraphViewer.setTimeFormat(this.fTimeFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace(ITmfTrace trace) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
        if (this.fTrace != null) {
            this.fFiltersMap.put(this.fTrace, this.fTimeGraphViewer.getFilters());
            this.fViewContext.put(this.fTrace, new ViewContext(this.fCurrentSortColumn, this.fSortDirection, this.fTimeGraphViewer.getSelection(), this.fTimeGraphViewer.getAllCollapsedElements(), this.fIsHideRowsFilterActive));
        }
        this.fTrace = trace;
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"TimeGraphView:LoadingTrace", (Object[])new Object[]{"trace", trace.getName(), "viewId", this.getViewId()});
        this.restoreViewContext();
        this.applyHideEmptyRowsFilterContext();
        this.fEditorFile = TmfTraceManager.getInstance().getTraceEditorFile(trace);
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            this.loadingTrace(trace);
            if (this.fEntryList == null) {
                this.rebuild();
            } else {
                this.setTimeBoundsAndRefresh();
            }
        }
        this.getPresentationProvider().refresh();
    }

    private void setTimeBoundsAndRefresh() {
        this.setStartTime(this.fTrace.getStartTime().toNanos());
        this.setEndTime(this.fTrace.getEndTime().toNanos());
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void rebuild() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (final TraceCompassLogUtils.FlowScopeLog parentLogger = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:Rebuilding", new Object[0]).setCategory(this.getViewId()).build();){
            this.setTimeBoundsAndRefresh();
            final ITmfTrace viewTrace = this.fTrace;
            if (viewTrace == null) {
                return;
            }
            this.resetView(viewTrace);
            ArrayList<AnnotationMarkerEventSource> markerEventSources = new ArrayList<AnnotationMarkerEventSource>();
            Map<ITmfTrace, Job> map = this.fBuildJobMap;
            synchronized (map) {
                IWorkbenchSiteProgressService service = null;
                IWorkbenchPartSite site = this.getSite();
                if (site != null) {
                    service = (IWorkbenchSiteProgressService)site.getService(IWorkbenchSiteProgressService.class);
                }
                markerEventSources.add(new AnnotationMarkerEventSource((IOutputAnnotationProvider)new TraceAnnotationProvider(viewTrace)));
                for (final ITmfTrace trace : this.getTracesToBuild(viewTrace)) {
                    if (trace == null) break;
                    @NonNull List adapters = TmfTraceAdapterManager.getAdapters((ITmfTrace)trace, IMarkerEventSource.class);
                    markerEventSources.addAll(adapters);
                    Job buildJob = new Job(this.getTitle() + Messages.AbstractTimeGraphView_BuildJob){

                        protected IStatus run(IProgressMonitor monitor) {
                            new BuildRunnable(trace, viewTrace, parentLogger).run(monitor);
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    this.fBuildJobMap.put(trace, buildJob);
                    if (service != null) {
                        service.schedule(buildJob);
                        continue;
                    }
                    buildJob.schedule();
                }
            }
            this.fMarkerEventSourcesMap.put(viewTrace, markerEventSources);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void synchingToTime(long time) {
    }

    protected void loadingTrace(@NonNull ITmfTrace trace) {
    }

    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return TmfTraceManager.getTraceSet((ITmfTrace)trace);
    }

    protected abstract void buildEntryList(@NonNull ITmfTrace var1, @NonNull ITmfTrace var2, @NonNull IProgressMonitor var3);

    protected @Nullable List<@NonNull ITimeEvent> getEventList(@NonNull TimeGraphEntry entry, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ITimeEvent>();
    }

    protected @Nullable List<@NonNull ILinkEvent> getLinkList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected @NonNull List<String> getViewMarkerCategories() {
        return new ArrayList<String>();
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(Iterable<@NonNull TimeGraphEntry> entries, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<IMarkerEvent>();
    }

    protected @NonNull List<IMarkerEvent> getTraceMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        for (IMarkerEventSource markerEventSource : this.getMarkerEventSources(this.fTrace)) {
            markers.addAll(markerEventSource.getMarkerList(startTime, endTime, resolution, monitor));
        }
        return markers;
    }

    protected @NonNull List<String> getMarkerCategories() {
        LinkedHashSet<String> categories = new LinkedHashSet<String>(this.getViewMarkerCategories());
        for (IMarkerEventSource markerEventSource : this.getMarkerEventSources(this.fTrace)) {
            categories.addAll(markerEventSource.getMarkerCategories());
        }
        return new ArrayList<String>(categories);
    }

    private @NonNull List<IMarkerEventSource> getMarkerEventSources(ITmfTrace trace) {
        List<IMarkerEventSource> markerEventSources = this.fMarkerEventSourcesMap.get(trace);
        if (markerEventSources == null) {
            markerEventSources = Collections.emptyList();
        }
        return markerEventSources;
    }

    protected @NonNull Map<ITmfTrace, ViewerFilter[]> getFiltersMap() {
        return (Map)NonNullUtils.checkNotNull(this.fFiltersMap);
    }

    protected void refresh() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog parentLogger = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "RefreshRequested", new Object[0]).setCategory(this.getViewId()).build();){
            boolean isZoomThread = Thread.currentThread() instanceof ZoomThread;
            TmfUiRefreshHandler.getInstance().queueUpdate(this, () -> {
                Throwable throwable = null;
                Object var4_5 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:Refresh", new Object[0]).setParentScope(parentLogger).build();){
                    if (this.fTimeGraphViewer.getControl().isDisposed()) {
                        return;
                    }
                    this.fDirty.incrementAndGet();
                    try {
                        long endTime;
                        boolean inputChanged;
                        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
                        synchronized (map) {
                            this.fEntryList = this.fEntryListMap.get(this.fTrace);
                            if (this.fEntryList == null) {
                                this.fEntryList = new CopyOnWriteArrayList<TimeGraphEntry>();
                            } else if (this.fEntryComparator != null) {
                                ArrayList<TimeGraphEntry> list = new ArrayList<TimeGraphEntry>(this.fEntryList);
                                Collections.sort(list, this.fEntryComparator);
                                for (ITimeGraphEntry iTimeGraphEntry : list) {
                                    AbstractTimeGraphView.sortChildren(iTimeGraphEntry, this.fEntryComparator);
                                }
                                this.fEntryList.clear();
                                this.fEntryList.addAll(list);
                            }
                        }
                        boolean bl2 = inputChanged = this.fEntryList != this.fTimeGraphViewer.getInput();
                        if (inputChanged) {
                            this.fTimeGraphViewer.setInput(this.fEntryList);
                            this.fTimeGraphViewer.setFilters(this.fFiltersMap.get(this.fTrace));
                            this.fTimeGraphViewer.setLinks(null);
                            this.fTimeGraphViewer.setBookmarks(AbstractTimeGraphView.refreshBookmarks(this.fEditorFile));
                            this.fTimeGraphViewer.setMarkerCategories(this.getMarkerCategories());
                            this.fTimeGraphViewer.setMarkers(null);
                            this.applyViewContext();
                        } else {
                            this.fTimeGraphViewer.refresh();
                        }
                        if (this.fIsRevealSelection) {
                            this.fIsRevealSelection = false;
                            this.fTimeGraphViewer.setSelection(this.fTimeGraphViewer.getSelection(), true);
                        }
                        long startBound = this.fStartTime == Long.MAX_VALUE ? -1L : this.fStartTime;
                        long endBound = this.fEndTime == Long.MIN_VALUE ? -1L : this.fEndTime;
                        this.fTimeGraphViewer.setTimeBounds(startBound, endBound);
                        ITmfTrace trace = this.fTrace;
                        TmfTraceContext ctx = trace == null ? null : TmfTraceManager.getInstance().getTraceContext(trace);
                        long selectionBeginTime = ctx == null ? -1L : ctx.getSelectionRange().getStartTime().toNanos();
                        long selectionEndTime = ctx == null ? -1L : ctx.getSelectionRange().getEndTime().toNanos();
                        long startTime = ctx == null ? -1L : ctx.getWindowRange().getStartTime().toNanos();
                        long l = endTime = ctx == null ? -1L : ctx.getWindowRange().getEndTime().toNanos();
                        if (this.fStartTime > this.fEndTime) {
                            startTime = -1L;
                            endTime = -1L;
                        } else {
                            startTime = Math.min(Math.max(startTime, this.fStartTime), this.fEndTime);
                            endTime = Math.min(Math.max(endTime, this.fStartTime), this.fEndTime);
                        }
                        this.fTimeGraphViewer.setSelectionRange(selectionBeginTime, selectionEndTime, false);
                        this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
                        if (inputChanged && selectionBeginTime != -1L) {
                            this.synchingToTime(selectionBeginTime);
                        }
                        ZoomThread zoomThread = this.fZoomThread;
                        if (!isZoomThread || zoomThread != null && (zoomThread.getZoomStartTime() != startTime || zoomThread.getZoomEndTime() != endTime)) {
                            this.startZoomThread(startTime, endTime);
                        }
                    }
                    finally {
                        if (this.fDirty.decrementAndGet() < 0) {
                            Activator.getDefault().logError(DIRTY_UNDERFLOW_ERROR, new Throwable());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        object = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog flowParent = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "RedrawRequested", new Object[0]).setCategory(this.getViewId()).build();){
            Display.getDefault().asyncExec(() -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:Redraw", new Object[0]).setParentScope(flowParent).build();){
                    if (this.fTimeGraphViewer.getControl().isDisposed()) {
                        return;
                    }
                    this.fTimeGraphViewer.getControl().redraw();
                    this.fTimeGraphViewer.getControl().update();
                    Object object = this.fSyncObj;
                    synchronized (object) {
                        if (this.fRedrawState == State.PENDING) {
                            this.fRedrawState = State.IDLE;
                            this.redraw();
                        } else {
                            this.fRedrawState = State.IDLE;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private static void sortChildren(ITimeGraphEntry entry, Comparator<ITimeGraphEntry> comparator) {
        if (entry instanceof TimeGraphEntry) {
            ((TimeGraphEntry)entry).sortChildren(comparator);
        }
        for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
            AbstractTimeGraphView.sortChildren(iTimeGraphEntry, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startZoomThread(long startTime, long endTime) {
        block20: {
            try {
                Throwable throwable = null;
                Object var6_5 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:ZoomThreadCreated", new Object[0]).setCategory(this.getViewId()).build();){
                    int timeSpace;
                    long clampedStartTime = this.fStartTime == Long.MAX_VALUE ? startTime : Math.min(Math.max(startTime, this.fStartTime), this.fEndTime);
                    long clampedEndTime = this.fEndTime == Long.MIN_VALUE ? endTime : Math.max(Math.min(endTime, this.fEndTime), this.fStartTime);
                    this.fDirty.incrementAndGet();
                    boolean restart = false;
                    ZoomThread zoomThread = this.fZoomThread;
                    if (zoomThread != null) {
                        zoomThread.cancel();
                        if (zoomThread.fZoomStartTime == clampedStartTime && zoomThread.fZoomEndTime == clampedEndTime) {
                            restart = true;
                        }
                    }
                    if ((timeSpace = this.getTimeGraphViewer().getTimeSpace()) > 0) {
                        long resolution = Long.max(1L, (clampedEndTime - clampedStartTime) / (long)timeSpace);
                        zoomThread = this.createZoomThread(clampedStartTime, clampedEndTime, resolution, restart);
                    } else {
                        zoomThread = null;
                    }
                    this.fZoomThread = zoomThread;
                    if (zoomThread == null) break block20;
                    zoomThread.setScopeId(log.getId());
                    Object object = this.fZoomThreadResultLock;
                    synchronized (object) {
                        zoomThread.start();
                        this.fDirty.incrementAndGet();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (this.fDirty.decrementAndGet() < 0) {
                    Activator.getDefault().logError(DIRTY_UNDERFLOW_ERROR, new Throwable());
                }
            }
        }
    }

    protected @Nullable ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        return new ZoomThreadByEntry(this.getVisibleItems(3), startTime, endTime, resolution);
    }

    private void makeActions() {
        this.fPreviousResourceAction = this.fTimeGraphViewer.getPreviousItemAction();
        this.fPreviousResourceAction.setText(this.getPrevText());
        this.fPreviousResourceAction.setToolTipText(this.getPrevTooltip());
        this.fNextResourceAction = this.fTimeGraphViewer.getNextItemAction();
        this.fNextResourceAction.setText(this.getNextText());
        this.fNextResourceAction.setToolTipText(this.getNextTooltip());
    }

    protected Action getShowLabelsAction() {
        Action showLabelsAction = new Action(Messages.AbstractTimeGraphView_ShowLabelsActionText, 2){

            public void run() {
                boolean showLabels = this.isChecked();
                AbstractTimeGraphView.this.getTimeGraphViewer().setLabelsVisible(showLabels);
                AbstractTimeGraphView.this.redraw();
                IDialogSettings dialogSettings = AbstractTimeGraphView.this.getDialogSettings(true);
                dialogSettings.put(AbstractTimeGraphView.HIDE_LABELS_KEY, !showLabels);
            }
        };
        boolean showLabels = true;
        IDialogSettings dialogSettings = this.getDialogSettings(false);
        if (dialogSettings != null) {
            showLabels = !dialogSettings.getBoolean(HIDE_LABELS_KEY);
        }
        showLabelsAction.setChecked(showLabels);
        this.getTimeGraphViewer().setLabelsVisible(showLabels);
        return showLabelsAction;
    }

    protected Action getHideEmptyRowsAction() {
        HideEmptyRowsAction hideEmptyRowsAction = this.fHideEmptyRowsAction;
        if (hideEmptyRowsAction == null) {
            this.fHideEmptyRowsAction = hideEmptyRowsAction = new HideEmptyRowsAction();
        }
        return hideEmptyRowsAction;
    }

    private IDialogSettings getDialogSettings(boolean force) {
        String sectionName;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName = this.getViewSite().getId());
        if (section == null && force) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected MenuManager getMarkerSetMenu() {
        if (this.fMarkerSetMenu != null) {
            return this.fMarkerSetMenu;
        }
        this.fMarkerSetMenu = new MenuManager(Messages.AbstractTimeGraphView_MarkerSetMenuText);
        this.fMarkerSetMenu.setRemoveAllWhenShown(true);
        this.fMarkerSetMenu.addMenuListener(mgr -> {
            MarkerSetAction noneAction = new MarkerSetAction(null);
            MarkerSet defaultMarkerSet = MarkerUtils.getDefaultMarkerSet();
            String defaultMarkerSetId = defaultMarkerSet == null ? null : defaultMarkerSet.getId();
            noneAction.setChecked(defaultMarkerSetId == null);
            mgr.add((IAction)noneAction);
            List markerSets = MarkerConfigXmlParser.getMarkerSets();
            for (MarkerSet markerSet : markerSets) {
                MarkerSetAction action = new MarkerSetAction(markerSet);
                action.setChecked(markerSet.getId().equals(defaultMarkerSetId));
                mgr.add((IAction)action);
            }
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new Action(Messages.AbstractTimeGraphView_MarkerSetEditActionText){

                public void run() {
                    MarkerConfigXmlParser.initMarkerSets();
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(MarkerConfigXmlParser.MARKER_CONFIG_PATH);
                    try {
                        AbstractTimeGraphView.this.getTimeGraphViewer().getTimeGraphControl().notifyListeners(16, null);
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().logError("Error opening editor on " + String.valueOf(MarkerConfigXmlParser.MARKER_CONFIG_PATH), e);
                    }
                }
            });
        });
        return this.fMarkerSetMenu;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalMenu(bars.getMenuManager());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.appendToGroup("additions", (IAction)this.getHideEmptyRowsAction());
        if (this.fFilterColumns != null && this.fFilterLabelProvider != null && this.fFilterColumns.length > 0) {
            manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getShowFilterDialogAction());
        }
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getShowLegendAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getResetScaleAction());
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getPreviousEventAction());
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getNextEventAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getToggleBookmarkAction());
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getPreviousMarkerAction());
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getNextMarkerAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.fPreviousResourceAction);
        manager.appendToGroup("additions", (IAction)this.fNextResourceAction);
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getZoomInAction());
        manager.appendToGroup("additions", (IAction)this.fTimeGraphViewer.getZoomOutAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IContributionItem)this.fTimeGraphViewer.getGridlinesMenu());
        manager.add((IAction)this.getShowLabelsAction());
        manager.add((IContributionItem)this.fTimeGraphViewer.getMarkersMenu());
        manager.add((IContributionItem)this.getMarkerSetMenu());
        manager.add((IAction)this.getHideEmptyRowsAction());
    }

    @Override
    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fTimeGraphViewer == null) {
            return null;
        }
        return this.fTimeGraphViewer.getTimeViewAlignmentInfo();
    }

    @Override
    public int getAvailableWidth(int requestedOffset) {
        if (this.fTimeGraphViewer == null) {
            return 0;
        }
        return this.fTimeGraphViewer.getAvailableWidth(requestedOffset);
    }

    @Override
    public void performAlign(int offset, int width) {
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.performAlign(offset, width);
        }
    }

    @Override
    public synchronized void setPinned(ITmfTrace trace) {
        if (trace != null) {
            TmfSignalManager.addIgnoredInboundSignal((Object)this, TmfTraceOpenedSignal.class);
            TmfSignalManager.addIgnoredInboundSignal((Object)this, TmfTraceSelectedSignal.class);
            this.setPartName(String.format("%s <%s>", this.fOriginalTabLabel, TmfTraceManager.getInstance().getTraceUniqueName(trace)));
            if (!trace.equals(this.fTrace)) {
                this.loadTrace(trace);
            }
        } else {
            TmfSignalManager.removeIgnoredInboundSignal((Object)this, TmfTraceOpenedSignal.class);
            TmfSignalManager.removeIgnoredInboundSignal((Object)this, TmfTraceSelectedSignal.class);
            this.setPartName(this.fOriginalTabLabel);
            ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
            if (activeTrace != null && !activeTrace.equals(this.fTrace)) {
                this.loadTrace(activeTrace);
            } else {
                this.refresh();
            }
        }
        if (this.fPinAction != null) {
            this.fPinAction.setPinnedTrace(trace);
        }
    }

    public boolean isDirty() {
        if (this.fTrace == null) {
            return false;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        long startTime = ctx.getWindowRange().getStartTime().toNanos();
        long endTime = ctx.getWindowRange().getEndTime().toNanos();
        if (this.fTimeGraphViewer.getTime0() != startTime || this.fTimeGraphViewer.getTime1() != endTime) {
            return true;
        }
        if (this.fZoomThread == null) {
            return this.fDirty.get() != 0;
        }
        return this.fDirty.get() != 0 || this.fZoomThread.getZoomStartTime() != startTime || this.fZoomThread.getZoomEndTime() != endTime;
    }

    private void createColumnSelectionListener(final Tree tree) {
        int i = 0;
        while (i < this.fColumnComparators.length) {
            final int index = i;
            final Comparator<ITimeGraphEntry> comp = this.fColumnComparators[index];
            final TreeColumn column = tree.getColumn(i);
            if (comp != null) {
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TreeColumn prevSortcolumn = tree.getSortColumn();
                        int direction = tree.getSortDirection();
                        direction = prevSortcolumn == column ? (direction == 1024 ? 128 : 1024) : 1024;
                        tree.setSortColumn(column);
                        tree.setSortDirection(direction);
                        AbstractTimeGraphView.this.fSortDirection = direction;
                        AbstractTimeGraphView.this.fCurrentSortColumn = index;
                        Comparator comparator = comp;
                        if (comparator instanceof ITimeGraphEntryComparator) {
                            ((ITimeGraphEntryComparator)comparator).setDirection(direction);
                        }
                        if (direction != 1024) {
                            comparator = (Comparator)NonNullUtils.checkNotNull(Collections.reverseOrder(comparator));
                        }
                        AbstractTimeGraphView.this.setEntryComparator(comparator);
                        AbstractTimeGraphView.this.fIsRevealSelection = true;
                        AbstractTimeGraphView.this.fTimeGraphViewer.getControl().setFocus();
                        AbstractTimeGraphView.this.refresh();
                    }
                });
            }
            ++i;
        }
    }

    private void restoreViewContext() {
        ViewContext viewContext = this.fViewContext.get(this.fTrace);
        if (this.fColumnComparators != null) {
            this.fSortDirection = 1024;
            this.fCurrentSortColumn = this.fInitialSortColumn;
            if (viewContext != null) {
                this.fSortDirection = viewContext.getSortDirection();
                this.fCurrentSortColumn = viewContext.getSortColumn();
            }
            if (this.fCurrentSortColumn < this.fColumnComparators.length && this.fColumnComparators[this.fCurrentSortColumn] != null) {
                Comparator comparator = this.fColumnComparators[this.fCurrentSortColumn];
                if (comparator instanceof ITimeGraphEntryComparator) {
                    ((ITimeGraphEntryComparator)comparator).setDirection(this.fSortDirection);
                }
                if (this.fSortDirection != 1024) {
                    comparator = (Comparator)NonNullUtils.checkNotNull(Collections.reverseOrder(comparator));
                }
                this.setEntryComparator(comparator);
            }
        }
        this.fIsHideRowsFilterActive = viewContext == null ? false : viewContext.isHideRowFilterActive();
    }

    private void applyViewContext() {
        ViewContext viewContext = this.fViewContext.remove(this.fTrace);
        this.applyExpandedStateContext(viewContext);
        if (this.fColumnComparators != null) {
            Tree tree = this.fTimeGraphViewer.getTree();
            TreeColumn column = tree.getColumn(this.fCurrentSortColumn);
            tree.setSortDirection(this.fSortDirection);
            tree.setSortColumn(column);
        }
        if (viewContext != null && viewContext.getSelection() != null) {
            this.fTimeGraphViewer.setSelection(viewContext.getSelection(), true);
        }
    }

    private void applyExpandedStateContext(ViewContext viewContext) {
        if (viewContext != null) {
            this.fTimeGraphViewer.expandAll();
            this.fTimeGraphViewer.setExpandedState(viewContext.getCollapsedEntries(), false);
        }
    }

    private void applyHideEmptyRowsFilterContext() {
        if (this.fHideEmptyRowsAction != null) {
            this.fHideEmptyRowsAction.setChecked(this.fIsHideRowsFilterActive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetView(ITmfTrace viewTrace) {
        if (viewTrace == null) {
            return;
        }
        Map<ITmfTrace, Object> map = this.fBuildJobMap;
        synchronized (map) {
            for (ITmfTrace trace : this.getTracesToBuild(viewTrace)) {
                Job buildJob = this.fBuildJobMap.remove(trace);
                if (buildJob == null) continue;
                buildJob.cancel();
            }
        }
        map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.remove(viewTrace);
        }
        this.fViewContext.remove(viewTrace);
        this.fFiltersMap.remove(viewTrace);
        this.fMarkerEventSourcesMap.remove(viewTrace);
        if (viewTrace == this.fTrace && this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
    }

    private void createContextMenu() {
        this.fEntryMenuManager.setRemoveAllWhenShown(true);
        TimeGraphControl timeGraphControl = this.getTimeGraphViewer().getTimeGraphControl();
        Menu entryMenu = this.fEntryMenuManager.createContextMenu((Control)timeGraphControl);
        timeGraphControl.addTimeGraphEntryMenuListener(event -> {
            Point p = timeGraphControl.toControl(event.x, event.y);
            if (p.x < this.getTimeGraphViewer().getNameSpace()) {
                timeGraphControl.setMenu(entryMenu);
            } else {
                timeGraphControl.setMenu(null);
                event.doit = false;
            }
        });
        this.fEntryMenuManager.addMenuListener(manager -> {
            this.fillTimeGraphEntryContextMenu((IMenuManager)this.fEntryMenuManager);
            this.fEntryMenuManager.add((IContributionItem)new GroupMarker("additions"));
        });
        this.getSite().registerContextMenu(this.fEntryMenuManager, this.fTimeGraphViewer.getSelectionProvider());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        TraceCompassFilter globalFilter;
        String dialogRegex;
        @NonNull @NonNull HashMultimap regexes = HashMultimap.create();
        String string = dialogRegex = this.fTimeEventFilterDialog != null ? this.fTimeEventFilterDialog.getTextBoxRegex() : "";
        if (!dialogRegex.isEmpty()) {
            regexes.put((Object)1, (Object)dialogRegex);
        }
        Set<@NonNull String> savedFilters = this.fTimeEventFilterDialog != null ? this.fTimeEventFilterDialog.getSavedFilters() : Collections.emptySet();
        for (String savedFilter : savedFilters) {
            regexes.put((Object)4, (Object)savedFilter);
            regexes.put((Object)1, (Object)savedFilter);
        }
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return regexes;
        }
        if (this.fIsHideRowsFilterActive) {
            this.getTimeGraphViewer().setSavedFilterStatus(true);
            regexes.put((Object)4, (Object)"");
        }
        if ((globalFilter = TraceCompassFilter.getFilterForTrace((ITmfTrace)trace)) == null) {
            return regexes;
        }
        regexes.putAll((Object)1, (Iterable)globalFilter.getRegexes());
        return regexes;
    }

    private @Nullable TimeGraphControl getTimeGraphControl() {
        TimeGraphControl control;
        TimeGraphViewer viewer = this.getTimeGraphViewer();
        if (viewer != null && (control = viewer.getTimeGraphControl()) != null) {
            return control;
        }
        return null;
    }

    protected ViewFilterDialog getViewFilterDialog() {
        return this.fTimeEventFilterDialog;
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
    }

    public void restartZoomThread() {
        ZoomThread zoomThread = this.fZoomThread;
        if (zoomThread != null) {
            zoomThread.cancel();
            this.fZoomThread = null;
        }
        Runnable runnable = () -> {
            this.clearSampling(this.getTrace());
            this.startZoomThread(this.getTimeGraphViewer().getTime0(), this.getTimeGraphViewer().getTime1());
        };
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == Display.getCurrent()) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void addPaintListener(PaintListener listener) {
        TimeGraphControl tgControl = this.getTimeGraphViewer().getTimeGraphControl();
        tgControl.addPaintListener(listener);
    }

    @Override
    public Action getFilterAction() {
        return this.fTimeEventFilterAction;
    }

    @Override
    public void filterUpdated(String regex, Set<@NonNull String> filterRegexes) {
        this.restartZoomThread();
    }

    @TmfSignalHandler
    public void regexFilterApplied(TmfFilterAppliedSignal signal) {
        Display.getDefault().asyncExec(this::restartZoomThread);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @TmfSignalHandler
    public void selectionChanged(TmfDataModelSelectedSignal signal) {
        if (signal.getSource() == this) {
            return;
        }
        @NonNull @NonNull Multimap metadata = signal.getMetadata();
        ITimeGraphEntry selection = this.getTimeGraphViewer().getSelection();
        if (selection instanceof ICoreElementResolver && ICoreElementResolver.commonIntersect((Multimap)metadata, (Multimap)((ICoreElementResolver)selection).getMetadata())) {
            return;
        }
        List<TimeGraphEntry> traceEntries = this.getEntryList(this.getTrace());
        if (traceEntries == null) {
            return;
        }
        for (BaseDataProviderTimeGraphView.TraceEntry traceEntry : Iterables.filter(traceEntries, BaseDataProviderTimeGraphView.TraceEntry.class)) {
            Iterable<TimeGraphEntry> unfiltered = Utils.flatten(traceEntry);
            for (TimeGraphEntry entry : unfiltered) {
                if (!ICoreElementResolver.commonIntersect((Multimap)metadata, entry.getMetadata())) continue;
                this.getTimeGraphViewer().setSelection(entry, true);
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ITmfTimeNavigationProvider.class) {
            return (T)this.getTimeNavigator();
        }
        if (adapter == ITmfTimeZoomProvider.class) {
            return (T)this.getTimeZoomProvider();
        }
        if (adapter == ITmfZoomToSelectionProvider.class) {
            return (T)this.getZoomToSelectionProvider();
        }
        return (T)super.getAdapter(adapter);
    }

    private ITmfTimeNavigationProvider getTimeNavigator() {
        return left -> {
            TimeGraphControl control = this.getTimeGraphControl();
            if (control != null) {
                control.horizontalScroll(left);
            }
        };
    }

    private ITmfTimeZoomProvider getTimeZoomProvider() {
        return (zoomIn, useMousePosition) -> {
            TimeGraphControl control = this.getTimeGraphControl();
            TimeGraphViewer viewer = this.getTimeGraphViewer();
            if (control != null && viewer != null) {
                if (useMousePosition) {
                    control.zoom(zoomIn);
                } else {
                    int xCoord = control.toControl((Point)control.getDisplay().getCursorLocation()).x;
                    if (viewer.getNameSpace() <= xCoord && xCoord < control.getSize().x) {
                        if (zoomIn) {
                            control.zoomIn();
                        } else {
                            control.zoomOut();
                        }
                    }
                }
            }
        };
    }

    private ITmfZoomToSelectionProvider getZoomToSelectionProvider() {
        return () -> {
            long selEnd;
            long selBegin;
            TimeGraphViewer viewer = this.getTimeGraphViewer();
            if (viewer != null && (selBegin = viewer.getSelectionBegin()) != (selEnd = viewer.getSelectionEnd())) {
                viewer.setStartFinishTimeNotify(selBegin, selEnd);
            }
        };
    }

    private void clearSampling(ITmfTrace trace) {
        List<@NonNull TimeGraphEntry> entryList = this.getEntryList(trace);
        if (entryList != null) {
            for (TimeGraphEntry entry : entryList) {
                Utils.flatten(entry).forEach(e -> e.setSampling(null));
            }
        }
    }

    private final class AnnotationMarkerEventSource
    implements IMarkerEventSource {
        private IOutputAnnotationProvider fProvider;

        private AnnotationMarkerEventSource(IOutputAnnotationProvider ap) {
            this.fProvider = ap;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @NonNull List<@NonNull IMarkerEvent> getMarkerList(@NonNull String category, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
            if (!AbstractTimeGraphView.this.getTimeGraphViewer().isMarkerCategoryVisible(category)) {
                return Collections.emptyList();
            }
            HashMap<@NonNull String, @NonNull Object> parameters = new HashMap<String, Object>();
            MarkerSet defaultMarkerSet = MarkerUtils.getDefaultMarkerSet();
            if (defaultMarkerSet != null) {
                parameters.put("requested_marker_set", defaultMarkerSet.getId());
            }
            parameters.put("requested_marker_categories", Collections.singletonList(category));
            parameters.put("requested_times", StateSystemUtils.getTimes((long)startTime, (long)endTime, (long)resolution));
            @NonNull TmfModelResponse response = this.fProvider.fetchAnnotations(parameters, (IProgressMonitor)new NullProgressMonitor());
            AnnotationModel model = (AnnotationModel)response.getModel();
            ArrayList<@NonNull IMarkerEvent> traceMarkerList = new ArrayList<IMarkerEvent>();
            if (model != null) {
                for (Map.Entry entry : model.getAnnotations().entrySet()) {
                    for (Annotation annotation : (Collection)entry.getValue()) {
                        if (annotation.getType() != IAnnotation.AnnotationType.CHART) continue;
                        if (annotation.getEntryId() != -1L) {
                            Activator.getDefault().logWarning("Requesting an annotation with a bound entry. request : " + String.valueOf(parameters) + ", provider : " + this.fProvider.getClass().getName() + " annotation: " + String.valueOf(annotation));
                        }
                        MarkerEvent markerEvent = new MarkerEvent((IAnnotation)annotation, null, (String)entry.getKey(), true);
                        traceMarkerList.add(markerEvent);
                    }
                }
            }
            return traceMarkerList;
        }

        @Override
        public @NonNull List<@NonNull String> getMarkerCategories() {
            TmfModelResponse cats;
            AnnotationCategoriesModel model;
            HashMap<@NonNull String, @NonNull String> parameters = new HashMap<String, String>();
            MarkerSet defaultMarkerSet = MarkerUtils.getDefaultMarkerSet();
            if (defaultMarkerSet != null) {
                parameters.put("requested_marker_set", defaultMarkerSet.getId());
            }
            if ((model = (AnnotationCategoriesModel)(cats = this.fProvider.fetchAnnotationCategories(parameters, (IProgressMonitor)new NullProgressMonitor())).getModel()) != null) {
                return model.getAnnotationCategories();
            }
            return Collections.emptyList();
        }
    }

    private class BuildRunnable {
        private final @NonNull ITmfTrace fBuildTrace;
        private final @NonNull ITmfTrace fParentTrace;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public BuildRunnable(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, TraceCompassLogUtils.FlowScopeLog log) {
            this.fBuildTrace = trace;
            this.fParentTrace = parentTrace;
            this.fScope = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:BuildThread", new Object[]{"trace", this.fBuildTrace.getName()}).setParentScope(this.fScope).build();){
                AbstractTimeGraphView.this.buildEntryList(this.fBuildTrace, this.fParentTrace, (IProgressMonitor)NonNullUtils.checkNotNull((Object)monitor));
                Map<ITmfTrace, Job> map = AbstractTimeGraphView.this.fBuildJobMap;
                synchronized (map) {
                    AbstractTimeGraphView.this.fBuildJobMap.remove(this.fBuildTrace);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    class FindTarget {
        FindTarget() {
        }

        public ITimeGraphEntry getSelection() {
            return AbstractTimeGraphView.this.fTimeGraphViewer.getSelection();
        }

        public void selectAndReveal(@NonNull ITimeGraphEntry entry) {
            AbstractTimeGraphView.this.fTimeGraphViewer.selectAndReveal(entry);
        }

        public ITimeGraphEntry[] getEntries() {
            TimeGraphViewer viewer = AbstractTimeGraphView.this.getTimeGraphViewer();
            return viewer.getTimeGraphContentProvider().getElements(viewer.getInput());
        }

        public Shell getShell() {
            return AbstractTimeGraphView.this.getSite().getShell();
        }

        public String[] getColumnTexts(@NonNull ITimeGraphEntry entry) {
            String[] texts = null;
            if (AbstractTimeGraphView.this.fColumns != null) {
                texts = new String[AbstractTimeGraphView.this.fColumns.length];
                int i = 0;
                while (i < AbstractTimeGraphView.this.fColumns.length) {
                    texts[i] = AbstractTimeGraphView.this.fLabelProvider.getColumnText((Object)entry, i);
                    ++i;
                }
            } else {
                texts = new String[]{entry.getName()};
            }
            return texts;
        }
    }

    private class HideEmptyRowsAction
    extends Action {
        public HideEmptyRowsAction() {
            super(org.eclipse.tracecompass.internal.tmf.ui.views.timegraph.Messages.AbstractTimeGraphView_HideEmptyRowsActionName, 2);
            this.setToolTipText(org.eclipse.tracecompass.internal.tmf.ui.views.timegraph.Messages.AbstractTimeGraphView_HideEmptyRowsActionTooltip);
            this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/hide_empty_rows.png"));
            AbstractTimeGraphView.this.fIsHideRowsFilterActive = false;
        }

        public void run() {
            boolean hasSavedFilter = AbstractTimeGraphView.this.fTimeEventFilterDialog != null && AbstractTimeGraphView.this.fTimeEventFilterDialog.hasActiveSavedFilters();
            AbstractTimeGraphView.this.fIsHideRowsFilterActive = this.isChecked();
            AbstractTimeGraphView.this.getTimeGraphViewer().setHideEmptyRowsFilterActive(AbstractTimeGraphView.this.fIsHideRowsFilterActive);
            AbstractTimeGraphView.this.getTimeGraphViewer().setSavedFilterStatus(hasSavedFilter || AbstractTimeGraphView.this.fIsHideRowsFilterActive);
            AbstractTimeGraphView.this.restartZoomThread();
        }
    }

    private class MarkerSetAction
    extends Action {
        private MarkerSet fMarkerSet;

        public MarkerSetAction(MarkerSet markerSet) {
            super(markerSet == null ? Messages.AbstractTimeGraphView_MarkerSetNoneActionText : markerSet.getName(), 8);
            this.fMarkerSet = markerSet;
        }

        public void runWithEvent(Event event) {
            if (this.isChecked()) {
                MarkerUtils.setDefaultMarkerSet(this.fMarkerSet);
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfMarkerEventSourceUpdatedSignal((Object)AbstractTimeGraphView.this));
            }
        }
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    class TimeGraphPartListener
    implements IPartListener {
        TimeGraphPartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partActivated(IWorkbenchPart part) {
            if (part == AbstractTimeGraphView.this) {
                ShowFindDialogAction showFindDialogAction = FIND_ACTION;
                synchronized (showFindDialogAction) {
                    if (AbstractTimeGraphView.this.fFindActionHandler == null) {
                        AbstractTimeGraphView.this.fFindActionHandler = new ActionHandler((IAction)FIND_ACTION);
                    }
                    if (AbstractTimeGraphView.this.fFindHandlerActivation == null) {
                        Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
                        AbstractTimeGraphView.this.fFindHandlerActivation = ((IHandlerService)service).activateHandler(ActionFactory.FIND.getCommandId(), (IHandler)AbstractTimeGraphView.this.fFindActionHandler);
                    }
                }
            }
            FIND_ACTION.partActivated(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == AbstractTimeGraphView.this && AbstractTimeGraphView.this.fFindHandlerActivation != null) {
                Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
                ((IHandlerService)service).deactivateHandler(AbstractTimeGraphView.this.fFindHandlerActivation);
                AbstractTimeGraphView.this.fFindHandlerActivation = null;
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class TimeGraphPartListener2
    implements IPartListener2 {
        TimeGraphPartListener2() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null && part == AbstractTimeGraphView.this) {
                Display.getDefault().asyncExec(() -> {
                    if (AbstractTimeGraphView.this.fTimeEventFilterDialog != null) {
                        AbstractTimeGraphView.this.fTimeEventFilterDialog.close();
                    }
                });
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null && part == AbstractTimeGraphView.this) {
                Display.getDefault().asyncExec(() -> {
                    if (AbstractTimeGraphView.this.fTimeEventFilterDialog != null && AbstractTimeGraphView.this.fTimeEventFilterDialog.isFilterActive()) {
                        AbstractTimeGraphView.this.fTimeEventFilterDialog.open();
                    }
                });
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return "";
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            return entry.getName();
        }
    }

    private static class ViewContext {
        private final int fSortColumnIndex;
        private final int fSortDirection;
        private final @Nullable ITimeGraphEntry fSelection;
        private final @NonNull Set<@NonNull ITimeGraphEntry> fCollapsedEntries;
        private final boolean fHideRowsFilterState;

        ViewContext(int sortColunm, int sortDirection, ITimeGraphEntry selection, @NonNull Set<@NonNull ITimeGraphEntry> collapsedEntries, boolean hideRowsFilterState) {
            this.fSortColumnIndex = sortColunm;
            this.fSortDirection = sortDirection;
            this.fSelection = selection;
            this.fCollapsedEntries = ImmutableSet.copyOf(collapsedEntries);
            this.fHideRowsFilterState = hideRowsFilterState;
        }

        public int getSortColumn() {
            return this.fSortColumnIndex;
        }

        public int getSortDirection() {
            return this.fSortDirection;
        }

        public ITimeGraphEntry getSelection() {
            return this.fSelection;
        }

        public @NonNull Set<@NonNull ITimeGraphEntry> getCollapsedEntries() {
            return this.fCollapsedEntries;
        }

        public boolean isHideRowFilterActive() {
            return this.fHideRowsFilterState;
        }
    }

    protected abstract class ZoomThread
    extends Thread {
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        private int fScopeId;
        private final @NonNull IProgressMonitor fMonitor;

        public ZoomThread(long startTime, long endTime, long resolution) {
            super(AbstractTimeGraphView.this.getName() + " zoom");
            this.fScopeId = -1;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = resolution;
            this.fMonitor = new NullProgressMonitor();
        }

        public long getZoomStartTime() {
            return this.fZoomStartTime;
        }

        public long getZoomEndTime() {
            return this.fZoomEndTime;
        }

        public long getResolution() {
            return this.fResolution;
        }

        public @NonNull IProgressMonitor getMonitor() {
            return this.fMonitor;
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }

        @Override
        public final void run() {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TimeGraphView:ZoomThread", new Object[]{"start", this.fZoomStartTime, "end", this.fZoomEndTime}).setCategoryAndId(AbstractTimeGraphView.this.getViewId(), this.fScopeId).build();){
                    this.doRun();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (AbstractTimeGraphView.this.fDirty.decrementAndGet() < 0) {
                    Activator.getDefault().logError(AbstractTimeGraphView.DIRTY_UNDERFLOW_ERROR, new Throwable());
                }
            }
        }

        protected void applyResults(Runnable runnable) {
            AbstractTimeGraphView.this.applyResults(runnable);
        }

        public abstract void doRun();

        public void setScopeId(int scopeId) {
            this.fScopeId = scopeId;
        }
    }

    private class ZoomThreadByEntry
    extends ZoomThread {
        private final @NonNull Collection<@NonNull TimeGraphEntry> fEntries;

        public ZoomThreadByEntry(Collection<TimeGraphEntry> entries, long startTime, long endTime, long resolution) {
            super(startTime, endTime, resolution);
            this.fEntries = entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void doRun() {
            zoomStartTime = this.getZoomStartTime();
            zoomEndTime = this.getZoomEndTime();
            resolution = this.getResolution();
            monitor = this.getMonitor();
            sampling = new TimeGraphEntry.Sampling(zoomStartTime, zoomEndTime, resolution);
            isFilterActive = AbstractTimeGraphView.this.getRegexes().values().isEmpty() == false;
            incorrectSample = Objects.requireNonNull(Lists.newArrayList((Iterable)Iterables.filter(this.fEntries, (Predicate)(Predicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry$Sampling org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry ), (Lorg/eclipse/tracecompass/tmf/ui/widgets/timegraph/model/TimeGraphEntry;)Z)((TimeGraphEntry.Sampling)sampling))));
            var12_8 = null;
            var13_10 = null;
            try {
                linkLog = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphView.LOGGER, Level.FINER, "ZoomThread:GettingLinks", new Object[0]);
                try {
                    computedLinks /* !! */  = AbstractTimeGraphView.this.getLinkList(zoomStartTime, zoomEndTime, resolution, monitor);
                    filterDialog = AbstractTimeGraphView.this.getViewFilterDialog();
                    if (filterDialog != null && computedLinks /* !! */  != null) {
                        if (filterDialog.hasActiveSavedFilters()) {
                            computedLinks /* !! */  = Collections.emptyList();
                        } else {
                            computedLinks /* !! */ .forEach((Consumer<ILinkEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$1(org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.ViewFilterDialog org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent ), (Lorg/eclipse/tracecompass/tmf/ui/widgets/timegraph/model/ILinkEvent;)V)((ViewFilterDialog)filterDialog));
                        }
                    }
                }
                finally {
                    if (linkLog != null) {
                        linkLog.close();
                    }
                }
            }
            catch (Throwable var13_11) {
                if (var12_8 == null) {
                    var12_8 = var13_11;
                } else if (var12_8 != var13_11) {
                    var12_8.addSuppressed(var13_11);
                }
                throw var12_8;
            }
            links = computedLinks /* !! */ ;
            var13_10 = null;
            var14_15 = null;
            try {
                markerLoglog = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphView.LOGGER, Level.FINER, "ZoomThread:GettingMarkers", new Object[0]);
                try {
                    newMarkers = new ArrayList<IMarkerEvent>(AbstractTimeGraphView.this.getViewMarkerList(incorrectSample, zoomStartTime, zoomEndTime, resolution, monitor));
                    newMarkers.addAll(AbstractTimeGraphView.this.getTraceMarkerList(zoomStartTime, zoomEndTime, resolution, monitor));
                    this.applyResults((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$2(java.util.List java.util.List org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry$Sampling java.util.List ), ()V)((ZoomThreadByEntry)this, links, (List)incorrectSample, (TimeGraphEntry.Sampling)sampling, newMarkers));
                }
                finally {
                    if (markerLoglog != null) {
                        markerLoglog.close();
                    }
                }
            }
            catch (Throwable var14_16) {
                if (var13_10 == null) {
                    var13_10 = var14_16;
                } else if (var13_10 != var14_16) {
                    var13_10.addSuppressed(var14_16);
                }
                throw var13_10;
            }
            var13_10 = null;
            var14_15 = null;
            try {
                log = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphView.LOGGER, Level.FINER, "ZoomThread:GettingStates", new Object[0]);
                try {
                    AbstractTimeGraphView.this.getTimeGraphViewer().setTimeEventFilterApplied(isFilterActive);
                    hasSavedFilter = AbstractTimeGraphView.this.fTimeEventFilterDialog != null && AbstractTimeGraphView.this.fTimeEventFilterDialog.hasActiveSavedFilters() != false;
                    AbstractTimeGraphView.this.getTimeGraphViewer().setSavedFilterStatus(hasSavedFilter != false || AbstractTimeGraphView.this.fIsHideRowsFilterActive != false);
                    AbstractTimeGraphView.this.zoomEntries(incorrectSample, zoomStartTime, zoomEndTime, resolution, monitor);
                }
                finally {
                    if (log != null) {
                        log.close();
                    }
                }
            }
            catch (Throwable var14_17) {
                if (var13_10 == null) {
                    var13_10 = var14_17;
                } else if (var13_10 != var14_17) {
                    var13_10.addSuppressed(var14_17);
                }
                throw var13_10;
            }
            var13_10 = AbstractTimeGraphView.this.fZoomThreadResultLock;
            synchronized (var13_10) {
                if (Thread.currentThread() == AbstractTimeGraphView.this.fZoomThread) {
                    AbstractTimeGraphView.this.refresh();
                }
            }
            if (isFilterActive && Thread.currentThread() == AbstractTimeGraphView.this.fZoomThread) {
                var13_10 = null;
                var14_15 = null;
                try {
                    log = new TraceCompassLogUtils.ScopeLog(AbstractTimeGraphView.LOGGER, Level.FINER, "ZoomThread:GettingStatesFullSearch", new Object[0]);
                    try {
                        var17_24 = this.fEntries.iterator();
                        while (true) {
                            entry = var17_24.next();
                            if (monitor.isCanceled()) {
                                return;
                            }
                            AbstractTimeGraphView.this.zoomEntries(Collections.singleton(entry), zoomStartTime, zoomEndTime, resolution, true, monitor);
                            AbstractTimeGraphView.this.refresh();
                            break;
                        }
                    }
                    finally {
                        if (var17_24.hasNext()) ** continue;
                    }
                }
                catch (Throwable var14_18) {
                    if (var13_10 == null) {
                        var13_10 = var14_18;
                    } else if (var13_10 != var14_18) {
                        var13_10.addSuppressed(var14_18);
                    }
                    throw var13_10;
                }
            }
        }

        private static /* synthetic */ boolean lambda$0(TimeGraphEntry.Sampling sampling, TimeGraphEntry entry) {
            return !sampling.equals(entry.getSampling());
        }

        private static /* synthetic */ void lambda$1(ViewFilterDialog viewFilterDialog, ILinkEvent link) {
            link.setProperty(1, viewFilterDialog.isFilterActive());
        }

        private /* synthetic */ void lambda$2(List list, List list2, TimeGraphEntry.Sampling sampling, List list3) {
            if (list != null) {
                AbstractTimeGraphView.this.fTimeGraphViewer.setLinks(list);
            }
            AbstractTimeGraphView.this.fTimeGraphViewer.setMarkerCategories(AbstractTimeGraphView.this.getMarkerCategories());
            Stream<IMarkerEvent> filteredMarkerStream = AbstractTimeGraphView.this.fTimeGraphViewer.getMarkers().parallelStream().filter(event -> event.getEntry() != null).filter(event -> event.getEntry() instanceof TimeGraphEntry).filter(event -> {
                TimeGraphEntry entry = (TimeGraphEntry)event.getEntry();
                return AbstractTimeGraphView.this.fVisibleEntries.contains(entry) ? !list2.contains(entry) : sampling.equals(entry.getSampling());
            });
            List markers = ((Stream)Stream.concat(filteredMarkerStream, list3.parallelStream()).unordered()).distinct().collect(Collectors.toCollection(ArrayList::new));
            AbstractTimeGraphView.this.fTimeGraphViewer.setMarkers(markers);
        }
    }
}

