/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.ui.swtbot.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.tracecompass.analysis.counters.ui.views.CounterView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfCommonXAxisChartViewer;
import org.eclipse.ui.IViewPart;
import org.junit.Assert;
import org.junit.Test;

public class NewCounterViewTest
extends XYDataProviderBaseTest {
    private static final int NUMBER_OF_POINTS = 50;
    private static final RGB BLUE = new RGB(0, 0, 255);
    private static final @NonNull String TRACE_NAME = "kernel_vm";
    private static final @NonNull String COUNTER_NAME = "minor_faults";
    private static final @NonNull String COUNTERS_VIEW_TITLE = "Counters View";
    private static final @NonNull String MAIN_SERIES_NAME = "kernel_vm/Ungrouped/minor_faults";
    private static final @NonNull String COUNTERS_VIEW_ID = "org.eclipse.tracecompass.analysis.counters.ui.views.countersview";

    @Test
    public void testManipulatingTreeViewer() {
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        Assert.assertEquals((long)0L, (long)chart.getSeriesSet().getSeries().length);
        SWTBotTree treeBot = this.getSWTBotView().bot().tree();
        WaitUtils.waitUntil(tree -> tree.rowCount() >= 1, (Object)treeBot, (String)"The tree viewer did not finish loading.");
        SWTBotTreeItem root = treeBot.getTreeItem(TRACE_NAME);
        Assert.assertNotNull((Object)root);
        SWTBotTreeItem counter = this.retrieveTreeItem(root, COUNTER_NAME);
        Assert.assertNotNull((Object)counter);
        root.check();
        WaitUtils.waitUntil(SWTBotTreeItem::isChecked, (Object)root, (String)"Root entry was not checked");
        Assert.assertTrue((boolean)counter.isChecked());
        Assert.assertFalse((boolean)root.isGrayed());
        Assert.assertFalse((boolean)counter.isGrayed());
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 3, (Object)chart, (String)"The data series did not load.");
        counter.uncheck();
        Assert.assertTrue((boolean)root.isChecked());
        Assert.assertTrue((boolean)root.isGrayed());
        Assert.assertFalse((boolean)counter.isChecked());
        Assert.assertFalse((boolean)counter.isGrayed());
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 2, (Object)chart, (String)"A data series has not been removed.");
    }

    @Test
    public void testDisplayingDataSeries() {
        IViewPart viewPart = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof CounterView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)NewCounterViewTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        chartViewer.setNbPoints(50);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        Assert.assertEquals((long)0L, (long)chart.getSeriesSet().getSeries().length);
        SWTBotTree treeBot = this.getSWTBotView().bot().tree();
        WaitUtils.waitUntil(tree -> tree.rowCount() >= 1, (Object)treeBot, (String)"The tree viewer did not finish loading.");
        SWTBotTreeItem root = treeBot.getTreeItem(TRACE_NAME);
        SWTBotTreeItem counter = this.retrieveTreeItem(root, COUNTER_NAME);
        Assert.assertNotNull((Object)counter);
        counter.check();
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        WaitUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 1, (Object)chart, (String)"The data series did not load.");
        this.verifySeriesStyle(MAIN_SERIES_NAME, ISeries.SeriesType.LINE, BLUE, LineStyle.SOLID, false);
        WaitUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{MAIN_SERIES_NAME}), (Object)"resources/minor_faults-res50.json", (String)"The chart data is not valid.");
    }

    private @Nullable SWTBotTreeItem retrieveTreeItem(SWTBotTreeItem rootItem, @NonNull String id) {
        if (rootItem.getNodes().contains(id)) {
            return rootItem.getNode(id);
        }
        SWTBotTreeItem[] sWTBotTreeItemArray = rootItem.getItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem child = sWTBotTreeItemArray[n2];
            SWTBotTreeItem grandChild = this.retrieveTreeItem(child, id);
            if (grandChild != null) {
                return grandChild;
            }
            ++n2;
        }
        return null;
    }

    protected @NonNull String getMainSeriesName() {
        return MAIN_SERIES_NAME;
    }

    protected @NonNull String getTitle() {
        return COUNTERS_VIEW_TITLE;
    }

    protected String getViewID() {
        return COUNTERS_VIEW_ID;
    }

    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.KERNEL_VM);
    }

    protected void disposeTestTrace() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.KERNEL_VM);
    }
}

