/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import com.google.common.base.Joiner;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ITitle;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CPUUsagePresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageView;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.viewers.xychart.BaseXYPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfXYChartSettings;

public class CpuUsageXYViewer
extends TmfFilteredXYChartViewer {
    public CpuUsageXYViewer(Composite parent, TmfXYChartSettings settings) {
        super(parent, settings, "org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider");
        this.getSwtChart().getTitle().setVisible(true);
        this.getSwtChart().getLegend().setVisible(false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Map<String, Object> createQueryParameters(long start, long end, int nb) {
        @NonNull @NonNull Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(start, end, nb, this.getSelected()));
        parameters.put("requested_cpus", CpuUsageView.getCpus(this.getTrace()));
        return parameters;
    }

    public OutputElementStyle getSeriesStyle(@NonNull Long seriesId) {
        return this.getPresentationProvider().getSeriesStyle(seriesId);
    }

    protected void setTitle() {
        ITitle title = this.getSwtChart().getTitle();
        Set<Integer> cpus = CpuUsageView.getCpus(this.getTrace());
        if (cpus.isEmpty()) {
            title.setText(Messages.CpuUsageView_Title);
        } else {
            title.setText(String.valueOf(Messages.CpuUsageView_Title) + ' ' + Joiner.on((String)", ").join(cpus));
        }
    }

    protected BaseXYPresentationProvider createPresentationProvider(ITmfTrace trace) {
        CPUUsagePresentationProvider presProvider = CPUUsagePresentationProvider.getForTrace(trace);
        return presProvider;
    }
}

