/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProviderConverter;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class TimeGraphTooltipHandler
extends TmfAbstractToolTipHandler {
    private static final String ROW_CATEGORY = "Row";
    private static final String MARKER_CATEGORY_PREFIX = "Marker ";
    private static final String LINK_CATEGORY = "Link";
    private static final String STATE_CATEGORY = "State";
    private static final String MARKER_OFFSET = " ";
    private static final String MIN_STRING = "< 0.01%";
    private static final double MIN_RATIO = 1.0E-4;
    private static final String MAX_STRING = "> 1000%";
    private static final int MAX_RATIO = 10;
    private static final int HOVER_MAX_DIST = 10;
    private ITimeDataProvider fTimeDataProvider;
    private ITimeGraphPresentationProvider fTimeGraphProvider = null;

    public TimeGraphTooltipHandler(ITimeGraphPresentationProvider graphProv, ITimeDataProvider timeProv) {
        this.fTimeGraphProvider = graphProv;
        this.fTimeDataProvider = timeProv;
    }

    public void setTimeProvider(ITimeDataProvider timeDataProvider) {
        this.fTimeDataProvider = timeDataProvider;
    }

    @Override
    protected void fill(Control control, MouseEvent event, Point pt) {
        ILinkEvent linkEvent;
        TimeGraphControl timeGraphControl = (TimeGraphControl)control;
        if ((event.stateMask & SWT.MODIFIER_MASK) != 131072 && (linkEvent = timeGraphControl.getArrow(pt)) != null) {
            this.fillValues(linkEvent);
        }
        if (this.getTipComposite().getChildren().length == 0) {
            ITimeGraphEntry entry = timeGraphControl.getEntry(pt);
            if (entry == null) {
                return;
            }
            this.fillValues(pt, timeGraphControl, entry);
            Iterable<IMarkerEvent> markers = TimeGraphTooltipHandler.getMarkers(timeGraphControl, entry, pt);
            int i = 0;
            for (IMarkerEvent marker : markers) {
                this.fillValues(MARKER_CATEGORY_PREFIX + i, marker);
                ++i;
            }
        }
    }

    private static Iterable<IMarkerEvent> getMarkers(TimeGraphControl timeGraphControl, ITimeGraphEntry entry, Point pt) {
        List<IMarkerEvent> markers = timeGraphControl.getMarkers();
        ArrayList<IMarkerEvent> retVal = new ArrayList<IMarkerEvent>();
        if (markers != null) {
            int fuzz = 5;
            long fuzzStart = timeGraphControl.getTimeAtX(pt.x - fuzz);
            long fuzzEnd = timeGraphControl.getTimeAtX(pt.x + fuzz);
            for (IMarkerEvent marker : markers) {
                if (!Objects.equals(marker.getEntry(), entry)) continue;
                long duration = marker.getDuration();
                long startTime = marker.getTime();
                long endTime = startTime + duration;
                if (startTime > fuzzEnd || endTime < fuzzStart) continue;
                retVal.add(marker);
            }
        }
        return retVal;
    }

    private void fillValues(String itemName, IMarkerEvent marker) {
        Map<String, String> toolTips = this.fTimeGraphProvider.getEventHoverToolTipInfo(marker);
        String category = marker.getCategory();
        String label = marker.getLabel();
        this.addItem(itemName, category == null ? Messages.TimeGraphTooltipHandler_DefaultMarkerName : category, label == null ? "" : label);
        long timestamp = marker.getTime();
        long duration = marker.getDuration();
        if (duration == 0L) {
            this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(itemName), TmfAbstractToolTipHandler.ToolTipString.fromString(MARKER_OFFSET + Messages.TimeGraphTooltipHandler_Timestamp), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(TmfTimestamp.fromNanos((long)timestamp).toString(), timestamp));
        } else {
            this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(itemName), TmfAbstractToolTipHandler.ToolTipString.fromString(MARKER_OFFSET + TmfStrings.startTime()), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(TmfTimestamp.fromNanos((long)timestamp).toString(), timestamp));
            this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(itemName), TmfAbstractToolTipHandler.ToolTipString.fromString(MARKER_OFFSET + TmfStrings.endTime()), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(TmfTimestamp.fromNanos((long)(timestamp + duration)).toString(), timestamp + duration));
        }
        if (toolTips != null) {
            for (Map.Entry<String, String> tooltip : toolTips.entrySet()) {
                this.addItem(itemName, MARKER_OFFSET + tooltip.getKey(), tooltip.getValue());
            }
        }
    }

    private void fillValues(Point pt, TimeGraphControl timeGraphControl, ITimeGraphEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.hasTimeEvents()) {
            Map<String, String> eventAddOns;
            long currPixelTime = timeGraphControl.getTimeAtX(pt.x);
            long nextPixelTime = timeGraphControl.getTimeAtX(pt.x + 1);
            if (nextPixelTime == currPixelTime) {
                ++nextPixelTime;
            }
            ITimeEvent currEvent = Utils.findEvent(entry, currPixelTime, 0);
            ITimeEvent nextEvent = Utils.findEvent(entry, currPixelTime, 1);
            if ((currEvent == null || currEvent.getTime() < currPixelTime) && nextEvent != null && nextEvent.getTime() < nextPixelTime) {
                currEvent = nextEvent;
                currPixelTime = nextEvent.getTime();
            }
            if (currEvent == null || currEvent instanceof NullTimeEvent) {
                ITimeEvent prevEvent;
                int nextDelta = Integer.MAX_VALUE;
                int prevDelta = Integer.MAX_VALUE;
                long nextTime = 0L;
                long prevTime = 0L;
                if (nextEvent != null && !(nextEvent instanceof NullTimeEvent)) {
                    nextTime = nextEvent.getTime();
                    nextDelta = Math.abs(timeGraphControl.getXForTime(nextTime) - pt.x);
                }
                if ((prevEvent = Utils.findEvent(entry, currPixelTime, -1)) != null && !(prevEvent instanceof NullTimeEvent)) {
                    prevTime = prevEvent.getTime() + prevEvent.getDuration() - 1L;
                    prevDelta = Math.abs(pt.x - timeGraphControl.getXForTime(prevTime));
                }
                if (nextDelta < 10 && nextDelta <= prevDelta) {
                    currEvent = nextEvent;
                    currPixelTime = nextTime;
                } else if (prevDelta < 10) {
                    currEvent = prevEvent;
                    currPixelTime = prevTime;
                }
            }
            String stateTypeName = this.fTimeGraphProvider.getStateTypeName(entry);
            String entryName = entry.getName();
            if (stateTypeName == null) {
                stateTypeName = this.fTimeGraphProvider.getStateTypeName();
            }
            if (!entryName.isEmpty()) {
                this.addItem(ROW_CATEGORY, stateTypeName, entry.getName());
            }
            if (currEvent == null || currEvent instanceof NullTimeEvent) {
                return;
            }
            String state = this.fTimeGraphProvider.getEventName(currEvent);
            if (state != null) {
                this.addItem(STATE_CATEGORY, Messages.TmfTimeTipHandler_TRACE_STATE, state);
            }
            if ((eventAddOns = this.fTimeGraphProvider.getEventHoverToolTipInfo(currEvent, currPixelTime)) != null) {
                for (Map.Entry<String, String> eventAddOn : eventAddOns.entrySet()) {
                    this.addItem(STATE_CATEGORY, eventAddOn.getKey(), eventAddOn.getValue());
                }
            }
            if (this.fTimeGraphProvider.displayTimesInTooltip()) {
                long eventStartTime = -1L;
                long eventDuration = -1L;
                long eventEndTime = -1L;
                eventStartTime = currEvent.getTime();
                eventDuration = currEvent.getDuration();
                if (eventDuration < 0L && nextEvent != null) {
                    eventEndTime = nextEvent.getTime();
                    eventDuration = eventEndTime - eventStartTime;
                } else {
                    eventEndTime = eventStartTime + eventDuration;
                }
                FormatTimeUtils.Resolution res = FormatTimeUtils.Resolution.NANOSEC;
                FormatTimeUtils.TimeFormat tf = this.fTimeDataProvider.getTimeFormat().convert();
                String startTime = "?";
                String duration = "?";
                String endTime = "?";
                if (this.fTimeDataProvider instanceof ITimeDataProviderConverter) {
                    ITimeDataProviderConverter tdp = (ITimeDataProviderConverter)this.fTimeDataProvider;
                    if (eventStartTime > -1L) {
                        eventStartTime = tdp.convertTime(eventStartTime);
                        startTime = FormatTimeUtils.formatTime(eventStartTime, tf, res);
                    }
                    if (eventEndTime > -1L) {
                        eventEndTime = tdp.convertTime(eventEndTime);
                        endTime = FormatTimeUtils.formatTime(eventEndTime, tf, res);
                    }
                    if (eventDuration > -1L) {
                        duration = FormatTimeUtils.formatDelta(eventEndTime - eventStartTime, tf, res);
                    }
                } else {
                    if (eventStartTime > -1L) {
                        startTime = FormatTimeUtils.formatTime(eventStartTime, tf, res);
                    }
                    if (eventEndTime > -1L) {
                        endTime = FormatTimeUtils.formatTime(eventEndTime, tf, res);
                    }
                    if (eventDuration > -1L) {
                        duration = FormatTimeUtils.formatDelta(eventDuration, tf, res);
                    }
                }
                if (tf == FormatTimeUtils.TimeFormat.CALENDAR) {
                    this.addItem(STATE_CATEGORY, Messages.TmfTimeTipHandler_TRACE_DATE, eventStartTime > -1L ? FormatTimeUtils.formatDate(eventStartTime) : "?");
                }
                if (eventDuration > 0L) {
                    this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(STATE_CATEGORY), TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.TmfTimeTipHandler_TRACE_START_TIME), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(startTime, eventStartTime));
                    this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(STATE_CATEGORY), TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.TmfTimeTipHandler_TRACE_STOP_TIME), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(endTime, eventEndTime));
                } else {
                    this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(STATE_CATEGORY), TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.TmfTimeTipHandler_TRACE_EVENT_TIME), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(startTime, eventStartTime));
                }
                if (eventDuration > 0L) {
                    this.addItem(STATE_CATEGORY, Messages.TmfTimeTipHandler_DURATION, duration);
                    long begin = this.fTimeDataProvider.getSelectionBegin();
                    long end = this.fTimeDataProvider.getSelectionEnd();
                    long delta = Math.abs(end - begin);
                    double durationRatio = (double)eventDuration / (double)delta;
                    if (delta > 0L) {
                        String percentage = durationRatio > 10.0 ? MAX_STRING : (durationRatio < 1.0E-4 ? MIN_STRING : String.format("%,.2f%%", durationRatio * 100.0));
                        this.addItem(STATE_CATEGORY, Messages.TmfTimeTipHandler_PERCENT_OF_SELECTION, percentage);
                    }
                }
            }
        }
    }

    private void fillValues(ILinkEvent linkEvent) {
        this.addItem(LINK_CATEGORY, Messages.TmfTimeTipHandler_LINK_SOURCE, linkEvent.getEntry().getName());
        this.addItem(LINK_CATEGORY, Messages.TmfTimeTipHandler_LINK_TARGET, linkEvent.getDestinationEntry().getName());
        Map<String, String> eventAddOns = this.fTimeGraphProvider.getEventHoverToolTipInfo(linkEvent);
        if (eventAddOns != null) {
            for (Map.Entry<String, String> eventAddOn : eventAddOns.entrySet()) {
                this.addItem(LINK_CATEGORY, eventAddOn.getKey(), eventAddOn.getValue());
            }
        }
        if (this.fTimeGraphProvider.displayTimesInTooltip()) {
            long sourceTime = linkEvent.getTime();
            long duration = linkEvent.getDuration();
            long targetTime = sourceTime + duration;
            if (this.fTimeDataProvider instanceof ITimeDataProviderConverter) {
                ITimeDataProviderConverter tdp = (ITimeDataProviderConverter)this.fTimeDataProvider;
                sourceTime = tdp.convertTime(sourceTime);
                targetTime = tdp.convertTime(targetTime);
                duration = targetTime - sourceTime;
            }
            FormatTimeUtils.Resolution res = FormatTimeUtils.Resolution.NANOSEC;
            FormatTimeUtils.TimeFormat tf = this.fTimeDataProvider.getTimeFormat().convert();
            if (tf == FormatTimeUtils.TimeFormat.CALENDAR) {
                this.addItem(LINK_CATEGORY, Messages.TmfTimeTipHandler_TRACE_DATE, FormatTimeUtils.formatDate(sourceTime));
            }
            if (duration > 0L) {
                this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(LINK_CATEGORY), TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.TmfTimeTipHandler_LINK_SOURCE_TIME), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(FormatTimeUtils.formatTime(sourceTime, tf, res), sourceTime));
                this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(LINK_CATEGORY), TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.TmfTimeTipHandler_LINK_TARGET_TIME), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(FormatTimeUtils.formatTime(targetTime, tf, res), targetTime));
                this.addItem(LINK_CATEGORY, Messages.TmfTimeTipHandler_DURATION, FormatTimeUtils.formatDelta(duration, tf, res));
            } else {
                this.addItem(TmfAbstractToolTipHandler.ToolTipString.fromString(LINK_CATEGORY), TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.TmfTimeTipHandler_LINK_TIME), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(FormatTimeUtils.formatTime(sourceTime, tf, res), sourceTime));
            }
        }
    }
}

