/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class DetailsDialog
extends TrayDialog {
    private Button detailsButton;
    private Button okButton;
    private String title;
    private Label errorMessageLabel;
    private Composite detailsComposite;
    private boolean detailsCreated = false;
    private String imageKey = null;

    public DetailsDialog(Shell parentShell, String dialogTitle) {
        super(parentShell);
        this.title = dialogTitle;
        this.initializeStyle();
    }

    protected void initializeStyle() {
        this.setShellStyle(67696);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, helpContextId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.includeOkButton()) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
        if (this.includeCancelButton()) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
        if (this.includeDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, this.getDetailsButtonLabelShow(), false);
        }
        this.updateEnablements();
    }

    protected String getDetailsButtonLabelShow() {
        return IDialogConstants.SHOW_DETAILS_LABEL;
    }

    protected String getDetailsButtonLabelHide() {
        return IDialogConstants.HIDE_DETAILS_LABEL;
    }

    protected final Control createDialogArea(Composite parent) {
        String helpContextId;
        DetailsDialog.applyDialogFont((Control)parent);
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        if (!this.isMainGrabVertical()) {
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
        }
        if ((helpContextId = this.getHelpContextId()) != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, helpContextId);
        }
        String key = this.getImageKey();
        Image image = null;
        if (key != null) {
            image = JFaceResources.getImageRegistry().get(key);
        }
        if (image != null) {
            Composite top = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.numColumns = 2;
            top.setLayout((Layout)layout);
            top.setLayoutData((Object)new GridData(1808));
            Label label = new Label(top, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
            Composite right = new Composite(top, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            right.setLayout((Layout)layout);
            right.setLayoutData((Object)new GridData(1808));
            this.createMainDialogArea(right);
        } else {
            this.createMainDialogArea(composite);
        }
        if (this.includeErrorMessage()) {
            this.errorMessageLabel = new Label(composite, 0);
            this.errorMessageLabel.setLayoutData((Object)new GridData(768));
            this.errorMessageLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        }
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected String getHelpContextId() {
        return null;
    }

    protected boolean isMainGrabVertical() {
        return true;
    }

    protected abstract void createMainDialogArea(Composite var1);

    protected abstract Composite createDropDownDialogArea(Composite var1);

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.detailsCreated) {
            this.detailsComposite.dispose();
            this.detailsCreated = false;
            this.detailsButton.setText(this.getDetailsButtonLabelShow());
        } else {
            this.detailsComposite = this.createDropDownDialogArea((Composite)this.getContents());
            this.detailsCreated = true;
            this.detailsButton.setText(this.getDetailsButtonLabelHide());
        }
        Dialog.applyDialogFont((Control)this.getContents());
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected final void setErrorMessage(String error) {
        if (this.errorMessageLabel != null) {
            if (error == null || error.length() == 0) {
                this.errorMessageLabel.setText("");
            } else {
                this.errorMessageLabel.setText(error);
            }
            this.errorMessageLabel.update();
        }
    }

    protected final void setPageComplete(boolean complete) {
        if (this.okButton != null) {
            this.okButton.setEnabled(complete);
        }
    }

    protected abstract void updateEnablements();

    protected boolean includeCancelButton() {
        return true;
    }

    protected boolean includeOkButton() {
        return true;
    }

    protected String getImageKey() {
        return this.imageKey;
    }

    protected void setImageKey(String imageKey) {
        this.imageKey = imageKey;
    }

    protected Label createWrappingLabel(Composite parent, String text) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        return label;
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    protected boolean isDetailsVisible() {
        return this.detailsCreated;
    }

    protected boolean includeErrorMessage() {
        return true;
    }

    protected boolean includeDetailsButton() {
        return true;
    }
}

