/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer.TestDirectoryStructureUtil;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.SWTBotImportWizardUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ProjectExplorerRefreshTest {
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String C_PROJECT_NAME = "c-project";
    private static final Logger fLogger = Logger.getRootLogger();
    private static final long DISK_ACCESS_TIMEOUT = 120000L;
    private static final File TEST_TRACES_PATH = new File(new Path(TmfTraceManager.getTemporaryDirPath()).append("testtraces").toOSString());
    private static final File TEST_FILE_KERNEL = new File(ProjectExplorerRefreshTest.getPath("import/kernel-overlap-testing"));
    private static final File TEST_FILE_KERNEL_CLASH = new File(ProjectExplorerRefreshTest.getPath("import/z-clashes/kernel-overlap-testing"));
    private static final File TEST_FILE_UST = new File(ProjectExplorerRefreshTest.getPath("import/ust-overlap-testing"));
    private static SWTWorkbenchBot fBot;
    private static File fTracesFolder;
    private static File fCProjectFolder;

    static {
        fTracesFolder = null;
        fCProjectFolder = null;
    }

    private static String getPath(String relativePath) {
        return new Path(TEST_TRACES_PATH.getAbsolutePath()).append(relativePath).toOSString();
    }

    @BeforeClass
    public static void init() throws Exception {
        TestDirectoryStructureUtil.generateTraceStructure(TEST_TRACES_PATH);
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(TRACE_PROJECT_NAME);
        fTracesFolder = new File(Objects.requireNonNull(TmfProjectRegistry.getProject((IProject)project, (boolean)true).getTracesFolder()).getResource().getLocation().toOSString());
        ProjectExplorerRefreshTest.createCProject(C_PROJECT_NAME);
        ProjectExplorerRefreshTest.setTracingNature(C_PROJECT_NAME);
        IProject cProject = ResourcesPlugin.getWorkspace().getRoot().getProject(C_PROJECT_NAME);
        fCProjectFolder = cProject.getLocation().toFile();
    }

    @AfterClass
    public static void tearDown() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        SWTBotUtils.deleteProject((String)C_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    @After
    public void afterTest() {
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)fBot);
    }

    @Test
    public void test16_01RefreshTraceAdded() throws IOException {
        FileUtils.copyDirectory((File)TEST_FILE_KERNEL, (File)FileUtils.getFile((File)fTracesFolder, (String[])new String[]{TEST_FILE_KERNEL.getName()}));
        FileUtils.copyDirectory((File)TEST_FILE_UST, (File)FileUtils.getFile((File)fTracesFolder, (String[])new String[]{TEST_FILE_UST.getName()}));
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)0L, (long)tracesFolder.getItems().length);
        ProjectExplorerRefreshTest.refresh(() -> {
            SWTBotMenu sWTBotMenu = tracesFolder.contextMenu().menu(new String[]{"Refresh"}).click();
        });
        SWTBotTreeItem kernelTrace = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)TEST_FILE_KERNEL.getName());
        kernelTrace.contextMenu().menu(new String[]{"Select Trace Type...", "Common Trace Format", "Linux Kernel Trace"}).click();
        SWTBotTreeItem ustTrace = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)TEST_FILE_UST.getName());
        ustTrace.contextMenu().menu(new String[]{"Select Trace Type...", "Common Trace Format", "LTTng UST Trace"}).click();
    }

    @Test
    public void test16_02RefreshOpenedTraceContentModified() throws IOException {
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotTreeItem kernelTrace = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)TEST_FILE_KERNEL.getName());
        kernelTrace.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)TEST_FILE_KERNEL.getName());
        tracesFolder.contextMenu().menu(new String[]{"Open As Experiment...", "Generic Experiment"}).click();
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)"Experiment");
        SWTBotTreeItem project = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotTreeItem experiment = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Experiments", "Experiment"});
        FileUtils.copyDirectory((File)TEST_FILE_KERNEL_CLASH, (File)FileUtils.getFile((File)fTracesFolder, (String[])new String[]{TEST_FILE_KERNEL.getName()}), (boolean)false);
        Assert.assertTrue((boolean)kernelTrace.contextMenu().menuItems().contains("Delete Supplementary Files..."));
        Assert.assertTrue((boolean)experiment.contextMenu().menuItems().contains("Delete Supplementary Files..."));
        ProjectExplorerRefreshTest.refresh(() -> {
            SWTBotMenu sWTBotMenu = tracesFolder.contextMenu().menu(new String[]{"Refresh"}).click();
        });
        SWTBotShell shell = fBot.shell("Trace Changed");
        shell.bot().button("No").click();
        Assert.assertTrue((boolean)kernelTrace.contextMenu().menuItems().contains("Delete Supplementary Files..."));
        Assert.assertTrue((boolean)experiment.contextMenu().menuItems().contains("Delete Supplementary Files..."));
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)TEST_FILE_KERNEL.getName());
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)"Experiment");
        FileUtils.copyDirectory((File)TEST_FILE_KERNEL, (File)FileUtils.getFile((File)fTracesFolder, (String[])new String[]{TEST_FILE_KERNEL.getName()}), (boolean)true);
        Assert.assertTrue((boolean)kernelTrace.contextMenu().menuItems().contains("Delete Supplementary Files..."));
        ProjectExplorerRefreshTest.refresh(() -> {
            SWTBotMenu sWTBotMenu = tracesFolder.contextMenu().menu(new String[]{"Refresh"}).click();
        });
        shell = fBot.shell("Trace Changed");
        shell.bot().button("Yes").click();
        SWTBotUtils.waitUntil(treeItem -> !treeItem.contextMenu().menuItems().contains("Delete Supplementary Files..."), (Object)kernelTrace, (String)"Supplementary Files did not get deleted");
        Assert.assertEquals((long)0L, (long)fBot.editors().size());
    }

    @Test
    public void test16_03RefreshClosedTraceContentModified() throws IOException {
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotTreeItem kernelTrace = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)TEST_FILE_KERNEL.getName());
        SWTBotTreeItem ustTrace = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)TEST_FILE_UST.getName());
        kernelTrace.contextMenu().menu(new String[]{"Select Trace Type...", "Common Trace Format", "Linux Kernel Trace"}).click();
        kernelTrace.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)TEST_FILE_KERNEL.getName()).close();
        tracesFolder.contextMenu().menu(new String[]{"Open As Experiment...", "Generic Experiment"}).click();
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)"Experiment").close();
        SWTBotTreeItem project = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotTreeItem experiment = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Experiments", "Experiment"});
        FileUtils.touch((File)FileUtils.getFile((File)fTracesFolder, (String[])new String[]{TEST_FILE_KERNEL.getName(), "channel1"}));
        FileUtils.deleteQuietly((File)FileUtils.getFile((File)fTracesFolder, (String[])new String[]{TEST_FILE_UST.getName(), "channel0"}));
        Assert.assertTrue((boolean)kernelTrace.contextMenu().menuItems().contains("Delete Supplementary Files..."));
        Assert.assertTrue((boolean)ustTrace.contextMenu().menuItems().contains("Delete Supplementary Files..."));
        Assert.assertTrue((boolean)experiment.contextMenu().menuItems().contains("Delete Supplementary Files..."));
        ProjectExplorerRefreshTest.refresh(() -> {
            SWTBotMenu sWTBotMenu = tracesFolder.contextMenu().menu(new String[]{"Refresh"}).click();
        });
        SWTBotUtils.waitUntil(treeItem -> !treeItem.contextMenu().menuItems().contains("Delete Supplementary Files..."), (Object)kernelTrace, (String)"Supplementary Files did not get deleted");
        SWTBotUtils.waitUntil(treeItem -> !treeItem.contextMenu().menuItems().contains("Delete Supplementary Files..."), (Object)ustTrace, (String)"Supplementary Files did not get deleted");
        SWTBotUtils.waitUntil(treeItem -> !treeItem.contextMenu().menuItems().contains("Delete Supplementary Files..."), (Object)experiment, (String)"Supplementary Files did not get deleted");
    }

    @Test
    public void test16_04RefreshTraceDeleted() throws IOException {
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)2L, (long)tracesFolder.getItems().length);
        SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)TEST_FILE_KERNEL.getName());
        SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)TEST_FILE_UST.getName());
        FileUtils.deleteDirectory((File)FileUtils.getFile((File)fTracesFolder, (String[])new String[]{TEST_FILE_UST.getName()}));
        ProjectExplorerRefreshTest.refresh(() -> {
            SWTBotMenu sWTBotMenu = fBot.menu().menu(new String[]{"File", "Refresh"}).click();
        });
        Assert.assertEquals((long)1L, (long)tracesFolder.getItems().length);
        SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)TEST_FILE_KERNEL.getName());
    }

    @Test
    public void test16_05CProjectRefreshTraceDeleted() throws IOException {
        FileUtils.copyDirectory((File)TEST_FILE_KERNEL, (File)FileUtils.getFile((File)fCProjectFolder, (String[])new String[]{TEST_FILE_KERNEL.getName()}));
        FileUtils.copyDirectory((File)TEST_FILE_UST, (File)FileUtils.getFile((File)fCProjectFolder, (String[])new String[]{TEST_FILE_UST.getName()}));
        SWTBotTreeItem project = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)C_PROJECT_NAME);
        ProjectExplorerRefreshTest.refresh(() -> {
            SWTBotMenu sWTBotMenu = project.contextMenu().menu(new String[]{"Refresh"}).click();
        });
        SWTBotTreeItem tracesFolder = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Trace Compass", "Traces"});
        tracesFolder.contextMenu().menu(new String[]{"Import..."}).click();
        SWTBotImportWizardUtils.selectImportFromDirectory((SWTBot)fBot, (String)fCProjectFolder.getAbsolutePath());
        SWTBotImportWizardUtils.selectFolder((SWTBot)fBot, (boolean)true, (String[])new String[]{C_PROJECT_NAME, TEST_FILE_KERNEL.getName()});
        SWTBotImportWizardUtils.selectFolder((SWTBot)fBot, (boolean)true, (String[])new String[]{C_PROJECT_NAME, TEST_FILE_UST.getName()});
        SWTBotShell shell = fBot.shell("Trace Import");
        shell.bot().button("Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell), 120000L);
        WaitUtils.waitForJobs();
        tracesFolder.expand();
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)tracesFolder, (int)2));
        tracesFolder.contextMenu().menu(new String[]{"Open As Experiment...", "Generic Experiment"}).click();
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)"Experiment").close();
        SWTBotTreeItem experiment = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Trace Compass", "Experiments", "Experiment"});
        experiment.expand();
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)experiment, (int)5));
        FileUtils.deleteDirectory((File)FileUtils.getFile((File)fCProjectFolder, (String[])new String[]{TEST_FILE_UST.getName()}));
        ProjectExplorerRefreshTest.refresh(() -> {
            SWTBotMenu sWTBotMenu = project.contextMenu().menu(new String[]{"Refresh"}).click();
        });
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)tracesFolder, (int)1));
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)experiment, (int)4));
        FileUtils.deleteDirectory((File)FileUtils.getFile((File)fCProjectFolder, (String[])new String[]{TEST_FILE_KERNEL.getName()}));
        ProjectExplorerRefreshTest.refresh(() -> {
            SWTBotMenu sWTBotMenu = project.contextMenu().menu(new String[]{"Refresh"}).click();
        });
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)tracesFolder, (int)0));
        SWTBotTreeItem experimentsFolder = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Trace Compass", "Experiments"});
        experimentsFolder.expand();
        fBot.waitUntil(ConditionHelpers.treeItemCount((SWTBotTreeItem)experimentsFolder, (int)0));
    }

    private static void createCProject(String projectName) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.create((IProgressMonitor)monitor);
        project.open((IProgressMonitor)monitor);
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.cdt.core.cnature"});
        project.setDescription(description, (IProgressMonitor)monitor);
        project.open((IProgressMonitor)monitor);
    }

    private static void setTracingNature(String projectName) {
        SWTBotTreeItem projectItem = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)projectName);
        projectItem.contextMenu().menu(new String[]{"Configure", "Configure or convert to Tracing Project"}).click();
        WaitUtils.waitForJobs();
    }

    private static void refresh(Runnable runnable) {
        AtomicBoolean resourceChanged = new AtomicBoolean();
        IResourceChangeListener listener = event -> resourceChanged.set(true);
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
            SWTBotUtils.waitUntil(refresh -> {
                refresh.run();
                return resourceChanged.get();
            }, (Object)runnable, (String)"Resource change event not received");
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }
}

