/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests;

import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.internal.tmf.ui.views.statistics.TmfStatisticsViewImpl;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class AbstractImportAndReadSmokeTest {
    protected static final String TRACE_NAME = "scp_dest";
    protected static final String TRACE_FOLDER = "synctraces";
    protected static final String TRACE_TYPE_NAME = "Generic CTF Trace";
    protected static final @NonNull CtfTmfTrace fTrace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_DEST);
    protected static SWTWorkbenchBot fBot;
    protected static Wizard fWizard;
    protected static final Logger fLogger;
    protected static final long IMPORT_TIME_OUT = 180000L;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 50000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new NullAppender());
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void terminate() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.SYNC_DEST);
        fLogger.removeAllAppenders();
    }

    protected static void createProject(String traceProjectName) {
        SWTBotUtils.focusMainWindow((SWTBotShell[])fBot.shells());
        fBot.menu("File").menu("New").menu("Project...").click();
        fBot.shell("New Project").activate();
        SWTBotTree tree = fBot.tree();
        Assert.assertNotNull((Object)tree);
        String tracingKey = "Tracing";
        fBot.waitUntil(ConditionHelpers.isTreeNodeAvailable((String)"Tracing", (SWTBotTree)tree));
        SWTBotTreeItem tracingNode = tree.expandNode(new String[]{"Tracing"});
        tracingNode.select();
        String projectKey = "Tracing Project";
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Tracing Project", (SWTBotTreeItem)tracingNode));
        SWTBotTreeItem tracingProject = tracingNode.getNode("Tracing Project");
        Assert.assertNotNull((Object)tracingProject);
        tracingProject.select();
        tracingProject.click();
        SWTBotButton nextButton = fBot.button("Next >");
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)nextButton));
        nextButton.click();
        fBot.shell("Tracing Project").activate();
        SWTBotText text = fBot.text();
        text.setText(traceProjectName);
        fBot.button("Finish").click();
        WaitUtils.waitForJobs();
    }

    protected void importFinish() {
        this.importFinish(ImportConfirmation.CONTINUE);
    }

    protected void importFinish(ImportConfirmation confirmationMode) {
        SWTBotShell shell = fBot.activeShell();
        SWTBotButton finishButton = fBot.button("Finish");
        finishButton.click();
        if (confirmationMode == ImportConfirmation.RENAME_ALL) {
            SWTBotShell shell2 = fBot.shell("Confirmation").activate();
            SWTBotButton button = shell2.bot().button("Rename All");
            button.click();
        } else if (confirmationMode == ImportConfirmation.OVERWRITE_ALL) {
            SWTBotShell shell2 = fBot.shell("Confirmation").activate();
            SWTBotButton button = shell2.bot().button("Overwrite All");
            button.click();
        }
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell), 180000L);
        WaitUtils.waitForJobs();
    }

    protected void testPropertyView(IViewPart vp) {
        PropertySheet pv = (PropertySheet)vp;
        Assert.assertNotNull((Object)pv);
    }

    protected void testHistogramView(IViewPart vp, final TmfEventsEditor tmfEd) {
        final CtfTmfEvent desiredEvent1 = this.getEvent(100);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                tmfEd.setFocus();
                tmfEd.selectionChanged(new SelectionChangedEvent((ISelectionProvider)tmfEd, (ISelection)new StructuredSelection((Object)desiredEvent1)));
            }
        });
        WaitUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        CtfTmfEvent desiredEvent2 = this.getEvent(10000);
        SWTBotView hvBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.histogram");
        List hvTools = hvBot.getToolbarButtons();
        for (SWTBotToolbarButton hvTool : hvTools) {
            if (!hvTool.getToolTipText().toLowerCase().contains("lost")) continue;
            hvTool.click();
        }
        HistogramView hv = (HistogramView)vp;
        TmfSelectionRangeUpdatedSignal signal = new TmfSelectionRangeUpdatedSignal((Object)hv, desiredEvent1.getTimestamp());
        TmfSelectionRangeUpdatedSignal signal2 = new TmfSelectionRangeUpdatedSignal((Object)hv, desiredEvent2.getTimestamp());
        hv.updateTimeRange(100000L);
        WaitUtils.waitForJobs();
        hv.selectionRangeUpdated(signal);
        hv.broadcast((TmfSignal)signal);
        WaitUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        hv.updateTimeRange(1000000000L);
        WaitUtils.waitForJobs();
        hv.selectionRangeUpdated(signal2);
        hv.broadcast((TmfSignal)signal2);
        WaitUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        Assert.assertNotNull((Object)hv);
    }

    protected void testStatisticsView(IViewPart vp) {
        TmfStatisticsViewImpl sv = (TmfStatisticsViewImpl)vp;
        Assert.assertNotNull((Object)sv);
    }

    protected CtfTmfEvent getEvent(int rank) {
        ITmfContext ctx = fTrace.seekEvent((long)rank);
        CtfTmfEvent ret = fTrace.getNext(ctx);
        ctx.dispose();
        return ret;
    }

    protected IViewPart getViewPart(final String viewTile) {
        final IViewPart[] vps = new IViewPart[1];
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IViewReference[] viewRefs;
                IViewReference[] iViewReferenceArray = viewRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                int n = viewRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    IViewPart vp = viewRef.getView(true);
                    if (vp.getTitle().equals(viewTile)) {
                        vps[0] = vp;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return vps[0];
    }
}

