/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;

public class InstanceOfClassCheck
extends CheckOperation {
    private int position;
    private EClass clazz;

    public InstanceOfClassCheck(int position, EClass clazz) {
        this.position = position;
        this.clazz = clazz;
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) {
        Objects.requireNonNull(frame.getValue(this.position), () -> String.format("Invalid plan, variable %s unbound", this.position));
        if (frame.getValue(this.position) instanceof EObject) {
            return this.clazz.isSuperTypeOf(((EObject)frame.getValue(this.position)).eClass());
        }
        return false;
    }

    public String toString() {
        return "check     " + this.clazz.getName() + "(+" + this.position + ")";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position);
    }
}

