/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileMaskedTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class GenericTypeExtendSingleValue
implements ISearchOperation,
IIteratingSearchOperation {
    private final IInputKey type;
    private final List<Integer> positionList;
    private Iterator<? extends Object> it;
    private final VolatileMaskedTuple maskedTuple;
    private TupleMask indexerMask;
    private final int unboundVariableIndex;

    public GenericTypeExtendSingleValue(IInputKey type, int[] positions, TupleMask callMask, TupleMask indexerMask, int unboundVariableIndex) {
        Preconditions.checkArgument((positions.length == type.getArity() ? 1 : 0) != 0, (String)"The type %s requires %d parameters, but %d positions are provided", (Object[])new Object[]{type.getPrettyPrintableName(), type.getArity(), positions.length});
        ArrayList<Integer> modifiablePositionList = new ArrayList<Integer>();
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            modifiablePositionList.add(position);
            ++n2;
        }
        this.positionList = Collections.unmodifiableList(modifiablePositionList);
        this.type = type;
        this.unboundVariableIndex = unboundVariableIndex;
        this.maskedTuple = new VolatileMaskedTuple(callMask);
        this.indexerMask = indexerMask;
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }

    @Override
    public void onBacktrack(MatchingFrame frame, ISearchContext context) {
        frame.setValue(this.unboundVariableIndex, null);
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        this.maskedTuple.updateTuple((ITuple)frame);
        this.it = context.getRuntimeContext().enumerateValues(this.type, this.indexerMask, (ITuple)this.maskedTuple).iterator();
    }

    @Override
    public boolean execute(MatchingFrame frame, ISearchContext context) {
        if (this.it.hasNext()) {
            Object next = this.it.next();
            frame.setValue(this.unboundVariableIndex, next);
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return this.positionList;
    }

    public String toString() {
        return "extend    " + this.type.getPrettyPrintableName() + "(" + this.positionList.stream().map(input -> String.format("%s%d", Objects.equals(input, this.unboundVariableIndex) ? "-" : "+", input)).collect(Collectors.joining(", ")) + ")";
    }
}

