/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.util.EclipseCollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IDeltaBag;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiset;
import org.eclipse.viatra.query.runtime.matchers.util.JavaBagMemory;

public final class CollectionsFactory {
    private static final ICollectionsFramework FRAMEWORK = new EclipseCollectionsFactory();

    public static <K, V> Map<K, V> createMap() {
        return FRAMEWORK.createMap();
    }

    public static <K, V> Map<K, V> createMap(Map<K, V> initial) {
        return FRAMEWORK.createMap(initial);
    }

    public static <E> Set<E> createSet() {
        return FRAMEWORK.createSet();
    }

    public static <E> Set<E> createSet(Collection<E> initial) {
        return FRAMEWORK.createSet(initial);
    }

    public static <T> Set<T> emptySet(Object key) {
        return FRAMEWORK.createSet();
    }

    public static <E> MarkedSet<E> createMarkedSet() {
        return FRAMEWORK.createMarkedSet();
    }

    public static <T> IMultiset<T> createMultiset() {
        return FRAMEWORK.createMultiset();
    }

    public static <T> IMultiset<T> emptyMultiset(Object key) {
        return FRAMEWORK.createMultiset();
    }

    public static <T> IDeltaBag<T> createDeltaBag() {
        return FRAMEWORK.createDeltaBag();
    }

    public static <O> List<O> createObserverList() {
        return FRAMEWORK.createObserverList();
    }

    public static interface ICollectionsFramework {
        public <K, V> Map<K, V> createMap();

        public <K, V> Map<K, V> createMap(Map<K, V> var1);

        public <E> Set<E> createSet();

        public <E> Set<E> createSet(Collection<E> var1);

        public <E> MarkedSet<E> createMarkedSet();

        public <T> IMultiset<T> createMultiset();

        public <T> IDeltaBag<T> createDeltaBag();

        public <O> List<O> createObserverList();
    }

    public static class JavaCollectionsFactory
    implements ICollectionsFramework {
        @Override
        public <K, V> Map<K, V> createMap() {
            return new HashMap();
        }

        @Override
        public <K, V> Map<K, V> createMap(Map<K, V> initial) {
            return new HashMap<K, V>(initial);
        }

        @Override
        public <E> Set<E> createSet() {
            return new HashSet();
        }

        @Override
        public <E> Set<E> createSet(Collection<E> initial) {
            return new HashSet<E>(initial);
        }

        @Override
        public <T> IMultiset<T> createMultiset() {
            return new JavaBagMemory();
        }

        @Override
        public <O> List<O> createObserverList() {
            return new ArrayList(1);
        }

        @Override
        public <T> IDeltaBag<T> createDeltaBag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <E> MarkedSet<E> createMarkedSet() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface MarkedSet<E>
    extends Set<E> {
    }
}

