/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.event;

import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IMatchUpdateListener;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.MatchUpdateAdapter;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.event.EventHandler;
import org.eclipse.viatra.transformation.evm.api.event.adapter.EventSourceAdapter;
import org.eclipse.viatra.transformation.evm.notification.IAttributeMonitorListener;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDEventTypeEnum;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEvent;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventRealm;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventSourceSpecification;

public class ViatraQueryEventSource<Match extends IPatternMatch>
extends EventSourceAdapter<Match> {
    private final ViatraQueryMatcher<Match> matcher;
    private IAttributeMonitorListener<Match> attributeMonitorListener;
    private IMatchUpdateListener<Match> matchUpdateListener;

    protected ViatraQueryEventSource(ViatraQueryEventRealm realm, ViatraQueryEventSourceSpecification<Match> sourceDefinition) {
        super(sourceDefinition, realm);
        ViatraQueryMatcher<Match> _matcher = sourceDefinition.getMatcher(realm.getEngine());
        this.matcher = _matcher;
    }

    public ViatraQueryMatcher<Match> getMatcher() {
        return this.matcher;
    }

    @Override
    protected void beforeHandlerAdded(EventHandler<Match> handler, boolean handlersEmpty) {
        this.resendEventsForExistingMatches(handler);
        if (handlersEmpty) {
            ((AdvancedViatraQueryEngine)this.matcher.getEngine()).addMatchUpdateListener(this.matcher, this.matchUpdateListener, false);
        }
    }

    @Override
    protected void afterHandlerRemoved(EventHandler<Match> handler, boolean handlersEmpty) {
        if (handlersEmpty) {
            ((AdvancedViatraQueryEngine)this.matcher.getEngine()).removeMatchUpdateListener(this.matcher, this.matchUpdateListener);
        }
    }

    @Override
    protected void prepareSource() {
        this.attributeMonitorListener = this.prepareAttributeMonitorListener();
        this.matchUpdateListener = this.prepareMatchUpdateListener();
    }

    protected IAttributeMonitorListener<Match> prepareAttributeMonitorListener() {
        return atom -> this.notifyHandlers(new ViatraQueryEvent<IPatternMatch>(CRUDEventTypeEnum.UPDATED, (IPatternMatch)atom));
    }

    protected IMatchUpdateListener<Match> prepareMatchUpdateListener() {
        IMatchProcessor matchAppearProcessor = match -> this.notifyHandlers(new ViatraQueryEvent<IPatternMatch>(CRUDEventTypeEnum.CREATED, match));
        IMatchProcessor matchDisppearProcessor = match -> this.notifyHandlers(new ViatraQueryEvent<IPatternMatch>(CRUDEventTypeEnum.DELETED, match));
        return new MatchUpdateAdapter(matchAppearProcessor, matchDisppearProcessor);
    }

    private void resendEventsForExistingMatches(EventHandler<Match> handler) {
        this.matcher.forEachMatch(match -> handler.handleEvent(new ViatraQueryEvent<IPatternMatch>(CRUDEventTypeEnum.CREATED, match)));
    }

    @Override
    public void dispose() {
        ((AdvancedViatraQueryEngine)this.matcher.getEngine()).removeMatchUpdateListener(this.matcher, this.matchUpdateListener);
        super.dispose();
    }

    public IAttributeMonitorListener<Match> getAttributeMonitorListener() {
        Preconditions.checkState((this.attributeMonitorListener != null ? 1 : 0) != 0, (String)"Event source not prepared yet!");
        return this.attributeMonitorListener;
    }
}

