/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.runtime.core.IServerWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.ui.PDEHelper;
import org.eclipse.virgo.ide.runtime.internal.ui.PDEUIMessages;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.TargetPlatformEditWizard;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.TargetPlatformSectionMessages;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class TargetPlatformSection
extends ServerEditorSection {
    private static String FORM_TEXT = TargetPlatformSectionMessages.TargetPlatformSection_form_text;
    private IServerWorkingCopy serverWorkingCopy;

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText(TargetPlatformSectionMessages.TargetPlatformSection_title);
        section.setDescription(TargetPlatformSectionMessages.TargetPlatformSection_description);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        FormText text = toolkit.createFormText(composite, true);
        text.setText(FORM_TEXT, true, false);
        text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (!PDEHelper.existsTargetDefinition(TargetPlatformSection.this.server.getRuntime().getName())) {
                    MessageDialog.openInformation((Shell)TargetPlatformSection.this.getShell(), (String)TargetPlatformSectionMessages.TargetPlatformSection_not_configured_title, (String)TargetPlatformSectionMessages.TargetPlatformSection_not_configured_message);
                    return;
                }
                if ("refresh".equals(e.getHref())) {
                    TargetPlatformSection.this.refreshPressed();
                    return;
                }
                if ("edit".equals(e.getHref())) {
                    TargetPlatformSection.this.editPressed();
                    return;
                }
            }
        });
    }

    protected void editPressed() {
        TargetPlatformEditWizard wiz = new TargetPlatformEditWizard(this.server.getRuntime().createWorkingCopy());
        wiz.setWindowTitle(PDEUIMessages.PDETargetPlatformWizardFragment_title);
        WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)wiz);
        dlg.setTitle(PDEUIMessages.PDETargetPlatformWizardFragment_title);
        dlg.open();
    }

    protected void refreshPressed() {
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
        try {
            dlg.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        PDEHelper.refreshTargetDefinition(monitor, TargetPlatformSection.this.server.getRuntime().getName());
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e.getStatus(), 2);
                    }
                }
            });
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", e.getMessage(), (Throwable)e), 3);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
    }
}

