/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeFieldAssistDisposer;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.virgo.ide.ui.editors.AbstractPdeGeneralInfoSection;

public class BundleGeneralInfoSection
extends AbstractPdeGeneralInfoSection {
    private FormEntry fClassEntry;
    private TypeFieldAssistDisposer fTypeFieldAssistDisposer;

    public BundleGeneralInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent);
    }

    protected void createSpecificControls(Composite parent, FormToolkit toolkit, IActionBars actionBars) {
        this.createClassEntry(parent, toolkit, actionBars);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ManifestEditor_PluginSpecSection_title);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout((boolean)false, (int)1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        section.setDescription(this.getSectionDescription());
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout((boolean)false, (int)3));
        section.setClient((Control)client);
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.createIDEntry(client, toolkit, actionBars);
        this.createVersionEntry(client, toolkit, actionBars);
        this.createNameEntry(client, toolkit, actionBars);
        this.createProviderEntry(client, toolkit, actionBars);
        this.createSpecificControls(client, toolkit, actionBars);
        toolkit.paintBordersFor(client);
        this.addListeners();
    }

    private void createClassEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        boolean isEditable = this.isEditable();
        this.fClassEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_class, PDEUIMessages.GeneralInfoSection_browse, this.isEditable());
        this.fClassEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this, actionBars){

            public void textValueChanged(FormEntry entry) {
                try {
                    ((IPlugin)BundleGeneralInfoSection.this.getPluginBase()).setClassName(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException((Throwable)e);
                }
            }

            public void linkActivated(HyperlinkEvent e) {
                String value = BundleGeneralInfoSection.this.fClassEntry.getValue();
                IProject project = BundleGeneralInfoSection.this.getPage().getPDEEditor().getCommonProject();
                if ((value = PDEJavaHelperUI.createClass((String)value, (IProject)project, (JavaAttributeValue)BundleGeneralInfoSection.this.createJavaAttributeValue(), (boolean)false)) != null) {
                    BundleGeneralInfoSection.this.fClassEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                BundleGeneralInfoSection.this.doOpenSelectionDialog(entry.getValue());
            }
        });
        this.fClassEntry.setEditable(isEditable);
        if (isEditable) {
            this.fTypeFieldAssistDisposer = PDEJavaHelperUI.addTypeFieldAssistToText((Text)this.fClassEntry.getText(), (IProject)this.getProject(), (int)5);
        }
    }

    private JavaAttributeValue createJavaAttributeValue() {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        return new JavaAttributeValue(project, model, null, this.fClassEntry.getValue());
    }

    private void doOpenSelectionDialog(String className) {
        IResource resource = this.getPluginBase().getModel().getUnderlyingResource();
        String type = PDEJavaHelperUI.selectType((IResource)resource, (int)2, (String)className, null);
        if (type != null) {
            this.fClassEntry.setValue(type);
        }
    }

    protected String getSectionDescription() {
        return "This section describes general information about this bundle";
    }

    public String getBundleName() {
        return this.fNameEntry.getText().getText();
    }

    public void dispose() {
        super.dispose();
        if (this.fTypeFieldAssistDisposer != null) {
            this.fTypeFieldAssistDisposer.dispose();
        }
    }

    public void commit(boolean onSave) {
        this.fClassEntry.commit();
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.fClassEntry.cancelEdit();
        super.cancelEdit();
    }

    public void refresh() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            IPlugin plugin = (IPlugin)model.getPluginBase();
            if (!this.fClassEntry.isDirty()) {
                this.fClassEntry.setValue(plugin.getClassName(), true);
            }
        }
        super.refresh();
    }
}

