/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JarResource;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.TldLocation;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JspCompilationContext {
    private final Log log = LogFactory.getLog(JspCompilationContext.class);
    protected Map<String, JarResource> tagFileJarUrls;
    protected boolean isPackagedTagFile;
    protected String className;
    protected String jspUri;
    protected boolean isErrPage;
    protected String basePackageName;
    protected String derivedPackageName;
    protected String servletJavaFileName;
    protected String javaPath;
    protected String classFileName;
    protected String contentType;
    protected ServletWriter writer;
    protected Options options;
    protected JspServletWrapper jsw;
    protected Compiler jspCompiler;
    protected String classPath;
    protected String baseURI;
    protected String outputDir;
    protected ServletContext context;
    protected ClassLoader loader;
    protected JspRuntimeContext rctxt;
    protected volatile int removed = 0;
    protected URLClassLoader jspLoader;
    protected URL baseUrl;
    protected Class<?> servletClass;
    protected boolean isTagFile;
    protected boolean protoTypeMode;
    protected TagInfo tagInfo;
    protected JarResource tagJarResource;
    static Object outputDirLock = new Object();

    public JspCompilationContext(String jspUri, boolean isErrPage, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt) {
        this.jspUri = JspCompilationContext.canonicalURI(jspUri);
        this.isErrPage = isErrPage;
        this.options = options;
        this.jsw = jsw;
        this.context = context;
        this.baseURI = jspUri.substring(0, jspUri.lastIndexOf(47) + 1);
        if (this.baseURI == null) {
            this.baseURI = "/";
        } else if (this.baseURI.charAt(0) != '/') {
            this.baseURI = "/" + this.baseURI;
        }
        if (this.baseURI.charAt(this.baseURI.length() - 1) != '/') {
            this.baseURI = this.baseURI + '/';
        }
        this.rctxt = rctxt;
        this.tagFileJarUrls = new HashMap<String, JarResource>();
        this.basePackageName = Constants.JSP_PACKAGE_NAME;
    }

    public JspCompilationContext(String tagfile, TagInfo tagInfo, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt, JarResource tagJarResource) {
        this(tagfile, false, options, context, jsw, rctxt);
        this.isTagFile = true;
        this.tagInfo = tagInfo;
        this.tagJarResource = tagJarResource;
        if (tagJarResource != null) {
            this.isPackagedTagFile = true;
        }
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return this.rctxt.getClassPath();
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.rctxt.getParentClassLoader();
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getJspLoader() {
        if (this.jspLoader == null) {
            this.jspLoader = new JasperLoader(new URL[]{this.baseUrl}, this.getClassLoader(), this.rctxt.getPermissionCollection());
        }
        return this.jspLoader;
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            this.createOutputDir();
        }
        return this.outputDir;
    }

    public Compiler createCompiler() {
        if (this.jspCompiler != null) {
            return this.jspCompiler;
        }
        this.jspCompiler = null;
        if (this.options.getCompilerClassName() != null) {
            this.jspCompiler = this.createCompiler(this.options.getCompilerClassName());
        } else if (this.options.getCompiler() == null) {
            this.jspCompiler = this.createCompiler("org.apache.jasper.compiler.JDTCompiler");
            if (this.jspCompiler == null) {
                this.jspCompiler = this.createCompiler("org.apache.jasper.compiler.AntCompiler");
            }
        } else {
            this.jspCompiler = this.createCompiler("org.apache.jasper.compiler.AntCompiler");
            if (this.jspCompiler == null) {
                this.jspCompiler = this.createCompiler("org.apache.jasper.compiler.JDTCompiler");
            }
        }
        if (this.jspCompiler == null) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.compiler"));
        }
        this.jspCompiler.init(this, this.jsw);
        return this.jspCompiler;
    }

    protected Compiler createCompiler(String className) {
        Compiler compiler;
        block6: {
            compiler = null;
            try {
                compiler = (Compiler)Class.forName(className).newInstance();
            }
            catch (InstantiationException e) {
                this.log.warn((Object)Localizer.getMessage("jsp.error.compiler"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.warn((Object)Localizer.getMessage("jsp.error.compiler"), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)Localizer.getMessage("jsp.error.compiler"), (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                if (!this.log.isDebugEnabled()) break block6;
                this.log.debug((Object)Localizer.getMessage("jsp.error.compiler"), (Throwable)e);
            }
        }
        return compiler;
    }

    public Compiler getCompiler() {
        return this.jspCompiler;
    }

    public String resolveRelativeUri(String uri) {
        if (uri.startsWith("/") || uri.startsWith(File.separator)) {
            return uri;
        }
        return this.baseURI + uri;
    }

    public InputStream getResourceAsStream(String res) {
        return this.context.getResourceAsStream(JspCompilationContext.canonicalURI(res));
    }

    public URL getResource(String res) throws MalformedURLException {
        URL result = null;
        if (res.startsWith("/META-INF/")) {
            JarResource jarResource = this.tagFileJarUrls.get(res);
            if (jarResource == null) {
                jarResource = this.tagJarResource;
            }
            result = jarResource != null ? jarResource.getEntry(res.substring(1)) : this.context.getResource(JspCompilationContext.canonicalURI(res));
        } else {
            result = res.startsWith("jar:file:") ? new URL(res) : this.context.getResource(JspCompilationContext.canonicalURI(res));
        }
        return result;
    }

    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(JspCompilationContext.canonicalURI(path));
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }

    public JarResource getTagFileJarResource(String tagFile) {
        return this.tagFileJarUrls.get(tagFile);
    }

    public void setTagFileJarResource(String tagFile, JarResource jarResource) {
        this.tagFileJarUrls.put(tagFile, jarResource);
    }

    public JarResource getTagFileJarResource() {
        return this.tagJarResource;
    }

    public String getServletClassName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.isTagFile) {
            this.className = this.tagInfo.getTagClassName();
            int lastIndex = this.className.lastIndexOf(46);
            if (lastIndex != -1) {
                this.className = this.className.substring(lastIndex + 1);
            }
        } else {
            int iSep = this.jspUri.lastIndexOf(47) + 1;
            this.className = JspUtil.makeJavaIdentifier(this.jspUri.substring(iSep));
        }
        return this.className;
    }

    public void setServletClassName(String className) {
        this.className = className;
    }

    public String getJspFile() {
        return this.jspUri;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public void setTagInfo(TagInfo tagi) {
        this.tagInfo = tagi;
    }

    public boolean isPrototypeMode() {
        return this.protoTypeMode;
    }

    public void setPrototypeMode(boolean pm) {
        this.protoTypeMode = pm;
    }

    public String getServletPackageName() {
        if (this.isTagFile()) {
            String className = this.tagInfo.getTagClassName();
            int lastIndex = className.lastIndexOf(46);
            String pkgName = "";
            if (lastIndex != -1) {
                pkgName = className.substring(0, lastIndex);
            }
            return pkgName;
        }
        String dPackageName = this.getDerivedPackageName();
        if (dPackageName.length() == 0) {
            return this.basePackageName;
        }
        return this.basePackageName + '.' + this.getDerivedPackageName();
    }

    protected String getDerivedPackageName() {
        if (this.derivedPackageName == null) {
            int iSep = this.jspUri.lastIndexOf(47);
            this.derivedPackageName = iSep > 0 ? JspUtil.makeJavaPackage(this.jspUri.substring(1, iSep)) : "";
        }
        return this.derivedPackageName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.basePackageName = servletPackageName;
    }

    public String getServletJavaFileName() {
        if (this.servletJavaFileName == null) {
            this.servletJavaFileName = this.getOutputDir() + this.getServletClassName() + ".java";
        }
        return this.servletJavaFileName;
    }

    public Options getOptions() {
        return this.options;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public JspRuntimeContext getRuntimeContext() {
        return this.rctxt;
    }

    public String getJavaPath() {
        if (this.javaPath != null) {
            return this.javaPath;
        }
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            this.javaPath = tagName.replace('.', '/') + ".java";
        } else {
            this.javaPath = this.getServletPackageName().replace('.', '/') + '/' + this.getServletClassName() + ".java";
        }
        return this.javaPath;
    }

    public String getClassFileName() {
        if (this.classFileName == null) {
            this.classFileName = this.getOutputDir() + this.getServletClassName() + ".class";
        }
        return this.classFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public TldLocation getTldLocation(String uri) throws JasperException {
        TldLocation location = this.getOptions().getTldLocationsCache().getLocation(uri);
        return location;
    }

    public boolean keepGenerated() {
        return this.getOptions().getKeepGenerated();
    }

    public void incrementRemoved() {
        if (this.removed == 0 && this.rctxt != null) {
            this.rctxt.removeWrapper(this.jspUri);
        }
        ++this.removed;
    }

    public boolean isRemoved() {
        return this.removed > 0;
    }

    public void compile() throws JasperException, FileNotFoundException {
        this.createCompiler();
        if (this.jspCompiler.isOutDated()) {
            if (this.isRemoved()) {
                throw new FileNotFoundException(this.jspUri);
            }
            try {
                this.jspCompiler.removeGeneratedFiles();
                this.jspLoader = null;
                this.jspCompiler.compile();
                this.jsw.setReload(true);
                this.jsw.setCompilationException(null);
            }
            catch (JasperException ex) {
                this.jsw.setCompilationException(ex);
                if (this.options.getDevelopment() && this.options.getRecompileOnFail()) {
                    this.jsw.setLastModificationTest(-1L);
                }
                throw ex;
            }
            catch (Exception ex) {
                JasperException je = new JasperException(Localizer.getMessage("jsp.error.unable.compile"), ex);
                this.jsw.setCompilationException(je);
                throw je;
            }
        }
    }

    public Class<?> load() throws JasperException {
        try {
            this.getJspLoader();
            String name = this.getFQCN();
            this.servletClass = this.jspLoader.loadClass(name);
        }
        catch (ClassNotFoundException cex) {
            throw new JasperException(Localizer.getMessage("jsp.error.unable.load"), cex);
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.unable.compile"), ex);
        }
        this.removed = 0;
        return this.servletClass;
    }

    public String getFQCN() {
        String name = this.isTagFile() ? this.tagInfo.getTagClassName() : this.getServletPackageName() + "." + this.getServletClassName();
        return name;
    }

    public void checkOutputDir() {
        if (this.outputDir != null) {
            if (!new File(this.outputDir).exists()) {
                this.makeOutputDir();
            }
        } else {
            this.createOutputDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean makeOutputDir() {
        Object object = outputDirLock;
        synchronized (object) {
            File outDirFile = new File(this.outputDir);
            return outDirFile.exists() || outDirFile.mkdirs();
        }
    }

    protected void createOutputDir() {
        String path = null;
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            path = tagName.replace('.', File.separatorChar);
            path = path.substring(0, path.lastIndexOf(File.separatorChar));
        } else {
            path = this.getServletPackageName().replace('.', File.separatorChar);
        }
        try {
            File base = this.options.getScratchDir();
            this.baseUrl = base.toURI().toURL();
            this.outputDir = base.getAbsolutePath() + File.separator + path + File.separator;
            if (!this.makeOutputDir()) {
                throw new IllegalStateException(Localizer.getMessage("jsp.error.outputfolder"));
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.outputfolder"), e);
        }
    }

    protected static final boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    protected static final String canonicalURI(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int len = s.length();
        int pos = 0;
        block4: while (pos < len) {
            char c = s.charAt(pos);
            if (JspCompilationContext.isPathSeparator(c)) {
                while (pos + 1 < len && JspCompilationContext.isPathSeparator(s.charAt(pos + 1))) {
                    ++pos;
                }
                if (pos + 1 < len && s.charAt(pos + 1) == '.') {
                    if (pos + 2 >= len) break;
                    switch (s.charAt(pos + 2)) {
                        case '/': 
                        case '\\': {
                            pos += 2;
                            continue block4;
                        }
                        case '.': {
                            int separatorPos;
                            if (pos + 3 >= len || !JspCompilationContext.isPathSeparator(s.charAt(pos + 3))) break;
                            pos += 3;
                            for (separatorPos = result.length() - 1; separatorPos >= 0 && !JspCompilationContext.isPathSeparator(result.charAt(separatorPos)); --separatorPos) {
                            }
                            if (separatorPos < 0) continue block4;
                            result.setLength(separatorPos);
                            continue block4;
                        }
                    }
                }
            }
            result.append(c);
            ++pos;
        }
        return result.toString();
    }
}

