/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.LocallyExposedJmsResourceHolder;
import org.springframework.jms.support.JmsUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;

public abstract class AbstractPollingMessageListenerContainer
extends AbstractMessageListenerContainer
implements BeanNameAware {
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    private final MessageListenerContainerResourceFactory transactionalResourceFactory = new MessageListenerContainerResourceFactory();
    private boolean sessionTransactedCalled = false;
    private boolean pubSubNoLocal = false;
    private PlatformTransactionManager transactionManager;
    private DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    private long receiveTimeout = 1000L;

    public void setSessionTransacted(boolean sessionTransacted) {
        super.setSessionTransacted(sessionTransacted);
        this.sessionTransactedCalled = true;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    protected boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected final PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionName(String transactionName) {
        this.transactionDefinition.setName(transactionName);
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionDefinition.setTimeout(transactionTimeout);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void initialize() {
        if (!this.sessionTransactedCalled && this.transactionManager instanceof ResourceTransactionManager && !TransactionSynchronizationUtils.sameResourceFactory((ResourceTransactionManager)((ResourceTransactionManager)this.transactionManager), (Object)this.getConnectionFactory())) {
            super.setSessionTransacted(true);
        }
        if (this.transactionDefinition.getName() == null) {
            this.transactionDefinition.setName(this.getBeanName());
        }
        super.initialize();
    }

    protected MessageConsumer createListenerConsumer(Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        return this.createConsumer(session, destination);
    }

    protected boolean receiveAndExecute(Object invoker, Session session, MessageConsumer consumer) throws JMSException {
        if (this.transactionManager != null) {
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)this.transactionDefinition);
            boolean messageReceived = true;
            try {
                messageReceived = this.doReceiveAndExecute(invoker, session, consumer, status);
            }
            catch (JMSException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (Error err) {
                this.rollbackOnException(status, err);
                throw err;
            }
            this.transactionManager.commit(status);
            return messageReceived;
        }
        return this.doReceiveAndExecute(invoker, session, consumer, null);
    }

    protected boolean doReceiveAndExecute(Object invoker, Session session, MessageConsumer consumer, TransactionStatus status) throws JMSException {
        MessageConsumer consumerToUse;
        boolean transactional;
        Session sessionToUse;
        MessageConsumer consumerToClose;
        Session sessionToClose;
        Connection conToClose;
        block20: {
            block22: {
                conToClose = null;
                sessionToClose = null;
                consumerToClose = null;
                try {
                    boolean exposeResource;
                    Message message;
                    sessionToUse = session;
                    transactional = false;
                    if (sessionToUse == null) {
                        sessionToUse = ConnectionFactoryUtils.doGetTransactionalSession(this.getConnectionFactory(), this.transactionalResourceFactory, true);
                        boolean bl = transactional = sessionToUse != null;
                    }
                    if (sessionToUse == null) {
                        Connection conToUse = null;
                        if (this.sharedConnectionEnabled()) {
                            conToUse = this.getSharedConnection();
                        } else {
                            conToClose = conToUse = this.createConnection();
                            conToUse.start();
                        }
                        sessionToClose = sessionToUse = this.createSession(conToUse);
                    }
                    if ((consumerToUse = consumer) == null) {
                        consumerToClose = consumerToUse = this.createListenerConsumer(sessionToUse);
                    }
                    if ((message = this.receiveMessage(consumerToUse)) == null) break block20;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Received message of type [" + message.getClass() + "] from consumer [" + consumerToUse + "] of " + (transactional ? "transactional " : "") + "session [" + sessionToUse + "]"));
                    }
                    this.messageReceived(invoker, sessionToUse);
                    boolean bl = exposeResource = !transactional && this.isExposeListenerSession() && !TransactionSynchronizationManager.hasResource((Object)this.getConnectionFactory());
                    if (exposeResource) {
                        TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)new LocallyExposedJmsResourceHolder(sessionToUse)));
                    }
                    try {
                        try {
                            this.doExecuteListener(sessionToUse, message);
                        }
                        catch (Throwable ex) {
                            if (status != null) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug((Object)("Rolling back transaction because of listener exception thrown: " + ex));
                                }
                                status.setRollbackOnly();
                            }
                            this.handleListenerException(ex);
                            if (ex instanceof JMSException) {
                                throw (JMSException)ex;
                            }
                            if (exposeResource) {
                                TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
                            }
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        if (exposeResource) {
                            TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
                        }
                        throw throwable;
                    }
                    if (!exposeResource) break block22;
                    TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
                }
                catch (Throwable throwable) {
                    JmsUtils.closeMessageConsumer(consumerToClose);
                    JmsUtils.closeSession(sessionToClose);
                    ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), true);
                    throw throwable;
                }
            }
            JmsUtils.closeMessageConsumer(consumerToClose);
            JmsUtils.closeSession(sessionToClose);
            ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), true);
            return true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Consumer [" + consumerToUse + "] of " + (transactional ? "transactional " : "") + "session [" + sessionToUse + "] did not receive a message"));
        }
        this.noMessageReceived(invoker, sessionToUse);
        JmsUtils.closeMessageConsumer(consumerToClose);
        JmsUtils.closeSession(sessionToClose);
        ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), true);
        return false;
    }

    protected boolean isSessionLocallyTransacted(Session session) {
        if (!super.isSessionLocallyTransacted(session)) {
            return false;
        }
        JmsResourceHolder resourceHolder = (JmsResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory()));
        return resourceHolder == null || resourceHolder instanceof LocallyExposedJmsResourceHolder || !resourceHolder.containsSession(session);
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) {
        this.logger.debug((Object)"Initiating transaction rollback on listener exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Listener exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Listener exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected Message receiveMessage(MessageConsumer consumer) throws JMSException {
        return this.receiveTimeout < 0L ? consumer.receive() : consumer.receive(this.receiveTimeout);
    }

    protected void messageReceived(Object invoker, Session session) {
    }

    protected void noMessageReceived(Object invoker, Session session) {
    }

    protected Connection getConnection(JmsResourceHolder holder) {
        return holder.getConnection();
    }

    protected Session getSession(JmsResourceHolder holder) {
        return holder.getSession();
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain()) {
            if (this.isSubscriptionDurable() && destination instanceof Topic) {
                return session.createDurableSubscriber((Topic)destination, this.getDurableSubscriptionName(), this.getMessageSelector(), this.isPubSubNoLocal());
            }
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }

    private class MessageListenerContainerResourceFactory
    implements ConnectionFactoryUtils.ResourceFactory {
        private MessageListenerContainerResourceFactory() {
        }

        public Connection getConnection(JmsResourceHolder holder) {
            return AbstractPollingMessageListenerContainer.this.getConnection(holder);
        }

        public Session getSession(JmsResourceHolder holder) {
            return AbstractPollingMessageListenerContainer.this.getSession(holder);
        }

        public Connection createConnection() throws JMSException {
            if (AbstractPollingMessageListenerContainer.this.sharedConnectionEnabled()) {
                Connection sharedCon = AbstractPollingMessageListenerContainer.this.getSharedConnection();
                return new SingleConnectionFactory(sharedCon).createConnection();
            }
            return AbstractPollingMessageListenerContainer.this.createConnection();
        }

        public Session createSession(Connection con) throws JMSException {
            return AbstractPollingMessageListenerContainer.this.createSession(con);
        }

        public boolean isSynchedLocalTransactionAllowed() {
            return AbstractPollingMessageListenerContainer.this.isSessionTransacted();
        }
    }
}

