/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.core;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstallationOptions {
    private final String bundleSymbolicName;
    private final String bundleVersion;
    private final String bundleManifestVersion;
    private final String bundleClassPath;
    private final String importPackageDeclaration;
    private final String exportPackageDeclaration;
    private final String webContextPath;
    private final String webJSPExtractLocation;
    private volatile boolean defaultWABHeaders;

    public InstallationOptions(Map<String, String> options) {
        Map<String, String> normalisedOptions = this.normalise(options);
        this.bundleSymbolicName = normalisedOptions.get("Bundle-SymbolicName");
        this.bundleVersion = normalisedOptions.get("Bundle-Version");
        this.bundleManifestVersion = normalisedOptions.get("Bundle-ManifestVersion");
        this.bundleClassPath = normalisedOptions.get("Bundle-ClassPath");
        this.importPackageDeclaration = normalisedOptions.get("Import-Package");
        this.exportPackageDeclaration = normalisedOptions.get("Export-Package");
        this.webContextPath = normalisedOptions.get("Web-ContextPath");
        this.webJSPExtractLocation = normalisedOptions.get("Web-JSPExtractLocation");
        this.defaultWABHeaders = options.get("SpringSource-DefaultWABHeaders") != null;
    }

    private Map<String, String> normalise(Map<String, String> options) {
        Set<String> keys = options.keySet();
        CaseInsensitiveMap normalisedOptions = new CaseInsensitiveMap();
        for (String key : keys) {
            normalisedOptions.put(key, options.get(key));
        }
        return normalisedOptions;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public String getBundleManifestVersion() {
        return this.bundleManifestVersion;
    }

    public String getBundleClassPath() {
        return this.bundleClassPath;
    }

    public String getImportPackageDeclaration() {
        return this.importPackageDeclaration;
    }

    public String getExportPackageDeclaration() {
        return this.exportPackageDeclaration;
    }

    public String getWebContextPath() {
        return this.webContextPath;
    }

    public String getWebJSPExtractLocation() {
        return this.webJSPExtractLocation;
    }

    public boolean getDefaultWABHeaders() {
        return this.defaultWABHeaders;
    }

    public void setDefaultWABHeaders(boolean defaultWABHeaders) {
        this.defaultWABHeaders = defaultWABHeaders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CaseInsensitiveMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = -514044030419642872L;

        private CaseInsensitiveMap() {
        }

        @Override
        public String get(Object key) {
            if (key instanceof String) {
                return (String)super.get(this.normaliseOption((String)key));
            }
            return (String)super.get(key);
        }

        @Override
        public String put(String key, String value) {
            return super.put(this.normaliseOption(key), value);
        }

        private String normaliseOption(String key) {
            return key.toLowerCase(Locale.ENGLISH);
        }
    }
}

