/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.parser.manifest.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.util.parser.manifest.ManifestProblem;
import org.eclipse.virgo.util.parser.manifest.internal.SourceContext;
import org.eclipse.virgo.util.parser.manifest.internal.Token;
import org.eclipse.virgo.util.parser.manifest.internal.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTokenStream
implements TokenStream {
    private int tokenStreamPosition = 0;
    private List<Token> tokens = new ArrayList<Token>();
    private int tokenStreamLen;
    private List<ManifestProblem> problems = new ArrayList<ManifestProblem>();
    private SourceContext sourceContext;

    SimpleTokenStream() {
        this.tokens.clear();
        this.tokenStreamPosition = 0;
    }

    public String toString() {
        return this.toFormattedString(true);
    }

    @Override
    public int getCount() {
        return this.tokens.size();
    }

    @Override
    public int getPosition() {
        return this.tokenStreamPosition;
    }

    @Override
    public Token next() {
        if (this.tokenStreamPosition >= this.tokenStreamLen) {
            return null;
        }
        return this.tokens.get(this.tokenStreamPosition++);
    }

    @Override
    public void setPosition(int newPosition) {
        this.tokenStreamPosition = newPosition;
    }

    @Override
    public Token peek() {
        if (this.tokenStreamPosition >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        return this.tokens.get(this.tokenStreamPosition);
    }

    @Override
    public Token peekLast() {
        return this.tokens.get(this.tokens.size() - 1);
    }

    @Override
    public Token peek(int offset) {
        if (this.tokenStreamPosition + offset >= this.tokenStreamLen) {
            return null;
        }
        return this.tokens.get(this.tokenStreamPosition + offset);
    }

    @Override
    public String toFormattedString() {
        return this.toFormattedString(true);
    }

    @Override
    public String toFormattedString(boolean includePositionsInOutput) {
        StringBuilder sb = new StringBuilder();
        sb.append("TokenStream:#").append(this.tokens.size()).append(" tokens:");
        sb.append("[");
        int i = 0;
        for (Token token : this.tokens) {
            if (i > 0) {
                sb.append(",");
            }
            if (includePositionsInOutput) {
                sb.append(token.toString());
            } else {
                sb.append(token.value());
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    void addToken(Token token) {
        this.tokens.add(token);
    }

    @Override
    public boolean containsProblems() {
        return !this.problems.isEmpty();
    }

    @Override
    public List<ManifestProblem> getProblems() {
        return this.problems;
    }

    @Override
    public SourceContext getSourceContext() {
        return this.sourceContext;
    }

    @Override
    public boolean hasMore() {
        return this.tokenStreamPosition < this.tokens.size();
    }

    @Override
    public void recordProblem(ManifestProblem manifestProblem) {
        this.problems.add(manifestProblem);
    }

    public void setSourceContext(SourceContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    public void lexComplete() {
        this.tokenStreamLen = this.tokens.size();
    }
}

