/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class StaticMethodCallNode
extends MethodCallNode {
    private TableName procedureName;
    private LocalField[] outParamArrays;
    private int[] applicationParameterNumbers;
    private boolean isSystemCode;
    private boolean alreadyBound;
    private LocalField returnsNullOnNullState;
    private String routineDefiner = null;
    AliasDescriptor ad;

    public void init(Object object, Object object2) {
        if (object instanceof String) {
            this.init(object);
        } else {
            this.procedureName = (TableName)object;
            this.init(this.procedureName.getTableName());
        }
        this.javaClassName = (String)object2;
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        Object object;
        Object object2;
        Object object3;
        if (this.alreadyBound) {
            return this;
        }
        this.bindParameters(fromList, subqueryList, vector);
        if (this.javaClassName == null) {
            object3 = this.getCompilerContext();
            object2 = this.procedureName.getSchemaName();
            boolean bl = object2 == null;
            object = this.getSchemaDescriptor((String)object2, object2 != null);
            this.resolveRoutine(fromList, subqueryList, vector, (SchemaDescriptor)object);
            if (this.ad == null && bl && !this.forCallStatement) {
                object = this.getSchemaDescriptor("SYSFUN", true);
                this.resolveRoutine(fromList, subqueryList, vector, (SchemaDescriptor)object);
            }
            if (this.ad == null) {
                throw StandardException.newException("42Y03.S.0", this.procedureName);
            }
            if (!this.routineInfo.isDeterministic()) {
                this.checkReliability(this.getMethodName(), 4096);
            }
            if (this.permitsSQL(this.routineInfo)) {
                this.checkReliability(this.getMethodName(), 8192);
            }
            object3.createDependency(this.ad);
            this.methodName = this.ad.getAliasInfo().getMethodName();
            this.javaClassName = this.ad.getJavaClassName();
            if (this.javaClassName.startsWith("org.apache.derby.") && !((SchemaDescriptor)object).isSystemSchema()) {
                throw StandardException.newException("42X51", null, (Object)this.javaClassName);
            }
        }
        this.verifyClassExist(this.javaClassName);
        this.resolveMethodCall(this.javaClassName, true);
        this.alreadyBound = true;
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredRoutinePriv(this.ad);
        }
        if (this.routineInfo != null) {
            if (this.methodParms != null) {
                this.optimizeDomainValueConversion();
            }
            if ((object3 = this.routineInfo.getReturnType()) != null) {
                this.createTypeDependency(DataTypeDescriptor.getType((TypeDescriptor)object3));
            }
            if (object3 != null && !object3.isRowMultiSet() && !object3.isUserDefinedType() && ((TypeId)(object2 = TypeId.getBuiltInTypeId(object3.getJDBCTypeId()))).variableLength()) {
                DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor((TypeId)object2, object3.getPrecision(), object3.getScale(), object3.isNullable(), object3.getMaximumWidth());
                object = (ValueNode)this.getNodeFactory().getNode(36, this, this.getContextManager());
                ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(60, object, dataTypeDescriptor, this.getContextManager());
                valueNode.setCollationInfo(object3.getCollationType(), 1);
                JavaValueNode javaValueNode = (JavaValueNode)this.getNodeFactory().getNode(28, valueNode, this.getContextManager());
                javaValueNode.setCollationType(object3.getCollationType());
                return javaValueNode.bindExpression(fromList, subqueryList, vector);
            }
        }
        return this;
    }

    private boolean permitsSQL(RoutineAliasInfo routineAliasInfo) {
        short s = routineAliasInfo.getSQLAllowed();
        switch (s) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private void optimizeDomainValueConversion() throws StandardException {
        if (!this.routineInfo.calledOnNullInput()) {
            return;
        }
        int n = this.methodParms.length;
        for (int i = 0; i < n; ++i) {
            JavaValueNode javaValueNode;
            if (this.methodParms != null && this.methodParms[i].mustCastToPrimitive() || !(this.methodParms[i] instanceof SQLToJavaValueNode) || !(((SQLToJavaValueNode)this.methodParms[i]).getSQLValueNode() instanceof JavaToSQLValueNode) || !((javaValueNode = ((JavaToSQLValueNode)((SQLToJavaValueNode)this.methodParms[i]).getSQLValueNode()).getJavaValueNode()) instanceof StaticMethodCallNode)) continue;
            StaticMethodCallNode staticMethodCallNode = (StaticMethodCallNode)javaValueNode;
            if (staticMethodCallNode.routineInfo == null || !staticMethodCallNode.routineInfo.calledOnNullInput()) continue;
            this.methodParms[i] = ((JavaToSQLValueNode)((SQLToJavaValueNode)this.methodParms[i]).getSQLValueNode()).getJavaValueNode();
        }
    }

    private void resolveRoutine(FromList fromList, SubqueryList subqueryList, Vector vector, SchemaDescriptor schemaDescriptor) throws StandardException {
        if (schemaDescriptor.getUUID() != null) {
            List list = this.getDataDictionary().getRoutineList(schemaDescriptor.getUUID().toString(), this.methodName, this.forCallStatement ? (char)'P' : 'F');
            for (int i = list.size() - 1; i >= 0; --i) {
                Object object;
                AliasDescriptor aliasDescriptor = (AliasDescriptor)list.get(i);
                RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                int n = routineAliasInfo.getParameterCount();
                if (n != this.methodParms.length) continue;
                TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
                int n2 = n;
                if (routineAliasInfo.getMaxDynamicResultSets() > 0) {
                    ++n2;
                }
                this.signature = new JSQLType[n2];
                for (int j = 0; j < n; ++j) {
                    Object object2;
                    Object object3;
                    Object object4;
                    TypeId typeId;
                    object = typeDescriptorArray[j];
                    TypeId typeId2 = typeId = TypeId.getTypeId((TypeDescriptor)object);
                    int n3 = routineAliasInfo.getParameterModes()[j];
                    if (n3 != 1) {
                        switch (typeId.getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 16: {
                                object4 = this.getTypeCompiler(typeId).getCorrespondingPrimitiveTypeName().concat("[]");
                                break;
                            }
                            default: {
                                object4 = typeId.getCorrespondingJavaTypeName().concat("[]");
                            }
                        }
                        typeId = TypeId.getUserDefinedTypeId((String)object4, false);
                    }
                    object4 = new DataTypeDescriptor(typeId, object.getPrecision(), object.getScale(), object.isNullable(), object.getMaximumWidth());
                    this.signature[j] = new JSQLType((DataTypeDescriptor)object4);
                    ValueNode valueNode = null;
                    if (this.methodParms[j] instanceof SQLToJavaValueNode) {
                        SQLToJavaValueNode sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[j];
                        valueNode = sQLToJavaValueNode.getSQLValueNode();
                    }
                    boolean bl = true;
                    if (valueNode == null || !valueNode.requiresTypeFromContext()) {
                        if (n3 != 1) {
                            throw StandardException.newException("42886", (Object)RoutineAliasInfo.parameterMode(n3), (Object)routineAliasInfo.getParameterNames()[j]);
                        }
                        bl = false;
                    } else {
                        if (this.applicationParameterNumbers == null) {
                            this.applicationParameterNumbers = new int[n];
                        }
                        if (valueNode instanceof UnaryOperatorNode) {
                            object3 = ((UnaryOperatorNode)valueNode).getParameterOperand();
                            this.applicationParameterNumbers[j] = ((ParameterNode)object3).getParameterNumber();
                        } else {
                            this.applicationParameterNumbers[j] = ((ParameterNode)valueNode).getParameterNumber();
                        }
                    }
                    object3 = new DataTypeDescriptor(typeId2, object.getPrecision(), object.getScale(), object.isNullable(), object.getMaximumWidth());
                    boolean bl2 = false;
                    if (!bl) {
                        if (valueNode instanceof UntypedNullConstantNode) {
                            valueNode.setType((DataTypeDescriptor)object3);
                        } else {
                            TypeId typeId3;
                            if (valueNode != null) {
                                typeId3 = valueNode.getTypeId();
                                object2 = valueNode.getTypeServices();
                            } else {
                                object2 = DataTypeDescriptor.getSQLDataTypeDescriptor(this.methodParms[j].getJavaTypeName());
                                if (object2 == null) {
                                    throw StandardException.newException("X0X57.S", this.methodParms[j].getJavaTypeName());
                                }
                                typeId3 = ((DataTypeDescriptor)object2).getTypeId();
                            }
                            if (!this.getTypeCompiler(typeId2).storable(typeId3, this.getClassFactory())) {
                                throw StandardException.newException("42821", (Object)typeId2.getSQLTypeName(), (Object)typeId3.getSQLTypeName());
                            }
                            if (!((DataTypeDescriptor)object3).isExactTypeAndLengthMatch((DataTypeDescriptor)object2)) {
                                bl2 = true;
                            }
                        }
                    } else if (typeId2.variableLength() && n3 != 4) {
                        bl2 = true;
                    }
                    if (bl2) {
                        if (valueNode == null) {
                            valueNode = (ValueNode)this.getNodeFactory().getNode(36, this.methodParms[j], this.getContextManager());
                        }
                        object2 = (ValueNode)this.getNodeFactory().getNode(60, valueNode, object3, this.getContextManager());
                        this.methodParms[j] = (JavaValueNode)this.getNodeFactory().getNode(28, object2, this.getContextManager());
                        this.methodParms[j] = this.methodParms[j].bindExpression(fromList, subqueryList, vector);
                    }
                    if (!bl) continue;
                    valueNode.setType((DataTypeDescriptor)object3);
                }
                if (n2 != n) {
                    TypeId typeId = TypeId.getUserDefinedTypeId("java.sql.ResultSet[]", false);
                    object = new DataTypeDescriptor(typeId, 0, 0, false, -1);
                    this.signature[n] = new JSQLType((DataTypeDescriptor)object);
                }
                this.routineInfo = routineAliasInfo;
                this.ad = aliasDescriptor;
                if (schemaDescriptor.isSystemSchema() && routineAliasInfo.getReturnType() == null && routineAliasInfo.getSQLAllowed() != 3) {
                    this.isSystemCode = true;
                }
                this.routineDefiner = schemaDescriptor.getAuthorizationId();
                break;
            }
        }
    }

    private void generateSetupNestedSessionContext(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, boolean bl, String string) throws StandardException {
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(bl);
        methodBuilder.push(string);
        methodBuilder.callMethod((short)185, null, "setupNestedSessionContext", "void", 3);
    }

    public void generateOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        Object object;
        Object object2;
        int n2;
        SQLToJavaValueNode sQLToJavaValueNode = null;
        if (this.methodParms[n] instanceof SQLToJavaValueNode) {
            sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[n];
        }
        if (this.routineInfo != null) {
            n2 = this.routineInfo.getParameterModes()[n];
        } else {
            n2 = 1;
            if (sQLToJavaValueNode != null && sQLToJavaValueNode.getSQLValueNode().requiresTypeFromContext()) {
                object2 = sQLToJavaValueNode.getSQLValueNode() instanceof UnaryOperatorNode ? ((UnaryOperatorNode)sQLToJavaValueNode.getSQLValueNode()).getParameterOperand() : (ParameterNode)sQLToJavaValueNode.getSQLValueNode();
                int n3 = ((ParameterNode)object2).getParameterNumber();
                object = this.methodParameterTypes[n];
                if (((String)object).endsWith("[]")) {
                    MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
                    expressionClassBuilder.pushThisAsActivation(methodBuilder2);
                    methodBuilder2.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                    methodBuilder2.push(n3);
                    methodBuilder2.push(0);
                    methodBuilder2.callMethod((short)185, null, "setParameterMode", "void", 2);
                    methodBuilder2.endStatement();
                }
            }
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                if (sQLToJavaValueNode != null) {
                    sQLToJavaValueNode.returnsNullOnNullState = this.returnsNullOnNullState;
                }
                super.generateOneParameter(expressionClassBuilder, methodBuilder, n);
                break;
            }
        }
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                object2 = this.methodParameterTypes[n];
                String string = ((String)object2).substring(0, ((String)object2).length() - 2);
                object = expressionClassBuilder.newFieldDeclaration(2, (String)object2);
                if (this.outParamArrays == null) {
                    this.outParamArrays = new LocalField[this.methodParms.length];
                }
                this.outParamArrays[n] = object;
                methodBuilder.pushNewArray(string, 1);
                methodBuilder.putField((LocalField)object);
                if (n2 == 4) break;
                methodBuilder.swap();
                methodBuilder.setArrayElement(0);
                methodBuilder.getField((LocalField)object);
                break;
            }
        }
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        bl2 = bl2 && super.categorize(jBitSet, bl);
        return bl2;
    }

    public String toString() {
        return "";
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        Object object;
        int n2;
        int n3;
        if (this.routineInfo != null && !this.routineInfo.calledOnNullInput() && this.routineInfo.getParameterCount() != 0) {
            this.returnsNullOnNullState = expressionClassBuilder.newFieldDeclaration(2, "boolean");
        }
        if (this.returnsNullOnNullState != null) {
            methodBuilder.push(false);
            methodBuilder.setField(this.returnsNullOnNullState);
            methodBuilder.pushThis();
        }
        int n4 = this.generateParameters(expressionClassBuilder, methodBuilder);
        LocalField localField = null;
        if (this.routineInfo != null) {
            boolean bl;
            n3 = this.routineInfo.getSQLAllowed();
            if (n3 != 3) {
                n2 = n3 == 1 ? 1 : (n3 == 0 ? 0 : 2);
                this.generateAuthorizeCheck((ActivationClassBuilder)expressionClassBuilder, methodBuilder, n2);
            }
            n2 = this.isSystemCode ? 2 : 1;
            boolean bl2 = bl = this.routineInfo.getReturnType() != null;
            if (bl) {
                ++n2;
            }
            if (n2 != 0) {
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
                methodBuilder.callMethod((short)185, null, "getStatementContext", "org.apache.derby.iapi.sql.conn.StatementContext", 0);
                for (int i = 1; i < n2; ++i) {
                    methodBuilder.dup();
                }
            }
            if (this.isSystemCode) {
                methodBuilder.callMethod((short)185, null, "setSystemCode", "void", 0);
            }
            if (n3 != 3) {
                this.generateSetupNestedSessionContext((ActivationClassBuilder)expressionClassBuilder, methodBuilder, this.routineInfo.hasDefinersRights(), this.routineDefiner);
            }
            if (bl) {
                localField = expressionClassBuilder.newFieldDeclaration(2, "short");
                methodBuilder.callMethod((short)185, null, "getSQLAllowed", "short", 0);
                methodBuilder.setField(localField);
            }
            methodBuilder.push((short)n3);
            methodBuilder.push(false);
            methodBuilder.callMethod((short)185, null, "setSQLAllowed", "void", 2);
        }
        if (this.routineInfo != null && (n3 = this.methodParameterTypes.length - this.methodParms.length) != 0) {
            n2 = this.routineInfo.getMaxDynamicResultSets();
            if (n2 > 0) {
                MethodBuilder methodBuilder2 = expressionClassBuilder.getClassBuilder().newMethodBuilder(1, "int", "getMaxDynamicResults");
                methodBuilder2.push(n2);
                methodBuilder2.methodReturn();
                methodBuilder2.complete();
            }
            MethodBuilder methodBuilder3 = expressionClassBuilder.getClassBuilder().newMethodBuilder(1, "java.sql.ResultSet[][]", "getDynamicResults");
            MethodBuilder methodBuilder4 = expressionClassBuilder.getConstructor();
            object = expressionClassBuilder.newFieldDeclaration(2, "java.sql.ResultSet[][]");
            methodBuilder3.getField((LocalField)object);
            methodBuilder4.pushNewArray("java.sql.ResultSet[]", n3);
            methodBuilder4.setField((LocalField)object);
            for (n = 0; n < n3; ++n) {
                methodBuilder.pushNewArray("java.sql.ResultSet", 1);
                methodBuilder.dup();
                methodBuilder.getField((LocalField)object);
                methodBuilder.swap();
                methodBuilder.setArrayElement(n);
            }
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            n4 += n3;
        }
        String string = this.getJavaTypeName();
        MethodBuilder methodBuilder5 = null;
        MethodBuilder methodBuilder6 = methodBuilder;
        if (this.returnsNullOnNullState != null) {
            int n5;
            methodBuilder5 = expressionClassBuilder.newGeneratedFun(string, 2, this.methodParameterTypes);
            Class<?>[] classArray = ((Method)this.method).getExceptionTypes();
            for (n5 = 0; n5 < classArray.length; ++n5) {
                methodBuilder5.addThrownException(classArray[n5].getName());
            }
            methodBuilder5.getField(this.returnsNullOnNullState);
            methodBuilder5.conditionalIf();
            methodBuilder5.pushNull(string);
            methodBuilder5.startElseCode();
            if (!this.actualMethodReturnType.equals(string)) {
                methodBuilder5.pushNewStart(string);
            }
            for (n5 = 0; n5 < n4; ++n5) {
                methodBuilder5.getParameter(n5);
            }
            methodBuilder6 = methodBuilder5;
        }
        methodBuilder6.callMethod((short)184, this.method.getDeclaringClass().getName(), this.methodName, this.actualMethodReturnType, n4);
        if (this.returnsNullOnNullState != null) {
            if (!this.actualMethodReturnType.equals(string)) {
                if (this.actualMethodReturnType.equals("short") && string.equals("java.lang.Integer")) {
                    methodBuilder5.upCast("int");
                }
                methodBuilder5.pushNewComplete(1);
            }
            methodBuilder5.completeConditional();
            methodBuilder5.methodReturn();
            methodBuilder5.complete();
            methodBuilder.callMethod((short)182, expressionClassBuilder.getClassBuilder().getFullName(), methodBuilder5.getName(), string, n4);
            methodBuilder5 = null;
        }
        if (this.routineInfo != null) {
            if (localField != null) {
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
                methodBuilder.callMethod((short)185, null, "getStatementContext", "org.apache.derby.iapi.sql.conn.StatementContext", 0);
                methodBuilder.getField(localField);
                methodBuilder.push(true);
                methodBuilder.callMethod((short)185, null, "setSQLAllowed", "void", 2);
            }
            if (this.outParamArrays != null) {
                MethodBuilder methodBuilder7 = expressionClassBuilder.getConstructor();
                expressionClassBuilder.pushThisAsActivation(methodBuilder7);
                methodBuilder7.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                object = this.routineInfo.getParameterModes();
                for (n = 0; n < this.outParamArrays.length; ++n) {
                    Object object2 = object[n];
                    if (object2 == true) continue;
                    ValueNode valueNode = ((SQLToJavaValueNode)this.methodParms[n]).getSQLValueNode();
                    int n6 = this.applicationParameterNumbers[n];
                    methodBuilder7.dup();
                    methodBuilder7.push(n6);
                    methodBuilder7.push((int)object2);
                    methodBuilder7.callMethod((short)185, null, "setParameterMode", "void", 2);
                    LocalField localField2 = this.outParamArrays[n];
                    methodBuilder.dup();
                    methodBuilder.push(n6);
                    methodBuilder.callMethod((short)185, null, "getParameter", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                    DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
                    boolean bl = dataTypeDescriptor.getTypeId().isNumericTypeId();
                    boolean bl3 = dataTypeDescriptor.getTypeId().getBaseTypeId().isAnsiUDT();
                    boolean bl4 = ((Method)this.method).getParameterTypes()[n].getComponentType().isPrimitive();
                    if (bl) {
                        if (!bl4) {
                            methodBuilder.cast("org.apache.derby.iapi.types.NumberDataValue");
                        }
                    } else if (dataTypeDescriptor.getTypeId().isBooleanTypeId() && !bl4) {
                        methodBuilder.cast("org.apache.derby.iapi.types.BooleanDataValue");
                    }
                    if (dataTypeDescriptor.getTypeId().variableLength()) {
                        methodBuilder.dup();
                    }
                    methodBuilder.getField(localField2);
                    methodBuilder.getArrayElement(0);
                    if (bl && !bl4) {
                        methodBuilder.upCast("java.lang.Number");
                    }
                    if (bl3) {
                        methodBuilder.upCast("java.lang.Object");
                    }
                    methodBuilder.callMethod((short)185, null, "setValue", "void", 1);
                    if (!dataTypeDescriptor.getTypeId().variableLength()) continue;
                    methodBuilder.push(bl ? dataTypeDescriptor.getPrecision() : dataTypeDescriptor.getMaximumWidth());
                    methodBuilder.push(dataTypeDescriptor.getScale());
                    methodBuilder.push(bl);
                    methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
                }
                methodBuilder7.endStatement();
                methodBuilder.endStatement();
            }
        }
    }

    int getPrivType() {
        return 6;
    }
}

