/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.util.Collection;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.TransactionType;

public class CheckUserTransactionRefs
extends ValidationBase {
    @Override
    public void validate(EjbModule ejbModule) {
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            if (bean.getTransactionType() != TransactionType.CONTAINER) continue;
            Collection resRefs = bean.getResourceEnvRef();
            for (ResourceEnvRef resRef : resRefs) {
                if (!"javax.transaction.UserTransaction".equals(resRef.getResourceEnvRefType())) continue;
                this.fail(bean, "userTransactionRef.forbiddenForCmtdBeans", resRef.getName());
            }
        }
    }
}

