/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.openejb.util.Computable;

public class Memoizer<K, V>
implements Computable<K, V> {
    private final ConcurrentMap<K, Future<V>> cache = new ConcurrentHashMap<K, Future<V>>();
    private final Computable<K, V> c;

    public Memoizer(Computable<K, V> c) {
        if (c == null) {
            throw new NullPointerException("Computable cache value source algorithm may not be null");
        }
        this.c = c;
    }

    @Override
    public V compute(final K key) throws InterruptedException {
        while (true) {
            Callable eval;
            FutureTask futureTask;
            FutureTask future;
            if ((future = (FutureTask)this.cache.get(key)) == null && (future = (Future)this.cache.putIfAbsent(key, futureTask = new FutureTask(eval = new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return Memoizer.this.c.compute(key);
                }
            }))) == null) {
                future = futureTask;
                futureTask.run();
            }
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

