/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLValidator;

public class ValidateWSDLJob
extends Job {
    public static final String VALIDATE_WSDL_JOB_FAMILY = "ValidateWSDLJobJamily";
    private String wsdlURI_ = null;
    private IValidationMessage[] validationMessages_ = null;
    private int validationMessageSeverity_ = -1;

    public ValidateWSDLJob(String wsdlURI) {
        super("ValidateWSDLJob");
        this.wsdlURI_ = wsdlURI;
    }

    protected IStatus run(IProgressMonitor monitor) {
        WSDLValidator wsdlValidator = WSDLValidator.getInstance();
        IValidationReport valReport = wsdlValidator.validate(this.wsdlURI_);
        this.validationMessages_ = valReport.getValidationMessages();
        this.reportSummary();
        return Status.OK_STATUS;
    }

    private void reportSummary() {
        int errorCount = 0;
        int warningCount = 0;
        int i = 0;
        while (i < this.validationMessages_.length && errorCount == 0) {
            int severity = this.validationMessages_[i].getSeverity();
            switch (severity) {
                case 0: {
                    ++errorCount;
                    break;
                }
                case 1: {
                    ++warningCount;
                    break;
                }
            }
            ++i;
        }
        if (errorCount > 0) {
            this.validationMessageSeverity_ = 0;
        } else if (warningCount > 0) {
            this.validationMessageSeverity_ = 1;
        }
    }

    public boolean belongsTo(Object family) {
        return family == VALIDATE_WSDL_JOB_FAMILY;
    }

    public IValidationMessage[] getValidationMessages() {
        return this.validationMessages_;
    }

    public int getValidationMessageSeverity() {
        return this.validationMessageSeverity_;
    }

    public String getWsdlURI() {
        return this.wsdlURI_;
    }
}

