/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import org.eclipse.wst.jsdt.core.ast.ASTVisitor;
import org.eclipse.wst.jsdt.core.ast.IASTNode;
import org.eclipse.wst.jsdt.core.ast.IAbstractFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.wst.jsdt.core.ast.IAllocationExpression;
import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFalseLiteral;
import org.eclipse.wst.jsdt.core.ast.IFieldReference;
import org.eclipse.wst.jsdt.core.ast.IFunctionCall;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IFunctionExpression;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.ast.ILocalDeclaration;
import org.eclipse.wst.jsdt.core.ast.INumberLiteral;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteral;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteralField;
import org.eclipse.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.wst.jsdt.core.ast.IReturnStatement;
import org.eclipse.wst.jsdt.core.ast.IScriptFileDeclaration;
import org.eclipse.wst.jsdt.core.ast.ISingleNameReference;
import org.eclipse.wst.jsdt.core.ast.IStringLiteral;
import org.eclipse.wst.jsdt.core.ast.IThisReference;
import org.eclipse.wst.jsdt.core.ast.ITrueLiteral;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.IInferEngine;
import org.eclipse.wst.jsdt.core.infer.InferOptions;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMember;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class InferEngine
extends ASTVisitor
implements IInferEngine {
    InferOptions inferOptions;
    CompilationUnitDeclaration compUnit;
    Context[] contexts = new Context[100];
    int contextPtr = -1;
    Context currentContext = new Context();
    protected int passNumber = 1;
    boolean isTopLevelAnonymousFunction;
    int anonymousCount = 0;
    public InferrenceProvider inferenceProvider;
    public InferredType StringType = new InferredType(new char[]{'S', 't', 'r', 'i', 'n', 'g'});
    public InferredType NumberType = new InferredType(new char[]{'N', 'u', 'm', 'b', 'e', 'r'});
    public InferredType BooleanType = new InferredType(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'});
    public InferredType FunctionType = new InferredType(InferredType.FUNCTION_NAME);
    public InferredType ArrayType = new InferredType(InferredType.ARRAY_NAME);
    public InferredType VoidType = new InferredType(new char[]{'v', 'o', 'i', 'd'});
    public InferredType ObjectType = new InferredType(InferredType.OBJECT_NAME);
    public InferredType GlobalType = new InferredType(InferredType.GLOBAL_NAME);
    public static HashtableOfObject WellKnownTypes = new HashtableOfObject();
    protected InferredType inferredGlobal;
    static final char[] CONSTRUCTOR_ID = new char[]{'c', 'o', 'n', 's', 't', 'r', 'u', 'c', 't', 'o', 'r'};
    private static boolean REPORT_INFER_TIME = false;

    public InferEngine(InferOptions inferOptions) {
        WellKnownTypes.put(InferredType.OBJECT_NAME, null);
        WellKnownTypes.put(InferredType.ARRAY_NAME, null);
        WellKnownTypes.put(new char[]{'S', 't', 'r', 'i', 'n', 'g'}, null);
        WellKnownTypes.put(new char[]{'N', 'u', 'm', 'b', 'e', 'r'}, null);
        WellKnownTypes.put(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'}, null);
        WellKnownTypes.put(InferredType.FUNCTION_NAME, null);
        WellKnownTypes.put(new char[]{'D', 'a', 't', 'e'}, null);
        WellKnownTypes.put(new char[]{'M', 'a', 't', 'h'}, null);
        WellKnownTypes.put(new char[]{'R', 'e', 'g', 'E', 'x', 'p'}, null);
        WellKnownTypes.put(new char[]{'E', 'r', 'r', 'o', 'r'}, null);
        this.inferredGlobal = null;
        this.inferOptions = inferOptions;
    }

    public InferEngine() {
        WellKnownTypes.put(InferredType.OBJECT_NAME, null);
        WellKnownTypes.put(InferredType.ARRAY_NAME, null);
        WellKnownTypes.put(new char[]{'S', 't', 'r', 'i', 'n', 'g'}, null);
        WellKnownTypes.put(new char[]{'N', 'u', 'm', 'b', 'e', 'r'}, null);
        WellKnownTypes.put(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'}, null);
        WellKnownTypes.put(InferredType.FUNCTION_NAME, null);
        WellKnownTypes.put(new char[]{'D', 'a', 't', 'e'}, null);
        WellKnownTypes.put(new char[]{'M', 'a', 't', 'h'}, null);
        WellKnownTypes.put(new char[]{'R', 'e', 'g', 'E', 'x', 'p'}, null);
        WellKnownTypes.put(new char[]{'E', 'r', 'r', 'o', 'r'}, null);
        this.inferredGlobal = null;
        this.inferOptions = new InferOptions();
    }

    public void initialize() {
        this.contextPtr = -1;
        this.currentContext = new Context();
        this.passNumber = 1;
        this.isTopLevelAnonymousFunction = false;
        this.anonymousCount = 0;
        this.inferredGlobal = null;
    }

    public void setCompilationUnit(CompilationUnitDeclaration scriptFileDeclaration) {
        this.compUnit = scriptFileDeclaration;
        this.buildDefinedMembers(scriptFileDeclaration.getStatements(), null);
    }

    public boolean visit(IFunctionCall functionCall) {
        boolean visitChildren = this.handleFunctionCall(functionCall);
        if (visitChildren && this.contextPtr == -1 && functionCall.getReceiver() instanceof FunctionExpression) {
            this.isTopLevelAnonymousFunction = true;
        }
        return visitChildren;
    }

    public boolean visit(ILocalDeclaration localDeclaration) {
        boolean keepVisiting;
        this.currentContext.addMember(localDeclaration.getName(), localDeclaration);
        this.pushContext();
        this.currentContext.currentLocalDeclaration = localDeclaration;
        if (localDeclaration.getJsDoc() != null) {
            InferredType type;
            Javadoc javadoc = (Javadoc)localDeclaration.getJsDoc();
            this.createTypeIfNecessary(javadoc);
            InferredAttribute attribute = null;
            if (javadoc.memberOf != null) {
                type = this.addType(javadoc.memberOf.getFullTypeName(), true);
                int nameStart = localDeclaration.sourceStart();
                attribute = type.addAttribute(localDeclaration.getName(), localDeclaration, nameStart);
                this.handleAttributeDeclaration(attribute, localDeclaration.getInitialization());
                if (localDeclaration.getInitialization() != null) {
                    attribute.initializationStart = localDeclaration.getInitialization().sourceStart();
                }
                attribute.type = type;
            }
            if (javadoc.returnType != null) {
                type = this.addType(javadoc.returnType.getFullTypeName());
                localDeclaration.setInferredType(type);
                if (attribute != null) {
                    attribute.type = type;
                }
            }
        }
        if (localDeclaration.getInitialization() instanceof IFunctionExpression && !(keepVisiting = this.handleFunctionExpressionLocalDeclaration(localDeclaration))) {
            return false;
        }
        if (localDeclaration.getInferredType() == null && localDeclaration.getInitialization() != null) {
            if (localDeclaration.getInitialization() instanceof MessageSend) {
                this.handleFunctionCall((IFunctionCall)localDeclaration.getInitialization(), (LocalDeclaration)localDeclaration);
            } else {
                localDeclaration.setInferredType(this.getTypeOf(localDeclaration.getInitialization()));
            }
        }
        return true;
    }

    public void endVisit(ILocalDeclaration localDeclaration) {
        this.popContext();
    }

    private void createTypeIfNecessary(Javadoc javadoc) {
        if (javadoc.memberOf != null) {
            Object namespace = new char[][]{};
            char[][] typeName = javadoc.memberOf.getTypeName();
            if (javadoc.namespace != null) {
                namespace = javadoc.namespace.getTypeName();
            }
            char[] name = CharOperation.concat(CharOperation.concatWith(namespace, '.'), CharOperation.concatWith(typeName, '.'), '.');
            this.currentContext.currentType = this.addType(name);
            if (javadoc.extendsType != null) {
                char[] superName = CharOperation.concatWith(javadoc.extendsType.getTypeName(), '.');
                this.currentContext.currentType.superClass = this.addType(superName);
            }
            this.currentContext.isJsDocClass = true;
        }
    }

    public boolean visit(IAssignment assignment) {
        this.pushContext();
        this.currentContext.currentAssignment = assignment;
        IExpression assignmentExpression = assignment.getExpression();
        if (!this.handlePotentialType(assignment)) {
            if (assignmentExpression instanceof FunctionExpression) {
                boolean keepVisiting = this.handleFunctionExpressionAssignment(assignment);
                if (!keepVisiting) {
                    return false;
                }
            } else if (assignmentExpression instanceof SingleNameReference && this.currentContext.currentType != null && InferEngine.isThis(assignment.getLeftHandSide())) {
                ISingleNameReference snr = (ISingleNameReference)assignmentExpression;
                Object object = this.currentContext.getMember(snr.getToken());
                IFieldReference fieldReference = (IFieldReference)assignment.getLeftHandSide();
                char[] memberName = fieldReference.getToken();
                InferredMember member = null;
                int nameStart = fieldReference.sourceEnd() - memberName.length + 1;
                if (object instanceof MethodDeclaration) {
                    MethodDeclaration method = (MethodDeclaration)object;
                    member = this.currentContext.currentType.addMethod(memberName, method, nameStart);
                } else {
                    member = this.currentContext.currentType.addAttribute(memberName, assignment, nameStart);
                    this.handleAttributeDeclaration((InferredAttribute)member, assignment.getExpression());
                    if (member.type == null) {
                        member.type = this.getTypeOf(assignmentExpression);
                    }
                }
                if (member != null) {
                    member.isStatic = false;
                }
            } else if (assignmentExpression instanceof IObjectLiteral && assignment.getLeftHandSide() instanceof ISingleNameReference) {
                IAssignment existing;
                IAbstractVariableDeclaration varDecl = this.getVariable(assignment.getLeftHandSide());
                if (varDecl == null && (existing = this.getAssignment(assignment.getLeftHandSide())) == null) {
                    this.currentContext.parent.addMember(this.getName(assignment.getLeftHandSide()), assignment);
                }
                if (varDecl != null) {
                    InferredType type = varDecl.getInferredType();
                    if (type == null) {
                        type = this.getTypeOf(assignmentExpression);
                        varDecl.setInferredType(type);
                        return true;
                    }
                    return false;
                }
                IAssignment assignmentDecl = this.getAssignment(assignment.getLeftHandSide());
                if (assignmentDecl != null) {
                    InferredType type = assignmentDecl.getInferredType();
                    if (type == null) {
                        type = this.getTypeOf(assignmentExpression);
                        assignmentDecl.setInferredType(type);
                        return true;
                    }
                    return false;
                }
            } else if (assignmentExpression instanceof IObjectLiteral && assignment.getLeftHandSide() instanceof FieldReference) {
                boolean isKnownName;
                FieldReference fRef = (FieldReference)assignment.getLeftHandSide();
                boolean bl = isKnownName = fRef.receiver.isThis() && this.isKnownType(fRef.getToken()) && this.inferredGlobal != null && this.inferredGlobal == this.currentContext.currentType;
                if (isKnownName || this.inferOptions.useAssignments && this.passNumber == 2) {
                    InferredAttribute attr;
                    InferredType receiverType = this.getInferredType(fRef.receiver);
                    if (receiverType == null && this.passNumber == 2) {
                        receiverType = this.getInferredType2(fRef.receiver);
                    }
                    if (receiverType != null && ((attr = receiverType.findAttribute(fRef.getToken())) == null || attr.type == null)) {
                        int nameStart = (int)(fRef.nameSourcePosition >>> 32);
                        attr = receiverType.addAttribute(fRef.getToken(), assignment, nameStart);
                        this.handleAttributeDeclaration(attr, assignment.getExpression());
                        attr.type = this.getTypeOf(assignmentExpression);
                        if (isKnownName && attr.type.isAnonymous) {
                            InferredType existingType = this.compUnit.findInferredType(fRef.getToken());
                            if (existingType != null) {
                                attr.type = existingType;
                            } else {
                                this.compUnit.inferredTypesHash.removeKey(attr.type.name);
                                attr.type.name = fRef.getToken();
                                this.compUnit.inferredTypesHash.put(attr.type.name, attr.type);
                            }
                        }
                        char[] possibleTypeName = this.constructTypeName(fRef.receiver);
                        attr.isStatic = receiverType.allStatic || possibleTypeName != null && this.compUnit.findInferredType(possibleTypeName) != null;
                        return false;
                    }
                }
            } else if (assignmentExpression instanceof AllocationExpression && ((AllocationExpression)assignmentExpression).member instanceof FunctionExpression) {
                this.handleFunctionExpressionAssignment((Assignment)assignment);
            } else if (assignmentExpression instanceof Assignment && ((Assignment)assignmentExpression).expression instanceof FunctionExpression) {
                this.handleFunctionExpressionAssignment((Assignment)assignment);
            } else if (this.inferOptions.useAssignments && (assignment.getLeftHandSide() instanceof FieldReference || assignment.getLeftHandSide() instanceof ArrayReference)) {
                char[] typeName;
                IFunctionDeclaration function;
                Reference ref = (Reference)assignment.getLeftHandSide();
                Expression receiver = null;
                char[] attName = null;
                int nameStart = 0;
                if (ref instanceof FieldReference) {
                    receiver = ((FieldReference)ref).receiver;
                    attName = ((FieldReference)ref).token;
                    nameStart = (int)(((FieldReference)ref).nameSourcePosition >>> 32);
                } else if (ref instanceof ArrayReference && ((ArrayReference)ref).position instanceof StringLiteral) {
                    receiver = ((ArrayReference)ref).receiver;
                    attName = ((StringLiteral)((ArrayReference)ref).position).source();
                    nameStart = ((StringLiteral)((ArrayReference)ref).position).sourceStart + 1;
                }
                InferredType receiverType = this.getInferredType(receiver);
                if (receiverType == null && (function = this.getDefinedFunction(receiver)) != null && (typeName = this.constructTypeName(receiver)) != null) {
                    receiverType = this.addType(typeName);
                }
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getInferredType2(receiver);
                }
                if (receiverType != null && attName != null) {
                    InferredMethod method = null;
                    InferredAttribute attr = receiverType.findAttribute(attName);
                    if (attr == null) {
                        method = receiverType.findMethod(attName, null);
                    }
                    if (method == null && attr == null || method == null && attr != null && attr.type == null) {
                        IFunctionDeclaration definedFunction = null;
                        InferredType exprType = this.getTypeOf(assignmentExpression);
                        if (exprType == null) {
                            definedFunction = this.getDefinedFunction(assignmentExpression);
                        }
                        if (definedFunction != null) {
                            method = receiverType.addMethod(attName, definedFunction, nameStart);
                            method.isStatic = receiverType.allStatic;
                        } else {
                            int nameStart_ = nameStart;
                            attr = receiverType.addAttribute(attName, assignment, nameStart_);
                            this.handleAttributeDeclaration(attr, assignmentExpression);
                            attr.type = exprType;
                            char[] possibleTypeName = this.constructTypeName(receiver);
                            attr.isStatic = receiverType.allStatic || possibleTypeName != null && this.compUnit.findInferredType(possibleTypeName) != null;
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected InferredType getInferredType2(IExpression fieldReceiver) {
        char[] name;
        InferredAttribute attr;
        InferredType receiverType = null;
        IAbstractVariableDeclaration var = this.getVariable(fieldReceiver);
        if (var != null) {
            receiverType = this.createAnonymousType(var);
        } else if (this.inferredGlobal != null && fieldReceiver instanceof ISingleNameReference && (attr = this.inferredGlobal.findAttribute(name = ((ISingleNameReference)fieldReceiver).getToken())) != null) {
            receiverType = attr.type;
        }
        return receiverType;
    }

    private InferredType createAnonymousType(IAbstractVariableDeclaration var) {
        InferredType currentType = var.getInferredType();
        if (currentType == null || !currentType.isAnonymous) {
            InferredType type = this.createAnonymousType(var.getName(), currentType);
            var.setInferredType(type);
        }
        return var.getInferredType();
    }

    private InferredType createAnonymousType(IAssignment assignment) {
        InferredType currentType = assignment.getInferredType();
        if (currentType == null || !currentType.isAnonymous) {
            InferredType type = this.createAnonymousType(this.getName(assignment.getLeftHandSide()), currentType);
            assignment.setInferredType(type);
        }
        return assignment.getInferredType();
    }

    protected InferredType createAnonymousType(char[] possibleTypeName, InferredType currentType) {
        char[] name;
        if (this.isKnownType(possibleTypeName)) {
            name = possibleTypeName;
        } else {
            char[] cs = String.valueOf(this.anonymousCount++).toCharArray();
            name = CharOperation.concat(ANONYMOUS_PREFIX, possibleTypeName, cs);
        }
        InferredType type = this.addType(name, true);
        type.isAnonymous = true;
        if (currentType != null) {
            type.superClass = currentType;
        }
        return type;
    }

    private InferredType createAnonymousType(IObjectLiteral objLit) {
        if (objLit.getInferredType() != null) {
            return objLit.getInferredType();
        }
        char[] name = InferEngine.createAnonymousTypeName(objLit);
        InferredType anonType = this.addType(name, true);
        anonType.isAnonymous = true;
        anonType.isObjectLiteral = true;
        anonType.superClass = this.ObjectType;
        anonType.sourceStart = objLit.sourceStart();
        anonType.sourceEnd = objLit.sourceEnd();
        this.populateType(anonType, objLit, false);
        return anonType;
    }

    protected static char[] createAnonymousTypeName(IASTNode node) {
        char[] loc = (String.valueOf(String.valueOf(node.sourceStart())) + '_' + String.valueOf(node.sourceEnd())).toCharArray();
        return CharOperation.concat(ANONYMOUS_PREFIX, ANONYMOUS_CLASS_ID, loc);
    }

    protected boolean handleFunctionExpressionAssignment(IAssignment assignment) {
        IFunctionExpression functionExpression = null;
        if (assignment.getExpression() instanceof IFunctionExpression) {
            functionExpression = (IFunctionExpression)assignment.getExpression();
        } else if (assignment.getExpression() instanceof IAllocationExpression) {
            functionExpression = (IFunctionExpression)((IAllocationExpression)((Object)assignment.getExpression())).getMember();
        } else if (assignment.getExpression() instanceof IAssignment) {
            functionExpression = (FunctionExpression)((IAssignment)assignment.getExpression()).getExpression();
        }
        MethodDeclaration methodDeclaration = functionExpression.getMethodDeclaration();
        char[] possibleTypeName = this.constructTypeName(assignment.getLeftHandSide());
        InferredType type = null;
        if (possibleTypeName != null) {
            type = this.compUnit.findInferredType(possibleTypeName);
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null && methodDeclaration.getJsDoc() != null && ((Javadoc)methodDeclaration.getJsDoc()).isConstructor) {
                type = this.addType(possibleTypeName, true);
                this.handleJSDocConstructor(type, methodDeclaration, assignment.sourceStart());
            }
        }
        if (type != null) {
            if (this.inferOptions.useInitMethod) {
                this.currentContext.currentType = type;
                type.isDefinition = true;
                int nameStart = assignment.getLeftHandSide().sourceStart();
                type.addConstructorMethod(type.name, methodDeclaration, nameStart);
                type.updatePositions(assignment.getLeftHandSide().sourceStart(), assignment.getExpression().sourceEnd());
            }
        } else if (assignment.getLeftHandSide() instanceof FieldReference || assignment.getLeftHandSide() instanceof ArrayReference) {
            Reference ref = (Reference)assignment.getLeftHandSide();
            Expression receiver = null;
            char[] methodName = null;
            int nameStart = 0;
            if (ref instanceof FieldReference) {
                receiver = ((FieldReference)ref).receiver;
                methodName = ((FieldReference)ref).token;
                nameStart = (int)(((FieldReference)ref).nameSourcePosition >>> 32);
            } else if (ref instanceof ArrayReference && ((ArrayReference)ref).position instanceof StringLiteral) {
                receiver = ((ArrayReference)ref).receiver;
                methodName = ((StringLiteral)((ArrayReference)ref).position).source();
                nameStart = ((StringLiteral)((ArrayReference)ref).position).sourceStart + 1;
            }
            InferredType receiverType = this.getInferredType(receiver);
            if (receiverType != null && methodName != null) {
                InferredMethod method = receiverType.findMethod(methodName, methodDeclaration);
                if (method == null) {
                    method = receiverType.addMethod(methodName, methodDeclaration, nameStart);
                    receiverType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                    receiverType.isDefinition = true;
                    char[] possibleInTypeName = this.constructTypeName(receiver);
                    method.isStatic = receiverType.allStatic || possibleInTypeName != null && this.compUnit.findInferredType(possibleInTypeName) != null;
                    return true;
                }
                return false;
            }
            if (this.passNumber == 2 && methodName != null && (receiverType = this.getInferredType2(receiver)) != null) {
                InferredMethod method = receiverType.addMethod(methodName, methodDeclaration, nameStart);
                method.isStatic = receiverType.isAnonymous;
                receiverType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
            }
        } else if (assignment.getLeftHandSide() instanceof SingleNameReference && methodDeclaration.selector == null) {
            methodDeclaration.potentialName = ((SingleNameReference)assignment.getLeftHandSide()).token;
        }
        return true;
    }

    private boolean handleFunctionExpressionLocalDeclaration(ILocalDeclaration localDeclaration) {
        boolean keepVisiting = true;
        IFunctionExpression functionExpression = null;
        IExpression expression = localDeclaration.getInitialization();
        if (expression instanceof IFunctionExpression) {
            functionExpression = (IFunctionExpression)expression;
        } else if (expression instanceof IAllocationExpression) {
            functionExpression = (IFunctionExpression)((IAllocationExpression)((Object)expression)).getMember();
        } else if (expression instanceof IAssignment) {
            functionExpression = (FunctionExpression)((IAssignment)expression).getExpression();
        }
        MethodDeclaration methodDeclaration = functionExpression.getMethodDeclaration();
        char[] possibleTypeName = localDeclaration.getName();
        InferredType type = null;
        if (possibleTypeName != null) {
            type = this.compUnit.findInferredType(possibleTypeName);
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null && methodDeclaration.getJsDoc() != null && ((Javadoc)methodDeclaration.getJsDoc()).isConstructor) {
                type = this.addType(possibleTypeName, true);
                this.handleJSDocConstructor(type, methodDeclaration, localDeclaration.sourceStart());
            }
        }
        if (type != null) {
            if (this.inferOptions.useInitMethod) {
                this.currentContext.currentType = type;
                type.isDefinition = true;
                int nameStart = localDeclaration.sourceStart();
                type.addConstructorMethod(type.name, methodDeclaration, nameStart);
                type.updatePositions(localDeclaration.sourceStart(), localDeclaration.getInitialization().sourceEnd());
            }
            keepVisiting = false;
        }
        return keepVisiting;
    }

    protected boolean handlePotentialType(IAssignment assignment) {
        IExpression lhs = assignment.getLeftHandSide();
        if (lhs instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)lhs;
            if (fieldReference.isPrototype()) {
                InferredType newType = null;
                char[] possibleTypeName = this.constructTypeName(fieldReference.getReceiver());
                if (possibleTypeName == null) {
                    return true;
                }
                newType = this.compUnit.findInferredType(possibleTypeName);
                if (newType == null) {
                    newType = this.addType(possibleTypeName, true);
                }
                newType.isDefinition = true;
                newType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                if (assignment.getExpression() instanceof IAllocationExpression) {
                    IAllocationExpression allocationExpression = (IAllocationExpression)((Object)assignment.getExpression());
                    InferredType superType = null;
                    char[] possibleSuperTypeName = this.constructTypeName(allocationExpression.getMember());
                    if (possibleSuperTypeName != null) {
                        superType = this.compUnit.findInferredType(possibleSuperTypeName);
                        if (superType == null) {
                            superType = this.addType(possibleSuperTypeName);
                        }
                        if (newType.superClass == null) {
                            newType.superClass = superType;
                        }
                    }
                    return true;
                }
                if (assignment.getExpression() instanceof IObjectLiteral) {
                    this.populateType(newType, (IObjectLiteral)assignment.getExpression(), false);
                    if (newType.superClass == null) {
                        newType.superClass = this.ObjectType;
                    }
                    return true;
                }
            } else {
                if (fieldReference.receiver.isPrototype()) {
                    FieldReference prototype = (FieldReference)fieldReference.receiver;
                    InferredType newType = null;
                    char[] possibleTypeName = this.constructTypeName(prototype.receiver);
                    if (possibleTypeName == null) {
                        return true;
                    }
                    newType = this.compUnit.findInferredType(possibleTypeName);
                    if (newType == null) {
                        newType = this.addType(possibleTypeName);
                    }
                    newType.isDefinition = true;
                    newType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                    if (this.passNumber == 1 && assignment.getExpression() instanceof IObjectLiteral) {
                        return false;
                    }
                    char[] memberName = fieldReference.token;
                    int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                    InferredType typeOf = assignment.getJsDoc() != null && assignment.getJsDoc() instanceof Javadoc && ((Javadoc)assignment.getJsDoc()).returnType != null ? this.addType(this.changePrimitiveToObject(((Javadoc)assignment.getJsDoc()).returnType.getFullTypeName())) : this.getTypeOf(assignment.getExpression());
                    IFunctionDeclaration methodDecl = null;
                    if (typeOf == null || typeOf == this.FunctionType) {
                        methodDecl = this.getDefinedFunction(assignment.getExpression());
                    }
                    if (methodDecl != null) {
                        newType.addMethod(memberName, methodDecl, nameStart);
                    } else {
                        InferredAttribute attribute = newType.addAttribute(memberName, assignment, nameStart);
                        this.handleAttributeDeclaration(attribute, assignment.getExpression());
                        attribute.initializationStart = assignment.getExpression().sourceStart();
                        if (attribute.type == null) {
                            attribute.type = typeOf;
                        }
                    }
                    return true;
                }
                if (fieldReference.receiver instanceof IThisReference) {
                    ILocalDeclaration parentLocalDeclaration;
                    IAssignment parentAssignment;
                    InferredType newType = null;
                    IFunctionDeclaration parentMethod = this.currentContext.currentMethod;
                    char[] newTypeName = null;
                    if (this.currentContext.parent != null && (parentAssignment = ((Context)this.currentContext).parent.currentAssignment) != null && parentAssignment.getExpression() instanceof IFunctionExpression && ((IFunctionExpression)parentAssignment.getExpression()).getMethodDeclaration() == parentMethod) {
                        newTypeName = Util.getTypeName(parentAssignment.getLeftHandSide());
                    } else if (this.currentContext.parent != null && (parentLocalDeclaration = ((Context)this.currentContext).parent.currentLocalDeclaration) != null && parentLocalDeclaration.getInitialization() instanceof IFunctionExpression && ((IFunctionExpression)parentLocalDeclaration.getInitialization()).getMethodDeclaration() == parentMethod) {
                        newTypeName = parentLocalDeclaration.getName();
                    } else if (parentMethod != null && parentMethod.getName() != null) {
                        newTypeName = parentMethod.getName();
                    }
                    if (newTypeName != null) {
                        newType = this.compUnit.findInferredType(newTypeName);
                        if (newType == null) {
                            newType = this.addType(newTypeName);
                        }
                    } else {
                        return false;
                    }
                    newType.isDefinition = true;
                    newType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                    if (this.passNumber == 1 && assignment.getExpression() instanceof IObjectLiteral) {
                        return false;
                    }
                    char[] memberName = fieldReference.token;
                    int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                    InferredType typeOf = this.getTypeOf(assignment.getExpression());
                    IFunctionDeclaration methodDecl = null;
                    if (typeOf == null || typeOf == this.FunctionType) {
                        methodDecl = this.getDefinedFunction(assignment.getExpression());
                    }
                    if (methodDecl != null) {
                        newType.addMethod(memberName, methodDecl, nameStart);
                    } else {
                        InferredAttribute attribute = newType.addAttribute(memberName, assignment, nameStart);
                        this.handleAttributeDeclaration(attribute, assignment.getExpression());
                        attribute.initializationStart = assignment.getExpression().sourceStart();
                        if (attribute.type == null) {
                            attribute.type = typeOf;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected IFunctionDeclaration getDefinedFunction(IExpression expression) {
        if (expression instanceof SingleNameReference) {
            Object object = this.currentContext.getMember(((SingleNameReference)expression).token);
            if (object instanceof AbstractMethodDeclaration) {
                return (MethodDeclaration)object;
            }
        } else {
            if (expression instanceof FunctionExpression) {
                return ((FunctionExpression)expression).methodDeclaration;
            }
            if (expression instanceof FieldReference) {
                InferredMethod method;
                FieldReference fieldReference = (FieldReference)expression;
                InferredType receiverType = this.getInferredType(fieldReference.receiver);
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getInferredType2(fieldReference.receiver);
                }
                if (receiverType != null && (method = receiverType.findMethod(fieldReference.token, null)) != null) {
                    return method.getFunctionDeclaration();
                }
            }
        }
        return null;
    }

    protected InferredType getTypeOf(IExpression expression) {
        if (expression instanceof IStringLiteral) {
            return this.StringType;
        }
        if (expression instanceof INumberLiteral) {
            return this.NumberType;
        }
        if (expression instanceof IAllocationExpression) {
            IAllocationExpression allocationExpression = (IAllocationExpression)((Object)expression);
            InferredType type = null;
            char[] possibleTypeName = this.constructTypeName(allocationExpression.getMember());
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
                if (type == null) {
                    type = this.addType(possibleTypeName);
                }
                return type;
            }
        } else if (expression instanceof ISingleNameReference) {
            InferredAttribute attribute;
            IAbstractVariableDeclaration varDecl = this.getVariable(expression);
            if (varDecl != null) {
                return varDecl.getInferredType();
            }
            if (this.inferredGlobal != null && (attribute = this.inferredGlobal.findAttribute(((ISingleNameReference)expression).getToken())) != null) {
                return attribute.type;
            }
        } else if (expression instanceof FieldReference) {
            InferredAttribute attribute;
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && this.currentContext.currentType != null && (attribute = this.currentContext.currentType.findAttribute(fieldReference.getToken())) != null) {
                return attribute.type;
            }
        } else {
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                boolean typeSet = false;
                InferredType memberType = null;
                if (arrayInitializer.expressions != null) {
                    int i = 0;
                    while (i < arrayInitializer.expressions.length) {
                        InferredType thisType = this.getTypeOf(arrayInitializer.expressions[i]);
                        if (thisType != null) {
                            if (!thisType.equals(memberType)) {
                                memberType = !typeSet ? thisType : null;
                            }
                            typeSet = true;
                        }
                        ++i;
                    }
                }
                if (memberType != null) {
                    InferredType type = new InferredType(InferredType.ARRAY_NAME);
                    type.referenceClass = memberType;
                    return type;
                }
                return this.ArrayType;
            }
            if (expression instanceof ITrueLiteral || expression instanceof IFalseLiteral) {
                return this.BooleanType;
            }
            if (expression instanceof IObjectLiteral) {
                InferredType type = this.createAnonymousType((IObjectLiteral)expression);
                type.sourceStart = expression.sourceStart();
                type.sourceEnd = expression.sourceEnd();
                return type;
            }
            if (expression instanceof IThisReference) {
                return this.currentContext.currentType;
            }
            if (expression instanceof Assignment) {
                return this.getTypeOf(((Assignment)expression).getExpression());
            }
            if (expression instanceof FunctionExpression) {
                return this.FunctionType;
            }
            if (expression instanceof UnaryExpression) {
                return this.getTypeOf(((UnaryExpression)expression).expression);
            }
            if (expression instanceof BinaryExpression) {
                BinaryExpression bExpression = (BinaryExpression)expression;
                int operator = (bExpression.bits & 0xFC0) >> 6;
                switch (operator) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: {
                        return this.NumberType;
                    }
                    case 14: {
                        InferredType leftType = this.getTypeOf(bExpression.left);
                        InferredType rightType = this.getTypeOf(bExpression.right);
                        if (leftType != null && leftType.equals(this.StringType)) {
                            return this.StringType;
                        }
                        if (rightType != null && rightType.equals(this.StringType)) {
                            return this.StringType;
                        }
                        if (leftType == null || rightType == null) {
                            return null;
                        }
                        if (leftType.equals(this.StringType) || rightType.equals(this.StringType)) {
                            return this.StringType;
                        }
                        if (leftType.equals(this.NumberType) && rightType.equals(this.NumberType)) {
                            return this.NumberType;
                        }
                        return null;
                    }
                    case 0: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 18: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 29: {
                        return this.BooleanType;
                    }
                }
                return null;
            }
        }
        return null;
    }

    protected void populateType(InferredType type, IObjectLiteral objLit, boolean isStatic) {
        block17: {
            if (objLit.getInferredType() != null) break block17;
            objLit.setInferredType(type);
            if (objLit.getFields() == null) break block17;
            int i = 0;
            while (i < objLit.getFields().length) {
                block20: {
                    int nameStart;
                    char[] name;
                    IObjectLiteralField field;
                    block19: {
                        block18: {
                            field = objLit.getFields()[i];
                            name = null;
                            nameStart = -1;
                            if (!(field.getFieldName() instanceof SingleNameReference)) break block18;
                            SingleNameReference singleNameReference = (SingleNameReference)field.getFieldName();
                            name = singleNameReference.token;
                            nameStart = singleNameReference.sourceStart;
                            break block19;
                        }
                        if (!(field.getFieldName() instanceof IStringLiteral)) break block20;
                        IStringLiteral stringLiteral = (IStringLiteral)field.getFieldName();
                        name = stringLiteral.source();
                        nameStart = stringLiteral.sourceStart();
                    }
                    Javadoc javaDoc = (Javadoc)field.getJsDoc();
                    InferredType returnType = null;
                    if (javaDoc != null) {
                        InferredType previousType;
                        if (javaDoc.memberOf != null) {
                            char[] typeName = javaDoc.memberOf.getFullTypeName();
                            this.convertAnonymousTypeToNamed(type, typeName);
                            type.isDefinition = true;
                        } else if (this.currentContext.isJsDocClass && javaDoc.property != null && type.isAnonymous && (previousType = this.currentContext.currentType) != null) {
                            this.copyAnonymousTypeToNamed(type, previousType);
                            type = this.currentContext.currentType = previousType;
                            objLit.setInferredType(this.currentContext.currentType);
                        }
                        if (javaDoc.returnType != null) {
                            returnType = this.addType(javaDoc.returnType.getFullTypeName());
                        }
                    }
                    if (field.getInitializer() instanceof IFunctionExpression) {
                        IFunctionExpression functionExpression = (IFunctionExpression)field.getInitializer();
                        InferredMethod method = type.addMethod(name, functionExpression.getMethodDeclaration(), nameStart);
                        method.isStatic = isStatic;
                        if (javaDoc != null) {
                            functionExpression.getMethodDeclaration().modifiers = javaDoc.modifiers;
                        }
                        this.handleFunctionDeclarationArguments(functionExpression.getMethodDeclaration(), javaDoc);
                        if (returnType != null && functionExpression.getMethodDeclaration().getInferredType() == null) {
                            functionExpression.getMethodDeclaration().setInferredType(returnType);
                        }
                    } else {
                        InferredAttribute attribute = type.findAttribute(name);
                        if (attribute == null) {
                            attribute = type.addAttribute(name, field.getInitializer(), nameStart);
                            this.handleAttributeDeclaration(attribute, field.getInitializer());
                            attribute.isStatic = isStatic;
                            if (returnType != null) {
                                attribute.type = returnType;
                                if (field.getInitializer() instanceof ObjectLiteral) {
                                    ((ObjectLiteral)field.getInitializer()).setInferredType(returnType);
                                }
                            } else {
                                attribute.type = this.getTypeOf(field.getInitializer());
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void endVisit(IAssignment assignment) {
        this.popContext();
    }

    protected boolean handleAttributeDeclaration(InferredAttribute attribute, IExpression initializer) {
        return true;
    }

    protected boolean handleFunctionCall(IFunctionCall messageSend) {
        return this.handleFunctionCall(messageSend, null);
    }

    protected boolean handleFunctionCall(IFunctionCall messageSend, LocalDeclaration assignmentExpression) {
        return true;
    }

    public void endVisit(IReturnStatement returnStatement) {
    }

    public boolean visit(IReturnStatement returnStatement) {
        if (this.currentContext.currentMethod != null && returnStatement.getExpression() != null) {
            InferredType type = null;
            IExpression expression = returnStatement.getExpression();
            if (expression instanceof IObjectLiteral) {
                type = this.createAnonymousType((ObjectLiteral)expression);
                type.sourceStart = expression.sourceStart();
                type.sourceEnd = expression.sourceEnd();
            } else {
                type = this.getTypeOf(expression);
            }
            if (this.currentContext.currentMethod.getInferredType() == this.VoidType) {
                this.currentContext.currentMethod.setInferredType(type);
            } else {
                boolean shouldSetToAny;
                boolean bl = shouldSetToAny = !((MethodDeclaration)this.currentContext.currentMethod).isInferredJsDocType();
                if (type != null && shouldSetToAny) {
                    String currentMethodInferredType = null;
                    if (this.currentContext.currentMethod.getInferredType() != null && this.currentContext.currentMethod.getInferredType().name != null) {
                        currentMethodInferredType = new String(this.currentContext.currentMethod.getInferredType().name);
                    }
                    boolean returnTypesEqual = type.equals(this.currentContext.currentMethod.getInferredType());
                    boolean returnTypeNamesEqual = new String(type.name).equals(currentMethodInferredType);
                    boolean returnTypeIsWellKnown = WellKnownTypes.containsKey(type.name);
                    boolean bl2 = shouldSetToAny = !returnTypesEqual && (!returnTypeIsWellKnown || !returnTypeIsWellKnown || !returnTypeNamesEqual);
                }
                if (shouldSetToAny) {
                    this.currentContext.currentMethod.setInferredType(null);
                }
            }
        }
        return false;
    }

    public void endVisit(IFunctionDeclaration methodDeclaration) {
        this.popContext();
    }

    public boolean visit(IFunctionDeclaration methodDeclaration) {
        InferredType type;
        this.pushContext();
        if (this.isTopLevelAnonymousFunction) {
            InferredType cfr_ignored_0 = this.currentContext.currentType;
        }
        this.isTopLevelAnonymousFunction = false;
        char[] methodName = methodDeclaration.getName();
        if (this.passNumber == 1) {
            this.buildDefinedMembers((ProgramElement[])methodDeclaration.getStatements(), (Argument[])methodDeclaration.getArguments());
            if (methodDeclaration.getJsDoc() != null) {
                InferredType type2;
                InferredMethod method = null;
                Javadoc javadoc = (Javadoc)methodDeclaration.getJsDoc();
                this.createTypeIfNecessary(javadoc);
                if (javadoc.isConstructor) {
                    type2 = !this.currentContext.isJsDocClass && methodName != null ? this.addType(methodName) : this.currentContext.currentType;
                    if (type2 != null) {
                        this.handleJSDocConstructor(type2, methodDeclaration, methodDeclaration.sourceStart());
                    }
                } else if (javadoc.memberOf != null) {
                    type2 = this.addType(javadoc.memberOf.getFullTypeName(), true);
                    char[] name = methodName;
                    int nameStart = methodDeclaration.sourceStart();
                    if (name != null) {
                        method = type2.addMethod(methodName, methodDeclaration, nameStart);
                    }
                } else if (javadoc.methodDef != null && this.currentContext.isJsDocClass) {
                    type2 = this.currentContext.currentType;
                    char[][] methName = javadoc.methodDef.getTypeName();
                    int nameStart = ((MethodDeclaration)methodDeclaration).sourceStart;
                    if (methName.length == 1) {
                        method = type2.addMethod(methName[0], methodDeclaration, nameStart);
                    } else {
                        method = type2.addMethod(methName[methName.length - 1], methodDeclaration, nameStart);
                        method.isStatic = true;
                    }
                }
                if (javadoc.returnType != null) {
                    type2 = this.addType(this.changePrimitiveToObject(javadoc.returnType.getFullTypeName()));
                    methodDeclaration.setInferredType(type2);
                    ((MethodDeclaration)methodDeclaration).bits |= 0x4000;
                }
            }
            this.handleFunctionDeclarationArguments((MethodDeclaration)methodDeclaration, (Javadoc)methodDeclaration.getJsDoc());
        }
        if (this.passNumber == 2 && methodName != null && (type = this.compUnit.findInferredType(methodName)) != null) {
            this.currentContext.currentType = type;
            type.isDefinition = true;
            int nameStart = methodDeclaration.sourceStart();
            InferredMethod method = type.addConstructorMethod(methodName, methodDeclaration, nameStart);
            method.isConstructor = true;
        }
        this.currentContext.currentMethod = (MethodDeclaration)methodDeclaration;
        if (methodDeclaration.getInferredMethod() != null && methodDeclaration.getInferredMethod().inType != null) {
            this.currentContext.currentType = methodDeclaration.getInferredMethod().inType;
        }
        if (methodDeclaration.getInferredType() == null) {
            methodDeclaration.setInferredType(this.VoidType);
        }
        return true;
    }

    protected void handleJSDocConstructor(InferredType type, IFunctionDeclaration methodDeclaration, int nameStart) {
        Javadoc javadoc = (Javadoc)methodDeclaration.getJsDoc();
        type.isDefinition = true;
        InferredMethod method = type.addConstructorMethod(type.name, methodDeclaration, nameStart);
        method.isConstructor = true;
        if (javadoc.extendsType != null) {
            InferredType superType;
            type.superClass = superType = this.addType(javadoc.extendsType.getFullTypeName());
        }
    }

    protected void handleFunctionDeclarationArguments(IFunctionDeclaration methodDeclaration, IJsDoc jsdoc) {
        if (jsdoc == null || !(jsdoc instanceof Javadoc)) {
            return;
        }
        Javadoc javadoc = (Javadoc)jsdoc;
        IArgument[] arguments = methodDeclaration.getArguments();
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                JavadocSingleNameReference param;
                if (arguments[i].getInferredType() == null && (param = javadoc.findParam(arguments[i].getName())) != null && param.types != null) {
                    char[] name = new char[]{};
                    int j = 0;
                    while (j < param.types.length) {
                        char[] typeName = this.changePrimitiveToObject(param.types[j].getFullTypeName());
                        if (j == 0) {
                            name = typeName;
                        } else {
                            name = CharOperation.append(name, '|');
                            name = CharOperation.concat(name, typeName);
                        }
                        ++j;
                    }
                    InferredType paramType = this.addType(name);
                    arguments[i].setInferredType(paramType);
                }
                ++i;
            }
        }
    }

    public boolean visit(IAllocationExpression allocationExpression) {
        InferredType type = null;
        char[] possibleTypeName = this.constructTypeName(allocationExpression.getMember());
        if (possibleTypeName != null && (type = this.compUnit.findInferredType(possibleTypeName)) == null) {
            type = this.addType(possibleTypeName);
        }
        return true;
    }

    public void endVisit(IObjectLiteralField field) {
    }

    private void copyAnonymousTypeToNamed(InferredType inClass, InferredType toType) {
        if (toType == null) {
            return;
        }
        this.compUnit.inferredTypesHash.removeKey(inClass.name);
        if (inClass.methods != null) {
            toType.methods.addAll(inClass.methods);
        }
        if (inClass.attributes != null) {
            int i = 0;
            while (i < inClass.numberAttributes) {
                toType.addAttribute(inClass.attributes[i]);
                ++i;
            }
        }
    }

    private void convertAnonymousTypeToNamed(InferredType inClass, char[] typeName) {
        if (inClass.isAnonymous) {
            inClass.isAnonymous = false;
            this.compUnit.inferredTypesHash.removeKey(inClass.name);
            inClass.name = typeName;
            this.compUnit.inferredTypesHash.put(typeName, inClass);
        }
    }

    protected boolean isMatch(IExpression expr, char[][] names, int index) {
        char[] matchName = names[index];
        if (expr instanceof SingleNameReference) {
            SingleNameReference snr = (SingleNameReference)expr;
            return CharOperation.equals(snr.token, matchName);
        }
        if (expr instanceof FieldReference && names.length > 1 && index > 0) {
            FieldReference fieldReference = (FieldReference)expr;
            if (CharOperation.equals(fieldReference.token, matchName)) {
                return this.isMatch(fieldReference.receiver, names, index - 1);
            }
        }
        return false;
    }

    protected boolean isFunction(IFunctionCall messageSend, String string) {
        String[] names = string.split("\\.");
        char[] functionName = names[names.length - 1].toCharArray();
        if (!CharOperation.equals(functionName, messageSend.getSelector())) {
            return false;
        }
        char[][] namesChars = new char[names.length][];
        int i = 0;
        while (i < namesChars.length) {
            namesChars[i] = names[i].toCharArray();
            ++i;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.getReceiver(), namesChars, namesChars.length - 2);
        }
        return true;
    }

    protected boolean isFunction(IFunctionCall messageSend, char[][] names) {
        char[] functionName = names[names.length - 1];
        if (!CharOperation.equals(functionName, messageSend.getSelector())) {
            return false;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.getReceiver(), names, names.length - 2);
        }
        return true;
    }

    public void doInfer() {
        try {
            long time0 = 0L;
            if (REPORT_INFER_TIME) {
                time0 = System.currentTimeMillis();
            }
            this.compUnit.traverse(this);
            this.passNumber = 2;
            this.compUnit.traverse(this);
            int i = 0;
            while (i < this.compUnit.numberInferredTypes) {
                if (this.compUnit.inferredTypes[i].sourceStart < 0) {
                    this.compUnit.inferredTypes[i].sourceStart = 0;
                }
                ++i;
            }
            if (REPORT_INFER_TIME) {
                long time = System.currentTimeMillis() - time0;
                System.err.println(String.valueOf(this.getClass().getName()) + " inferred " + new String(this.compUnit.getFileName()) + " in " + time + "ms");
            }
            this.compUnit = null;
        }
        catch (RuntimeException e) {
            org.eclipse.wst.jsdt.internal.core.util.Util.log(e, "error during type inferencing");
        }
    }

    protected InferredType addType(char[] className) {
        return this.addType(className, false);
    }

    protected InferredType addType(char[] className, boolean isDefinition) {
        InferredType type = this.compUnit.addType(className, isDefinition, this.inferenceProvider.getID());
        return type;
    }

    protected final void pushContext() {
        Context newContext = new Context(this.currentContext);
        this.contexts[++this.contextPtr] = this.currentContext;
        this.currentContext = newContext;
    }

    protected final void popContext() {
        this.currentContext = this.contexts[this.contextPtr];
        this.contexts[this.contextPtr--] = null;
    }

    protected final boolean isInNamedMethod() {
        return this.currentContext.currentMethod != null && this.currentContext.currentMethod.getName() != null;
    }

    protected IAbstractVariableDeclaration getVariable(IExpression expression) {
        Object var;
        char[] name = null;
        if (expression instanceof ISingleNameReference) {
            name = ((ISingleNameReference)expression).getToken();
        } else if (expression instanceof IFieldReference) {
            name = ((IFieldReference)expression).getToken();
        }
        if (name != null && (var = this.currentContext.getMember(name)) instanceof IAbstractVariableDeclaration) {
            return (IAbstractVariableDeclaration)var;
        }
        return null;
    }

    protected IAssignment getAssignment(IExpression expression) {
        Object assignment;
        char[] name = null;
        if (expression instanceof ISingleNameReference) {
            name = ((ISingleNameReference)expression).getToken();
        } else if (expression instanceof IFieldReference) {
            name = ((IFieldReference)expression).getToken();
        }
        if (name != null && (assignment = this.currentContext.getMember(name)) instanceof IAssignment) {
            return (IAssignment)assignment;
        }
        return null;
    }

    protected IAbstractFunctionDeclaration getFunction(IExpression expression) {
        Object method;
        char[] name = null;
        if (expression instanceof ISingleNameReference) {
            name = ((ISingleNameReference)expression).getToken();
        } else if (expression instanceof IFieldReference) {
            name = ((IFieldReference)expression).getToken();
        }
        if (name != null && (method = this.currentContext.getMember(name)) instanceof IAbstractFunctionDeclaration) {
            return (IAbstractFunctionDeclaration)method;
        }
        return null;
    }

    private void buildDefinedMembers(IProgramElement[] statements, IArgument[] arguments) {
        int i;
        if (arguments != null) {
            i = 0;
            while (i < arguments.length) {
                this.currentContext.addMember(arguments[i].getName(), arguments[i]);
                ++i;
            }
        }
        if (statements != null) {
            i = 0;
            while (i < statements.length) {
                IAbstractFunctionDeclaration method;
                if (statements[i] instanceof ILocalDeclaration) {
                    ILocalDeclaration local = (ILocalDeclaration)statements[i];
                    this.currentContext.addMember(local.getName(), local);
                } else if (statements[i] instanceof IAbstractFunctionDeclaration && (method = (IAbstractFunctionDeclaration)statements[i]).getName() != null) {
                    this.currentContext.addMember(method.getName(), method);
                }
                ++i;
            }
        }
    }

    private static boolean isThis(IExpression expression) {
        return expression instanceof FieldReference && ((FieldReference)expression).receiver.isThis();
    }

    private InferredType getInferredType(Expression expression) {
        InferredType type = null;
        if (expression instanceof IThisReference) {
            if (this.passNumber == 2 && this.currentContext.currentType == null) {
                char[] possibleTypeName = new char[]{'g', 'l', 'o', 'b', 'a', 'l'};
                if (this.currentContext.currentMethod != null) {
                    possibleTypeName = this.currentContext.currentMethod.getName();
                }
                this.currentContext.setCurrentType(this.createAnonymousType(possibleTypeName, null));
            }
            type = this.currentContext.currentType;
        } else if (expression instanceof SingleNameReference) {
            char[] possibleTypeName = this.constructTypeName(expression);
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
                if (type == null) {
                    if (WellKnownTypes.containsKey(possibleTypeName)) {
                        type = this.addType(possibleTypeName, true);
                    } else if (this.isKnownType(possibleTypeName)) {
                        type = this.addType(possibleTypeName, true);
                    }
                }
                if (type == null) {
                    IAbstractVariableDeclaration varDecl = this.getVariable(expression);
                    if (varDecl != null) {
                        type = varDecl.getInferredType();
                        if (type != null && !type.isAnonymous) {
                            if (varDecl.getInitialization() instanceof IAllocationExpression && !type.isFunction()) {
                                type = this.createAnonymousType(varDecl);
                            } else {
                                InferredType superType = type;
                                type = this.addType(varDecl.getName(), true);
                                type.superClass = superType;
                            }
                            type.updatePositions(varDecl.sourceStart(), varDecl.sourceEnd());
                        }
                    } else {
                        IAssignment assignment = this.getAssignment(expression);
                        if (assignment != null && (type = assignment.getInferredType()) != null && !type.isAnonymous) {
                            if (assignment.getExpression() instanceof IAllocationExpression && !type.isFunction()) {
                                type = this.createAnonymousType(assignment);
                            } else {
                                InferredType superType = type;
                                type = this.addType(this.getName(assignment.getLeftHandSide()), true);
                                type.superClass = superType;
                            }
                            type.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                        }
                    }
                }
            }
        } else if (expression instanceof FieldReference) {
            char[] possibleTypeName = this.constructTypeName(expression);
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
            }
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null) {
                InferredAttribute typeAttribute;
                FieldReference fRef = (FieldReference)expression;
                InferredType parentType = this.getInferredType(fRef.receiver);
                if (parentType != null && (typeAttribute = parentType.findAttribute(fRef.token)) != null && (type = typeAttribute.type) != null && !type.isAnonymous) {
                    if (possibleTypeName == null) {
                        possibleTypeName = typeAttribute.name;
                    }
                    typeAttribute.type = type = this.createAnonymousType(possibleTypeName, type);
                }
            }
        }
        return type;
    }

    protected boolean isKnownType(char[] possibleTypeName) {
        return false;
    }

    protected final char[] constructTypeName(IExpression expression) {
        return Util.getTypeName(expression);
    }

    public boolean visit(IObjectLiteral literal) {
        if (this.passNumber == 1 && literal.getInferredType() == null) {
            this.createAnonymousType((ObjectLiteral)literal);
        }
        this.pushContext();
        this.currentContext.currentType = literal.getInferredType();
        return true;
    }

    public void endVisit(IObjectLiteral literal) {
        this.popContext();
    }

    public void initializeOptions(InferOptions options) {
    }

    protected boolean isPossibleClassName(char[] name) {
        return false;
    }

    public IScriptFileDeclaration getScriptFileDeclaration() {
        return this.compUnit;
    }

    public InferredType findDefinedType(char[] className) {
        return this.compUnit.findInferredType(className);
    }

    protected char[] changePrimitiveToObject(char[] name) {
        if (CharOperation.equals(name, TypeConstants.BOOLEAN, false)) {
            return this.BooleanType.getName();
        }
        return name;
    }

    private char[] getName(IExpression expression) {
        if (expression instanceof ISingleNameReference) {
            return ((ISingleNameReference)expression).getToken();
        }
        if (expression instanceof IFieldReference) {
            return ((IFieldReference)expression).getToken();
        }
        return null;
    }

    static class Context {
        InferredType currentType;
        IFunctionDeclaration currentMethod;
        IAssignment currentAssignment;
        ILocalDeclaration currentLocalDeclaration;
        boolean isJsDocClass;
        private HashtableOfObject definedMembers;
        private Context parent = null;

        Context() {
        }

        Context(Context parent) {
            this.parent = parent;
            this.currentType = parent.currentType;
            this.currentMethod = parent.currentMethod;
            this.currentAssignment = parent.currentAssignment;
            this.currentLocalDeclaration = parent.currentLocalDeclaration;
            this.isJsDocClass = parent.isJsDocClass;
        }

        public Object getMember(char[] key) {
            Object value = null;
            if (this.definedMembers != null) {
                value = this.definedMembers.get(key);
            }
            if (value == null && this.parent != null) {
                value = this.parent.getMember(key);
            }
            return value;
        }

        public void addMember(char[] key, Object member) {
            if (key == null) {
                return;
            }
            if (this.definedMembers == null) {
                this.definedMembers = new HashtableOfObject();
            }
            this.definedMembers.put(key, member);
        }

        public void setCurrentType(InferredType type) {
            this.currentType = type;
            Context parentContext = this.parent;
            while (parentContext != null && parentContext.currentMethod == this.currentMethod) {
                parentContext.currentType = type;
                parentContext = parentContext.parent;
            }
        }
    }
}

