/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text.java;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.core.CompletionContext;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.text.java.ContentAssistHistory;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class JavaContentAssistInvocationContext
extends ContentAssistInvocationContext {
    private final IEditorPart fEditor;
    private IJavaScriptUnit fCU = null;
    private boolean fCUComputed = false;
    private CompletionProposalLabelProvider fLabelProvider;
    private CompletionProposalCollector fCollector;
    private ContentAssistHistory.RHSHistory fRHSHistory;
    private IType fType;
    private IJavaCompletionProposal[] fKeywordProposals = null;
    private CompletionContext fCoreContext = null;

    public JavaContentAssistInvocationContext(ITextViewer viewer, int offset, IEditorPart editor) {
        super(viewer, offset);
        this.fEditor = editor;
    }

    public JavaContentAssistInvocationContext(IJavaScriptUnit unit) {
        this.fCU = unit;
        this.fCUComputed = true;
        this.fEditor = null;
    }

    public IJavaScriptUnit getCompilationUnit() {
        if (!this.fCUComputed) {
            this.fCUComputed = true;
            if (this.fCollector != null) {
                this.fCU = this.fCollector.getCompilationUnit();
            } else {
                IJavaScriptElement je = EditorUtility.getEditorInputJavaElement(this.fEditor, false);
                if (je instanceof IJavaScriptUnit) {
                    this.fCU = (IJavaScriptUnit)je;
                }
            }
        }
        return this.fCU;
    }

    public IJavaScriptProject getProject() {
        IJavaScriptUnit unit = this.getCompilationUnit();
        return unit == null ? null : unit.getJavaScriptProject();
    }

    public IJavaCompletionProposal[] getKeywordProposals() {
        if (this.fKeywordProposals == null) {
            if (this.fCollector != null && !this.fCollector.isIgnored(3) && this.fCollector.getContext() != null) {
                this.fKeywordProposals = this.fCollector.getKeywordCompletionProposals();
            } else {
                this.computeKeywordsAndContext();
            }
        }
        return this.fKeywordProposals;
    }

    public CompletionContext getCoreContext() {
        if (this.fCoreContext == null) {
            if (this.fCollector != null) {
                this.fCoreContext = this.fCollector.getContext();
            }
            if (this.fCoreContext == null) {
                this.computeKeywordsAndContext();
            }
        }
        return this.fCoreContext;
    }

    public float getHistoryRelevance(String qualifiedTypeName) {
        return this.getRHSHistory().getRank(qualifiedTypeName);
    }

    private ContentAssistHistory.RHSHistory getRHSHistory() {
        if (this.fRHSHistory == null) {
            char[][] expectedTypes;
            CompletionContext context = this.getCoreContext();
            if (context != null && (expectedTypes = context.getExpectedTypesSignatures()) != null && expectedTypes.length > 0) {
                String expected = SignatureUtil.stripSignatureToFQN(String.valueOf(expectedTypes[0]));
                this.fRHSHistory = JavaScriptPlugin.getDefault().getContentAssistHistory().getHistory(expected);
            }
            if (this.fRHSHistory == null) {
                this.fRHSHistory = JavaScriptPlugin.getDefault().getContentAssistHistory().getHistory(null);
            }
        }
        return this.fRHSHistory;
    }

    public IType getExpectedType() {
        IJavaScriptProject project;
        char[][] expectedTypes;
        CompletionContext context;
        if (this.fType == null && this.getCompilationUnit() != null && (context = this.getCoreContext()) != null && (expectedTypes = context.getExpectedTypesSignatures()) != null && expectedTypes.length > 0 && (project = this.getCompilationUnit().getJavaScriptProject()) != null) {
            try {
                this.fType = project.findType(SignatureUtil.stripSignatureToFQN(String.valueOf(expectedTypes[0])));
            }
            catch (JavaScriptModelException x) {
                JavaScriptPlugin.log(x);
            }
        }
        return this.fType;
    }

    public CompletionProposalLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = this.fCollector != null ? this.fCollector.getLabelProvider() : new CompletionProposalLabelProvider();
        }
        return this.fLabelProvider;
    }

    protected void setCollector(CompletionProposalCollector collector) {
        this.fCollector = collector;
    }

    private void computeKeywordsAndContext() {
        block7: {
            IJavaScriptUnit cu = this.getCompilationUnit();
            if (cu == null) {
                if (this.fKeywordProposals == null) {
                    this.fKeywordProposals = new IJavaCompletionProposal[0];
                }
                return;
            }
            CompletionProposalCollector collector = new CompletionProposalCollector(cu);
            collector.setIgnored(3, false);
            collector.setIgnored(1, true);
            collector.setIgnored(2, true);
            collector.setIgnored(4, true);
            collector.setIgnored(5, true);
            collector.setIgnored(7, true);
            collector.setIgnored(12, true);
            collector.setIgnored(6, true);
            collector.setIgnored(8, true);
            collector.setIgnored(11, true);
            collector.setIgnored(10, true);
            collector.setIgnored(19, true);
            collector.setIgnored(14, true);
            collector.setIgnored(20, true);
            collector.setIgnored(15, true);
            collector.setIgnored(18, true);
            collector.setIgnored(16, true);
            collector.setIgnored(9, true);
            try {
                cu.codeComplete(this.getInvocationOffset(), (CompletionRequestor)collector);
                if (this.fCoreContext == null) {
                    this.fCoreContext = collector.getContext();
                }
                if (this.fKeywordProposals == null) {
                    this.fKeywordProposals = collector.getKeywordCompletionProposals();
                }
                if (this.fLabelProvider == null) {
                    this.fLabelProvider = collector.getLabelProvider();
                }
            }
            catch (JavaScriptModelException x) {
                JavaScriptPlugin.log(x);
                if (this.fKeywordProposals != null) break block7;
                this.fKeywordProposals = new IJavaCompletionProposal[0];
            }
        }
    }
}

