/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.interpret;

import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.BreakStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.EqualExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.IfStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.IntLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NullLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.wst.jsdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.UndefinedLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.WhileStatement;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.core.interpret.BooleanValue;
import org.eclipse.wst.jsdt.internal.core.interpret.Contants;
import org.eclipse.wst.jsdt.internal.core.interpret.FunctionValue;
import org.eclipse.wst.jsdt.internal.core.interpret.InterpretException;
import org.eclipse.wst.jsdt.internal.core.interpret.InterpreterContext;
import org.eclipse.wst.jsdt.internal.core.interpret.InterpreterResult;
import org.eclipse.wst.jsdt.internal.core.interpret.NumberValue;
import org.eclipse.wst.jsdt.internal.core.interpret.ObjectValue;
import org.eclipse.wst.jsdt.internal.core.interpret.StringValue;
import org.eclipse.wst.jsdt.internal.core.interpret.Value;
import org.eclipse.wst.jsdt.internal.core.interpret.ValueReference;
import org.eclipse.wst.jsdt.internal.core.interpret.builtin.BuiltInString;

public class InterpreterEngine
extends ASTVisitor
implements Contants {
    protected InterpreterContext context;
    InterpreterResult result = new InterpreterResult();
    static final int STOP_RETURN = 1;
    static final int STOP_BREAK = 2;
    static final int STOP_CONTINUE = 3;
    static final int STOP_THROW = 4;
    ExprStackItem[] stack = new ExprStackItem[30];
    int stackPtr = -1;

    public InterpreterEngine(InterpreterContext context) {
        this.context = context;
        int i = 0;
        while (i < this.stack.length) {
            this.stack[i] = new ExprStackItem();
            ++i;
        }
    }

    public InterpreterResult interpret(CompilationUnitDeclaration ast) {
        if (ast.ignoreFurtherInvestigation) {
            throw new InterpretException("compile errors");
        }
        this.execBlock(ast.statements);
        this.result.result = this.stackPtr >= 0 ? this.stack[this.stackPtr--] : Value.UndefinedObjectValue;
        return this.result;
    }

    public void endVisit(BinaryExpression binaryExpression, BlockScope scope) {
        ExprStackItem value2 = this.stack[this.stackPtr--];
        ExprStackItem value1 = this.stack[this.stackPtr--];
        int resultInt = 0;
        String resultObj = null;
        int type = 1;
        int operator = (binaryExpression.bits & 0xFC0) >> 6;
        switch (operator) {
            case 14: {
                if (value1.type == 3 || value2.type == 3) {
                    resultObj = String.valueOf(value1.stringValue()) + value2.stringValue();
                    type = 3;
                    break;
                }
                resultInt = value1.numberValue() + value2.numberValue();
                type = 2;
                break;
            }
            case 13: {
                resultInt = value1.numberValue() - value2.numberValue();
                type = 2;
                break;
            }
            case 9: {
                resultInt = value1.numberValue() / value2.numberValue();
                type = 2;
                break;
            }
            case 15: {
                resultInt = value1.numberValue() * value2.numberValue();
                type = 2;
                break;
            }
            case 16: {
                resultInt = value1.numberValue() % value2.numberValue();
                type = 2;
                break;
            }
            case 6: {
                resultInt = value1.numberValue() > value2.numberValue() ? 1 : 0;
                break;
            }
            case 7: {
                resultInt = value1.numberValue() >= value2.numberValue() ? 1 : 0;
                break;
            }
            case 4: {
                resultInt = value1.numberValue() < value2.numberValue() ? 1 : 0;
                break;
            }
            case 5: {
                resultInt = value1.numberValue() <= value2.numberValue() ? 1 : 0;
                break;
            }
            case 0: {
                resultInt = value1.booleanValue() && value2.booleanValue() ? 1 : 0;
                break;
            }
            case 2: {
                resultInt = value1.numberValue() & value2.numberValue();
                break;
            }
            case 3: {
                resultInt = value1.numberValue() | value2.numberValue();
                break;
            }
            case 1: {
                resultInt = value1.booleanValue() || value2.booleanValue() ? 1 : 0;
                break;
            }
            default: {
                throw new UnimplementedException("");
            }
        }
        this.pushValue(type, resultInt, resultObj);
    }

    public void endVisit(EqualExpression equalExpression, BlockScope scope) {
        ExprStackItem value2 = this.stack[this.stackPtr--];
        ExprStackItem value1 = this.stack[this.stackPtr--];
        int type = 1;
        boolean equal = false;
        int operator = (equalExpression.bits & 0xFC0) >> 6;
        switch (operator) {
            case 18: 
            case 29: {
                switch (value1.type) {
                    case 1: 
                    case 2: {
                        equal = value1.numberValue() == value2.numberValue();
                        break;
                    }
                    case 3: {
                        if (value2.type == 2) {
                            equal = value1.numberValue() == value2.numberValue();
                            break;
                        }
                        equal = value1.stringValue().equals(value2.stringValue());
                        break;
                    }
                    case 5: 
                    case 6: {
                        equal = value2.type == 5 || value2.type == 6;
                        break;
                    }
                    default: {
                        boolean bl = equal = value1.objValue == value2.objValue;
                    }
                }
                if (operator != 29) break;
                equal = !equal;
                break;
            }
            case 24: 
            case 25: {
                if (value1.type == value2.type) {
                    switch (value1.type) {
                        case 1: 
                        case 2: {
                            equal = value1.value == value2.value;
                            break;
                        }
                        case 3: {
                            equal = value1.stringValue().equals(value2.stringValue());
                            break;
                        }
                        case 5: 
                        case 6: {
                            equal = true;
                            break;
                        }
                        default: {
                            boolean bl = equal = value1.objValue == value2.objValue;
                        }
                    }
                }
                if (operator != 25) break;
                equal = !equal;
                break;
            }
            default: {
                throw new UnimplementedException("");
            }
        }
        this.pushValue(type, equal ? 1 : 0, null);
    }

    public boolean visit(PostfixExpression postfixExpression, BlockScope scope) {
        ExprStackItem value = this.execute(postfixExpression.lhs);
        if (value.reference == null) {
            throw new InterpretException("invalid assigment left hand side");
        }
        int number = value.numberValue();
        int orgNumber = number++;
        switch (postfixExpression.operator) {
            case 14: {
                break;
            }
            case 13: {
                ++number;
            }
        }
        NumberValue newValue = new NumberValue(number);
        value.reference.setValue(value.referenceName, newValue);
        this.pushNumber(orgNumber);
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression, BlockScope scope) {
        ExprStackItem value = this.execute(prefixExpression.lhs);
        if (value.reference == null) {
            throw new InterpretException("invalid assigment left hand side");
        }
        int number = value.numberValue();
        switch (prefixExpression.operator) {
            case 14: {
                ++number;
                break;
            }
            case 13: {
                ++number;
            }
        }
        NumberValue newValue = new NumberValue(number);
        value.reference.setValue(value.referenceName, newValue);
        this.pushNumber(number);
        return false;
    }

    private void pushValue(int type, int value, Object objValue) {
        if (++this.stackPtr >= this.stack.length) {
            ExprStackItem[] newStack = new ExprStackItem[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            int i = this.stack.length;
            while (i < newStack.length) {
                newStack[i] = new ExprStackItem();
                ++i;
            }
            this.stack = newStack;
        }
        this.stack[this.stackPtr].type = type;
        this.stack[this.stackPtr].value = value;
        this.stack[this.stackPtr].objValue = objValue;
    }

    private void pushNumber(int number) {
        this.pushValue(2, number, null);
    }

    private void pushString(String string) {
        this.pushValue(3, 0, string);
    }

    private void pushExprStackItem(ExprStackItem item) {
        this.pushValue(item.type, item.value, item.objValue);
    }

    private void pushReference(ValueReference reference, char[] name, Value value) {
        this.pushValue(value, false);
        this.stack[this.stackPtr].reference = reference;
        this.stack[this.stackPtr].referenceName = name;
    }

    private void pushValue(Value value, boolean allowUndefined) {
        int type = 0;
        int intValue = 0;
        Object objValue = null;
        if (value != null && (value.type != 5 || allowUndefined)) {
            type = value.type;
            switch (type) {
                case 1: 
                case 2: {
                    intValue = value.numberValue();
                    break;
                }
                case 3: {
                    objValue = value.stringValue();
                    break;
                }
                default: {
                    objValue = value;
                }
            }
        }
        this.pushValue(type, intValue, objValue);
    }

    public boolean visit(IntLiteral intLiteral, BlockScope scope) {
        int value = intLiteral.source == null ? intLiteral.value : Integer.valueOf(new String(intLiteral.source));
        this.pushNumber(value);
        return true;
    }

    public boolean visit(SingleNameReference singleNameReference, BlockScope scope) {
        char[] name = singleNameReference.token;
        Value value = this.context.getValue(name);
        this.pushReference(this.context.lastReference, name, value);
        return true;
    }

    public boolean visit(SingleNameReference singleNameReference, ClassScope scope) {
        return this.visit(singleNameReference, (BlockScope)null);
    }

    public void endVisit(Assignment assignment, BlockScope scope) {
        ExprStackItem assignValue = this.stack[this.stackPtr--];
        ExprStackItem refValue = this.stack[this.stackPtr--];
        if (refValue.reference == null) {
            throw new InterpretException("invalid assigment left hand side");
        }
        refValue.reference.setValue(refValue.referenceName, assignValue.getValue());
        this.pushExprStackItem(assignValue);
    }

    public void endVisit(ObjectLiteralField field, BlockScope scope) {
        ExprStackItem fieldValue = this.stack[this.stackPtr--];
        --this.stackPtr;
        ObjectValue object = (ObjectValue)this.stack[this.stackPtr].objValue;
        char[] name = null;
        if (field.fieldName instanceof SingleNameReference) {
            name = ((SingleNameReference)field.fieldName).token;
        } else if (field.fieldName instanceof StringLiteral) {
            name = ((StringLiteral)field.fieldName).source();
        } else {
            throw new InterpretException("invalid object literal field");
        }
        object.setValue(name, fieldValue);
    }

    public boolean visit(ObjectLiteral literal, BlockScope scope) {
        this.pushValue(4, 0, new ObjectValue());
        return true;
    }

    protected ExprStackItem execute(Expression expr) {
        expr.traverse((ASTVisitor)this, (BlockScope)null);
        ExprStackItem value = this.stack[this.stackPtr--];
        return value;
    }

    public boolean visit(FieldReference fieldReference, BlockScope scope) {
        ExprStackItem receiver = this.execute(fieldReference.receiver);
        ObjectValue object = ((Value)receiver).getObjectValue();
        this.pushReference(object, fieldReference.token, object.getValue(fieldReference.token));
        return false;
    }

    public boolean visit(ThisReference thisReference, BlockScope scope) {
        ObjectValue value = null;
        if (this.context.thisObject instanceof ObjectValue) {
            value = (ObjectValue)this.context.thisObject;
        }
        this.pushValue(value, false);
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
        FunctionValue func = new FunctionValue(methodDeclaration);
        this.context.setValue(methodDeclaration.selector, func);
        return false;
    }

    public boolean visit(FunctionExpression functionExpression, BlockScope scope) {
        FunctionValue func = new FunctionValue(functionExpression.methodDeclaration);
        this.pushValue(func, false);
        return false;
    }

    public boolean visit(MessageSend messageSend, BlockScope scope) {
        Value[] arguments;
        FunctionValue function = null;
        ValueReference receiverObj = this.context;
        Value receiver = null;
        if (messageSend.receiver != null) {
            receiver = this.execute(messageSend.receiver);
            if (receiver.type == 7 && messageSend.selector == null) {
                function = (FunctionValue)receiver.valueObject();
            } else {
                receiverObj = receiver.getObjectValue();
            }
        }
        if (function == null) {
            receiver = receiverObj.getValue(messageSend.selector);
            if (receiver.type == 7) {
                function = (FunctionValue)receiver;
            } else {
                throw new InterpretException("not a function:" + new String(messageSend.selector));
            }
        }
        int restoreStackPtr = this.stackPtr;
        if (messageSend.arguments != null) {
            arguments = new Value[messageSend.arguments.length];
            int i = 0;
            while (i < arguments.length) {
                arguments[i] = this.execute(messageSend.arguments[i]);
                ++this.stackPtr;
                ++i;
            }
        } else {
            arguments = new Value[]{};
        }
        if (!(receiverObj instanceof ObjectValue)) {
            receiverObj = null;
        }
        Value returnValue = function.execute(this, (ObjectValue)receiverObj, arguments);
        this.stackPtr = restoreStackPtr;
        this.pushValue(returnValue, true);
        return false;
    }

    protected int execBlock(ProgramElement[] statements) {
        this.context.returnCode = 0;
        int i = 0;
        while (i < statements.length && this.context.returnCode == 0) {
            statements[i].traverse(this, null);
            ++i;
        }
        return this.context.returnCode;
    }

    protected int execStatement(ProgramElement statement) {
        this.context.returnCode = 0;
        if (statement == null) {
            return 0;
        }
        statement.traverse(this, null);
        return this.context.returnCode;
    }

    public boolean visit(AllocationExpression allocationExpression, BlockScope scope) {
        Value[] arguments;
        ExprStackItem value = this.execute(allocationExpression.member);
        if (value.type != 7) {
            throw new InterpretException("not a function:" + allocationExpression.member.toString());
        }
        FunctionValue function = (FunctionValue)((Value)value).valueObject();
        ObjectValue receiver = new ObjectValue(function.prototype);
        int restoreStackPtr = this.stackPtr;
        if (!allocationExpression.isShort && allocationExpression.arguments != null) {
            arguments = new Value[allocationExpression.arguments.length];
            int i = 0;
            while (i < arguments.length) {
                arguments[i] = this.execute(allocationExpression.arguments[i]);
                ++this.stackPtr;
                ++i;
            }
        } else {
            arguments = new Value[]{};
        }
        function.execute(this, receiver, arguments);
        this.stackPtr = restoreStackPtr;
        this.pushValue(receiver, false);
        return false;
    }

    public boolean visit(FalseLiteral falseLiteral, BlockScope scope) {
        this.pushValue(1, 0, null);
        return false;
    }

    public boolean visit(NullLiteral nullLiteral, BlockScope scope) {
        this.pushValue(6, 1, Value.NullObjectValue);
        return false;
    }

    public boolean visit(UndefinedLiteral undefined, BlockScope scope) {
        this.pushValue(5, 1, Value.UndefinedObjectValue);
        return false;
    }

    public boolean visit(StringLiteral stringLiteral, BlockScope scope) {
        this.pushString(new String(stringLiteral.source()));
        return false;
    }

    public boolean visit(TrueLiteral trueLiteral, BlockScope scope) {
        this.pushValue(1, 1, null);
        return false;
    }

    public boolean visit(ReturnStatement returnStatement, BlockScope scope) {
        Value returnValue = Value.UndefinedObjectValue;
        if (returnStatement.expression != null) {
            returnValue = this.execute(returnStatement.expression);
        }
        this.context.returnValue = returnValue;
        this.context.returnCode = 1;
        return false;
    }

    public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
        Value value = Value.UndefinedObjectValue;
        if (localDeclaration.initialization != null) {
            value = this.execute(localDeclaration.initialization);
        }
        this.context.setValue(localDeclaration.name, value.getValue());
        return false;
    }

    public boolean visit(Block block, BlockScope scope) {
        this.execBlock(block.statements);
        return false;
    }

    public boolean visit(IfStatement ifStatement, BlockScope scope) {
        ExprStackItem condition = this.execute(ifStatement.condition);
        if (((Value)condition).booleanValue()) {
            this.execStatement(ifStatement.thenStatement);
        } else {
            this.execStatement(ifStatement.elseStatement);
        }
        return false;
    }

    public boolean visit(WhileStatement whileStatement, BlockScope scope) {
        ExprStackItem condition;
        while (((Value)(condition = this.execute(whileStatement.condition))).booleanValue()) {
            int returnCode = this.execStatement(whileStatement.action);
            if (returnCode == 0 || returnCode == 3) continue;
            return false;
        }
        return false;
    }

    public boolean visit(BreakStatement breakStatement, BlockScope scope) {
        this.context.returnCode = 2;
        return false;
    }

    public boolean visit(ContinueStatement continueStatement, BlockScope scope) {
        this.context.returnCode = 3;
        return false;
    }

    protected InterpreterContext newContext(InterpreterContext parent, ObjectValue thisObject, ProgramElement method) {
        return new InterpreterContext(parent, thisObject);
    }

    public void restorePreviousContext() {
        this.context = this.context.parent;
    }

    class ExprStackItem
    extends Value {
        ValueReference reference;
        char[] referenceName;
        int value;
        Object objValue;

        ExprStackItem() {
            super(0);
        }

        public int numberValue() {
            switch (this.type) {
                case 1: 
                case 2: {
                    return this.value;
                }
                case 3: {
                    return Integer.valueOf((String)this.objValue);
                }
            }
            throw new UnimplementedException();
        }

        public String stringValue() {
            switch (this.type) {
                case 1: {
                    return this.value != 0 ? "true" : "false";
                }
                case 2: {
                    return String.valueOf(this.value);
                }
                case 3: {
                    return (String)this.objValue;
                }
            }
            throw new UnimplementedException();
        }

        public boolean booleanValue() {
            switch (this.type) {
                case 1: 
                case 2: {
                    return this.value != 0;
                }
                case 3: {
                    return ((String)this.objValue).length() != 0;
                }
            }
            throw new UnimplementedException();
        }

        public ObjectValue getObjectValue() {
            switch (this.type) {
                case 4: 
                case 7: {
                    return (ObjectValue)this.objValue;
                }
                case 5: {
                    throw new InterpretException("null reference");
                }
                case 1: {
                    ObjectValue obj = new ObjectValue();
                    obj.setValue(VALUE_ARR, this);
                    return obj;
                }
                case 2: {
                    ObjectValue obj = new ObjectValue();
                    obj.setValue(VALUE_ARR, this);
                    return obj;
                }
                case 3: {
                    ObjectValue obj = new ObjectValue(BuiltInString.prototype);
                    obj.setValue(VALUE_ARR, new StringValue(this.stringValue()));
                    return obj;
                }
            }
            throw new UnimplementedException();
        }

        Value getValue() {
            switch (this.type) {
                case 5: 
                case 6: {
                    return (Value)this.objValue;
                }
                case 1: {
                    return new BooleanValue(this.value != 0);
                }
                case 2: {
                    return new NumberValue(this.value);
                }
                case 3: {
                    return new StringValue((String)this.objValue);
                }
                case 4: {
                    return (ObjectValue)this.objValue;
                }
                case 7: {
                    return (FunctionValue)this.objValue;
                }
            }
            throw new UnimplementedException();
        }

        public Object valueObject() {
            return this.objValue;
        }
    }
}

