/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2.resource.java.source;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.jpa2.resource.java.GeneratedAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceGeneratedAnnotation
extends SourceAnnotation<Type>
implements GeneratedAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.annotation.Generated");
    private static final DeclarationAnnotationElementAdapter<String[]> VALUE_ADAPTER = SourceGeneratedAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String[]> valueAdapter;
    private final Vector<String> values = new Vector();
    private static final DeclarationAnnotationElementAdapter<String> DATE_ADAPTER = SourceGeneratedAnnotation.buildAdapter("date");
    private final AnnotationElementAdapter<String> dateAdapter;
    private String date;
    private static final DeclarationAnnotationElementAdapter<String> COMMENTS_ADAPTER = SourceGeneratedAnnotation.buildAdapter("comments");
    private final AnnotationElementAdapter<String> commentsAdapter;
    private String comments;

    public SourceGeneratedAnnotation(JavaResourcePersistentType parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = this.buildAnnotationElementAdapter(VALUE_ADAPTER);
        this.dateAdapter = this.buildAdapter(DATE_ADAPTER);
        this.commentsAdapter = this.buildAdapter(COMMENTS_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.annotation.Generated";
    }

    private AnnotationElementAdapter<String[]> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new MemberAnnotationElementAdapter<String[]>(this.member, daea);
    }

    private AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new MemberAnnotationElementAdapter<String>(this.member, daea);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.initializeValues(astRoot);
        this.date = this.buildDate(astRoot);
        this.comments = this.buildComments(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValues(astRoot);
        this.syncDate(this.buildDate(astRoot));
        this.syncComments(this.buildComments(astRoot));
    }

    public IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.values);
    }

    @Override
    public ListIterator<String> values() {
        return new CloneListIterator(this.values);
    }

    @Override
    public int valuesSize() {
        return this.values.size();
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public void addValue(String value) {
        this.addValue(this.values.size(), value);
    }

    @Override
    public void addValue(int index, String value) {
        this.values.add(index, value);
        this.writeValues();
    }

    @Override
    public void moveValue(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.values, (int)targetIndex, (int)sourceIndex);
        this.writeValues();
    }

    @Override
    public void removeValue(String value) {
        this.values.remove(value);
        this.writeValues();
    }

    @Override
    public void removeValue(int index) {
        this.values.remove(index);
        this.writeValues();
    }

    private void writeValues() {
        this.valueAdapter.setValue(this.values.toArray(new String[this.values.size()]));
    }

    private void initializeValues(CompilationUnit astRoot) {
        String[] astValues = this.valueAdapter.getValue(astRoot);
        int i = 0;
        while (i < astValues.length) {
            this.values.add(astValues[i]);
            ++i;
        }
    }

    private void syncValues(CompilationUnit astRoot) {
        String[] astValues = this.valueAdapter.getValue(astRoot);
        this.synchronizeList(Arrays.asList(astValues), this.values, "values");
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public void setDate(String date) {
        if (this.attributeValueHasChanged(this.date, date)) {
            this.date = date;
            this.dateAdapter.setValue(date);
        }
    }

    protected void syncDate(String astDate) {
        String old = this.date;
        this.date = astDate;
        this.firePropertyChanged("date", old, astDate);
    }

    private String buildDate(CompilationUnit astRoot) {
        return this.dateAdapter.getValue(astRoot);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        if (this.attributeValueHasChanged(this.comments, comments)) {
            this.comments = comments;
            this.commentsAdapter.setValue(comments);
        }
    }

    protected void syncComments(String astComments) {
        String old = this.comments;
        this.comments = astComments;
        this.firePropertyChanged("comments", old, astComments);
    }

    private String buildComments(CompilationUnit astRoot) {
        return this.commentsAdapter.getValue(astRoot);
    }

    protected static DeclarationAnnotationElementAdapter<String[]> buildValueAdapter() {
        return SourceGeneratedAnnotation.buildArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceGeneratedAnnotation.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, AnnotationStringArrayExpressionConverter.forStrings());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String[]> converter) {
        return new ConversionDeclarationAnnotationElementAdapter<String[]>(annotationAdapter, elementName, false, converter);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SourceGeneratedAnnotation.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(annotationAdapter, elementName);
    }
}

