/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.ejb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PersistenceType implements Enumerator
{
    BEAN_LITERAL(0, "Bean", "Bean"),
    CONTAINER_LITERAL(1, "Container", "Container");

    public static final int BEAN = 0;
    public static final int CONTAINER = 1;
    private static final PersistenceType[] VALUES_ARRAY;
    public static final List<PersistenceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PersistenceType[]{BEAN_LITERAL, CONTAINER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PersistenceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PersistenceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PersistenceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PersistenceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PersistenceType get(int value) {
        switch (value) {
            case 0: {
                return BEAN_LITERAL;
            }
            case 1: {
                return CONTAINER_LITERAL;
            }
        }
        return null;
    }

    private PersistenceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

