/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaDiscriminatorColumn
extends AbstractJavaNamedColumn<DiscriminatorColumnAnnotation>
implements JavaDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType;
    protected DiscriminatorType defaultDiscriminatorType;
    protected Integer specifiedLength;
    protected int defaultLength;

    public GenericJavaDiscriminatorColumn(JavaEntity parent, JavaDiscriminatorColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initialize(DiscriminatorColumnAnnotation column) {
        super.initialize(column);
        this.defaultDiscriminatorType = this.buildDefaultDiscriminatorType();
        this.defaultLength = this.buildDefaultLength();
        this.specifiedDiscriminatorType = this.getResourceDiscriminatorType();
        this.specifiedLength = this.getResourceLength();
    }

    @Override
    public JavaDiscriminatorColumn.Owner getOwner() {
        return (JavaDiscriminatorColumn.Owner)super.getOwner();
    }

    @Override
    public boolean isResourceSpecified() {
        return ((DiscriminatorColumnAnnotation)this.getResourceColumn()).isSpecified();
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.getSpecifiedDiscriminatorType() == null ? this.getDefaultDiscriminatorType() : this.getSpecifiedDiscriminatorType();
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return this.defaultDiscriminatorType;
    }

    protected void setDefaultDiscriminatorType(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.defaultDiscriminatorType;
        this.defaultDiscriminatorType = discriminatorType;
        this.firePropertyChanged("defaultDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        ((DiscriminatorColumnAnnotation)this.getResourceColumn()).setDiscriminatorType(DiscriminatorType.toJavaResourceModel(newSpecifiedDiscriminatorType));
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    @Override
    public int getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength().intValue();
    }

    @Override
    public int getDefaultLength() {
        return this.defaultLength;
    }

    protected void setDefaultLength(int defaultLength) {
        int old = this.defaultLength;
        this.defaultLength = defaultLength;
        this.firePropertyChanged("defaultLength", old, defaultLength);
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        ((DiscriminatorColumnAnnotation)this.getResourceColumn()).setLength(newSpecifiedLength);
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    @Override
    public void update(DiscriminatorColumnAnnotation discriminatorColumn) {
        this.resourceColumn = discriminatorColumn;
        this.setSpecifiedName_(discriminatorColumn.getName());
        this.setColumnDefinition_(discriminatorColumn.getColumnDefinition());
        this.setSpecifiedDiscriminatorType_(this.getResourceDiscriminatorType());
        this.setSpecifiedLength_(this.getResourceLength());
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.setDefaultName(this.buildDefaultName());
        this.setDefaultDiscriminatorType(this.buildDefaultDiscriminatorType());
        this.setDefaultLength(this.buildDefaultLength());
    }

    protected DiscriminatorType getResourceDiscriminatorType() {
        return DiscriminatorType.fromJavaResourceModel(((DiscriminatorColumnAnnotation)this.getResourceColumn()).getDiscriminatorType());
    }

    protected Integer getResourceLength() {
        return ((DiscriminatorColumnAnnotation)this.getResourceColumn()).getLength();
    }

    @Override
    public JavaEntity getParent() {
        return (JavaEntity)super.getParent();
    }

    protected int buildDefaultLength() {
        return this.getOwner().getDefaultLength();
    }

    protected DiscriminatorType buildDefaultDiscriminatorType() {
        return this.getOwner().getDefaultDiscriminatorType();
    }
}

