/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resolvers.IReferenceResolver;
import org.eclipse.wst.common.componentcore.resolvers.ReferenceResolverUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.internal.HashUtil;

public class VirtualReference
implements IVirtualReference {
    private IVirtualComponent referencedComponent;
    private IVirtualComponent enclosingComponent;
    private IPath runtimePath;
    private int dependencyType;
    private String archiveName;
    private boolean derived;

    public VirtualReference() {
    }

    public VirtualReference(IVirtualComponent anEnclosingComponent, IVirtualComponent aReferencedComponent) {
        this(anEnclosingComponent, aReferencedComponent, (IPath)new Path(String.valueOf('/')), 0, false);
    }

    public VirtualReference(IVirtualComponent anEnclosingComponent, IVirtualComponent aReferencedComponent, IPath aRuntimePath) {
        this(anEnclosingComponent, aReferencedComponent, aRuntimePath, 0, false);
    }

    public VirtualReference(IVirtualComponent anEnclosingComponent, IVirtualComponent aReferencedComponent, IPath aRuntimePath, int aDependencyType) {
        this(anEnclosingComponent, aReferencedComponent, aRuntimePath, aDependencyType, false);
    }

    public VirtualReference(IVirtualComponent anEnclosingComponent, IVirtualComponent aReferencedComponent, IPath aRuntimePath, int aDependencyType, boolean isDerived) {
        this.enclosingComponent = anEnclosingComponent;
        this.referencedComponent = aReferencedComponent;
        this.runtimePath = aRuntimePath;
        this.dependencyType = aDependencyType;
        this.derived = isDerived;
    }

    public void create(int updateFlags, IProgressMonitor aMonitor) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.enclosingComponent.getProject());
            WorkbenchComponent component = core.getComponent();
            EList referencedComponents = component.getReferencedComponents();
            IReferenceResolver resolver = ReferenceResolverUtil.getDefault().getResolver(this);
            ReferencedComponent refComp = resolver.resolve(this);
            if (!referencedComponents.contains(refComp)) {
                referencedComponents.add(refComp);
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(aMonitor);
                core.dispose();
            }
        }
    }

    public void setRuntimePath(IPath aRuntimePath) {
        this.runtimePath = aRuntimePath;
    }

    public IPath getRuntimePath() {
        return this.runtimePath;
    }

    public void setDependencyType(int aDependencyType) {
        this.dependencyType = aDependencyType;
    }

    public int getDependencyType() {
        return this.dependencyType;
    }

    public boolean exists() {
        return false;
    }

    public IVirtualComponent getEnclosingComponent() {
        return this.enclosingComponent;
    }

    public IVirtualComponent getReferencedComponent() {
        return this.referencedComponent;
    }

    public void setReferencedComponent(IVirtualComponent aReferencedComponent, EObject dependentObject) {
        if (aReferencedComponent == null) {
            return;
        }
        StructureEdit enclosingCore = null;
        StructureEdit refCore = null;
        try {
            enclosingCore = StructureEdit.getStructureEditForWrite(this.enclosingComponent.getProject());
            refCore = StructureEdit.getStructureEditForWrite(this.referencedComponent.getProject());
            WorkbenchComponent enclosingComp = enclosingCore.getComponent();
            WorkbenchComponent refComp = refCore.getComponent();
            ReferencedComponent actualReferencedComponent = enclosingCore.findReferencedComponent(enclosingComp, refComp);
            if (actualReferencedComponent != null) {
                this.referencedComponent = aReferencedComponent;
                IReferenceResolver resolver = ReferenceResolverUtil.getDefault().getResolver(this);
                URI uri = resolver.resolve(this).getHandle();
                actualReferencedComponent.setHandle(uri);
                actualReferencedComponent.setDependentObject(dependentObject);
            }
        }
        finally {
            if (enclosingCore != null) {
                enclosingCore.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                enclosingCore.dispose();
            }
            if (refCore != null) {
                refCore.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                refCore.dispose();
            }
        }
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public void setDerived(boolean val) {
        this.derived = val;
    }

    public boolean equals(Object anOther) {
        if (anOther == null || !(anOther instanceof IVirtualReference)) {
            return false;
        }
        if (anOther == this) {
            return true;
        }
        IVirtualReference otherRef = (IVirtualReference)anOther;
        return (this.getArchiveName() != null ? this.getArchiveName().equals(otherRef.getArchiveName()) : otherRef.getArchiveName() == null) && this.getRuntimePath().equals((Object)otherRef.getRuntimePath()) && this.getEnclosingComponent().equals(otherRef.getEnclosingComponent()) && this.getReferencedComponent().equals(otherRef.getReferencedComponent()) && this.getDependencyType() == otherRef.getDependencyType();
    }

    public int hashCode() {
        int hash = HashUtil.SEED;
        hash = HashUtil.hash((int)hash, (Object)this.getArchiveName());
        hash = HashUtil.hash((int)hash, (Object)this.getRuntimePath());
        hash = HashUtil.hash((int)hash, (Object)this.getEnclosingComponent());
        hash = HashUtil.hash((int)hash, (Object)this.getReferencedComponent());
        hash = HashUtil.hash((int)hash, (int)this.getDependencyType());
        return hash;
    }
}

