/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableUniqueConstraintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceUniqueConstraintAnnotation
extends SourceAnnotation<Member>
implements NestableUniqueConstraintAnnotation {
    private DeclarationAnnotationElementAdapter<String[]> columnNamesDeclarationAdapter;
    private AnnotationElementAdapter<String[]> columnNamesAdapter;
    private final Vector<String> columnNames = new Vector();

    public SourceUniqueConstraintAnnotation(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter((AnnotatedElement)member, idaa));
        this.columnNamesDeclarationAdapter = this.buildColumnNamesDeclarationAdapter();
        this.columnNamesAdapter = this.buildColumnNamesAdapter();
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.UniqueConstraint";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.initializeColumnNames(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncColumnNames(astRoot);
    }

    @Override
    public ListIterator<String> columnNames() {
        return new CloneListIterator(this.columnNames);
    }

    private Iterable<String> getColumnNames() {
        return new LiveCloneIterable(this.columnNames);
    }

    @Override
    public int columnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public void addColumnName(String columnName) {
        this.addColumnName(this.columnNames.size(), columnName);
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.writeColumnNames();
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.columnNames, (int)targetIndex, (int)sourceIndex);
        this.writeColumnNames();
    }

    @Override
    public void removeColumnName(String columnName) {
        this.columnNames.remove(columnName);
        this.writeColumnNames();
    }

    @Override
    public void removeColumnName(int index) {
        this.columnNames.remove(index);
        this.writeColumnNames();
    }

    private void writeColumnNames() {
        this.columnNamesAdapter.setValue((Object)this.columnNames.toArray(new String[this.columnNames.size()]));
    }

    private void initializeColumnNames(CompilationUnit astRoot) {
        String[] astColumnNames = (String[])this.columnNamesAdapter.getValue(astRoot);
        int i = 0;
        while (i < astColumnNames.length) {
            this.columnNames.add(astColumnNames[i]);
            ++i;
        }
    }

    private void syncColumnNames(CompilationUnit astRoot) {
        String[] javaColumnNames = (String[])this.columnNamesAdapter.getValue(astRoot);
        this.synchronizeList(Arrays.asList(javaColumnNames), this.columnNames, "columnNames");
    }

    @Override
    public boolean columnNamesTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.columnNamesDeclarationAdapter, pos, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String[]> buildColumnNamesDeclarationAdapter() {
        return SourceUniqueConstraintAnnotation.buildArrayAnnotationElementAdapter(this.daa, "columnNames");
    }

    private AnnotationElementAdapter<String[]> buildColumnNamesAdapter() {
        return this.buildAnnotationElementAdapter(this.columnNamesDeclarationAdapter);
    }

    private AnnotationElementAdapter<String[]> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceUniqueConstraintAnnotation.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, (ExpressionConverter<String[]>)AnnotationStringArrayExpressionConverter.forStrings());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String[]> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.columnNames.isEmpty();
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.columnNamesDeclarationAdapter = this.buildColumnNamesDeclarationAdapter();
        this.columnNamesAdapter = this.buildColumnNamesAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        ArrayList<String> columnNamesState = new ArrayList<String>(this.columnNames.size());
        for (String columnName : this.getColumnNames()) {
            columnNamesState.add(columnName);
        }
        map.put("columnNames", columnNamesState);
        this.columnNames.clear();
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        List columnNamesState = (List)map.get("columnNames");
        for (String columnName : columnNamesState) {
            this.addColumnName(columnName);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.columnNames);
    }
}

