/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceIdClassAnnotation
extends SourceAnnotation<Type>
implements IdClassAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.IdClass");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceIdClassAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private String fullyQualifiedClassName;
    private boolean fqClassNameStale = true;

    public SourceIdClassAnnotation(JavaResourcePersistentType parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)type, VALUE_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.IdClass";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.fqClassNameStale = true;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        if (this.attributeValueHasChanged(this.value, astValue)) {
            this.syncValue_(astValue);
        }
    }

    private void syncValue_(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.fqClassNameStale = true;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public String getFullyQualifiedClassName() {
        if (this.fqClassNameStale) {
            this.fullyQualifiedClassName = this.buildFullyQualifiedClassName();
            this.fqClassNameStale = false;
        }
        return this.fullyQualifiedClassName;
    }

    private String buildFullyQualifiedClassName() {
        return this.value == null ? null : this.buildFullyQualifiedClassName_();
    }

    private String buildFullyQualifiedClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.valueAdapter.getExpression(this.buildASTRoot()));
    }

    protected static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", SimpleTypeStringExpressionConverter.instance());
    }
}

