/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaIdClassReference
extends AbstractJavaJpaContextNode
implements JavaIdClassReference {
    protected String idClassName = this.buildIdClassName();
    protected String fullyQualifiedIdClassName;
    protected JavaPersistentType idClass;

    public GenericJavaIdClassReference(JavaTypeMapping parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setIdClassName_(this.buildIdClassName());
        if (this.idClass != null) {
            this.idClass.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.setFullyQualifiedIdClassName(this.buildFullyQualifiedIdClassName());
        this.updateIdClass();
    }

    @Override
    public String getIdClassName() {
        return this.getSpecifiedIdClassName();
    }

    @Override
    public String getSpecifiedIdClassName() {
        return this.idClassName;
    }

    @Override
    public void setSpecifiedIdClassName(String name) {
        if (this.valuesAreDifferent(name, this.idClassName)) {
            this.getIdClassAnnotationForUpdate().setValue(name);
            this.removeIdClassAnnotationIfUnset();
            this.setIdClassName_(name);
        }
    }

    protected void setIdClassName_(String name) {
        String old = this.idClassName;
        this.idClassName = name;
        this.firePropertyChanged("specifiedIdClassName", old, name);
    }

    protected String buildIdClassName() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation == null ? null : annotation.getValue();
    }

    @Override
    public String getDefaultIdClassName() {
        return null;
    }

    @Override
    public boolean isSpecified() {
        return this.idClassName != null;
    }

    protected IdClassAnnotation getIdClassAnnotation() {
        return (IdClassAnnotation)this.getResourcePersistentType().getAnnotation(this.getIdClassAnnotationName());
    }

    protected IdClassAnnotation getIdClassAnnotationForUpdate() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation != null ? annotation : this.buildIdClassAnnotation();
    }

    protected IdClassAnnotation buildIdClassAnnotation() {
        return (IdClassAnnotation)this.getResourcePersistentType().addAnnotation(this.getIdClassAnnotationName());
    }

    protected void removeIdClassAnnotationIfUnset() {
        if (this.getIdClassAnnotation().isUnset()) {
            this.removeIdClassAnnotation();
        }
    }

    protected void removeIdClassAnnotation() {
        this.getResourcePersistentType().removeAnnotation(this.getIdClassAnnotationName());
    }

    protected String getIdClassAnnotationName() {
        return "javax.persistence.IdClass";
    }

    @Override
    public String getFullyQualifiedIdClassName() {
        return this.fullyQualifiedIdClassName;
    }

    protected void setFullyQualifiedIdClassName(String name) {
        String old = this.fullyQualifiedIdClassName;
        this.fullyQualifiedIdClassName = name;
        this.firePropertyChanged("fullyQualifiedIdClass", old, name);
    }

    protected String buildFullyQualifiedIdClassName() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation == null ? null : annotation.getFullyQualifiedClassName();
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClass;
    }

    protected void setIdClass(JavaPersistentType idClass) {
        JavaPersistentType old = this.idClass;
        this.idClass = idClass;
        this.firePropertyChanged("idClass", old, idClass);
    }

    protected void updateIdClass() {
        JavaResourcePersistentType resourceIdClass = this.resolveResourceIdClass();
        if (resourceIdClass == null) {
            if (this.idClass != null) {
                this.idClass.dispose();
                this.setIdClass(null);
            }
        } else if (this.idClass == null) {
            this.setIdClass(this.buildIdClass(resourceIdClass));
        } else if (this.idClass.getResourcePersistentType() == resourceIdClass) {
            this.idClass.update();
        } else {
            this.idClass.dispose();
            this.setIdClass(this.buildIdClass(resourceIdClass));
        }
    }

    protected JavaResourcePersistentType resolveResourceIdClass() {
        if (this.fullyQualifiedIdClassName == null) {
            return null;
        }
        JavaResourcePersistentType jrpt = this.getJpaProject().getJavaResourcePersistentType(this.fullyQualifiedIdClassName);
        return jrpt == null ? null : (jrpt.isMapped() ? null : jrpt);
    }

    protected JavaPersistentType buildIdClass(JavaResourcePersistentType resourceClass) {
        return this.getJpaFactory().buildJavaPersistentType(this, resourceClass);
    }

    @Override
    public char getIdClassEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public JavaTypeMapping getParent() {
        return (JavaTypeMapping)super.getParent();
    }

    protected JavaTypeMapping getTypeMapping() {
        return this.getParent();
    }

    protected JavaPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    protected JavaResourcePersistentType getResourcePersistentType() {
        return this.getPersistentType().getResourcePersistentType();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateIdClass(messages, reporter, astRoot);
    }

    protected void validateIdClass(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        JavaResourcePersistentType jrpt;
        if (this.isSpecified() && (jrpt = this.getJpaProject().getJavaResourcePersistentType(this.getFullyQualifiedIdClassName())) != null && jrpt.isMapped()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TYPE_MAPPING_ID_CLASS_NOT_VALID", new String[]{jrpt.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange(astRoot);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation == null ? null : annotation.getTextRange(astRoot);
    }
}

