/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.earcreation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.application.internal.operations.DefaultJ2EEComponentCreationOperation;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.earcreation.IDefaultJ2EEComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.moduleextension.EjbModuleExtension;
import org.eclipse.jst.j2ee.internal.moduleextension.JcaModuleExtension;
import org.eclipse.jst.j2ee.internal.moduleextension.WebModuleExtension;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class DefaultJ2EEComponentCreationDataModelProvider
extends AbstractDataModelProvider
implements IDefaultJ2EEComponentCreationDataModelProperties {
    private static String CREATE_BASE = "DefaultJ2EEComponentCreationDataModel.CREATE_";
    private static final int EJB = 0;
    private static final int WEB = 1;
    private static final int RAR = 2;
    private static final int CLIENT = 3;
    private static final String WEB_SUFFIX = "Web";
    private static final String EJB_SUFFIX = "EJB";
    private static final String CLIENT_SUFFIX = "Client";
    private static final String CONNECTOR_SUFFIX = "Connector";
    private IDataModel ejbModel;
    private IDataModel ejbFacetModel;
    private IDataModel webModel;
    private IDataModel webFacetModel;
    private IDataModel jcaModel;
    private IDataModel jcaFacetModel;
    private IDataModel clientModel;
    private IDataModel clientFacetModel;
    private List<IDataModel> extendedModelsToDispose = new ArrayList<IDataModel>();

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.PROJECT_NAME");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.EAR_NAME");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.CREATE_EJB");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.CREATE_WEB");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.EJB_SUPPORT");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.WEB_SUPPORT");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.CLIENT_SUPPORT");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.CONNECTOR_SUPPORT");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.MODULE_NAME_COLLISIONS_VALIDATION");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.ENABLED");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_CLIENT");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_EJB");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_JCA");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_WEB");
        propertyNames.add("DefaultJ2EEComponentCreationDataModel.FACET_RUNTIME");
        return propertyNames;
    }

    public IDataModelOperation getDefaultOperation() {
        return new DefaultJ2EEComponentCreationOperation(this.model);
    }

    public void init() {
        this.initNestedCreationModels();
        super.init();
    }

    protected void initNestedCreationModels() {
        JcaModuleExtension rarExt;
        WebModuleExtension webExt;
        this.clientModel = DataModelFactory.createDataModel((IDataModelProvider)new AppClientFacetProjectCreationDataModelProvider());
        this.extendedModelsToDispose.add(this.clientModel);
        this.model.addNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_CLIENT", this.clientModel);
        this.clientFacetModel = ((IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.clientModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel("jst.appclient");
        this.clientFacetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        this.clientFacetModel.setBooleanProperty("J2EEModuleFacetInstallDataModelProvider.PROHIBIT_ADD_TO_EAR", true);
        EjbModuleExtension ejbExt = EarModuleManager.getEJBModuleExtension();
        if (ejbExt != null) {
            this.ejbModel = ejbExt.createProjectDataModel();
            if (this.ejbModel != null) {
                this.extendedModelsToDispose.add(this.ejbModel);
                this.model.addNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_EJB", this.ejbModel);
                this.ejbFacetModel = ((IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.ejbModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel("jst.ejb");
                this.ejbFacetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
                this.ejbFacetModel.setBooleanProperty("J2EEModuleFacetInstallDataModelProvider.PROHIBIT_ADD_TO_EAR", true);
            }
        }
        if ((webExt = EarModuleManager.getWebModuleExtension()) != null) {
            this.webModel = webExt.createProjectDataModel();
            if (this.webModel != null) {
                this.extendedModelsToDispose.add(this.webModel);
                this.model.addNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_WEB", this.webModel);
                this.webFacetModel = ((IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.webModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel("jst.web");
                this.webFacetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
                this.webFacetModel.setBooleanProperty("J2EEModuleFacetInstallDataModelProvider.PROHIBIT_ADD_TO_EAR", true);
            }
        }
        if ((rarExt = EarModuleManager.getJCAModuleExtension()) != null) {
            this.jcaModel = rarExt.createProjectDataModel();
            if (this.jcaModel != null) {
                this.extendedModelsToDispose.add(this.jcaModel);
                this.model.addNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_JCA", this.jcaModel);
                this.jcaFacetModel = ((IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.jcaModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel("jst.connector");
                this.jcaFacetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
                this.jcaFacetModel.setBooleanProperty("J2EEModuleFacetInstallDataModelProvider.PROHIBIT_ADD_TO_EAR", true);
            }
        }
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.startsWith(CREATE_BASE)) {
            return this.getDefaultCreateValue(propertyName);
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.ENABLED")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.EJB_SUPPORT") || propertyName.equals("DefaultJ2EEComponentCreationDataModel.WEB_SUPPORT") || propertyName.equals("DefaultJ2EEComponentCreationDataModel.CLIENT_SUPPORT") || propertyName.equals("DefaultJ2EEComponentCreationDataModel.CONNECTOR_SUPPORT")) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDefaultCreateValue(String propertyName) {
        int version;
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR") && (version = this.getIntProperty("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION")) < 13) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private int convertPropertyNameToInt(String propertyName) {
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_WEB")) {
            return 1;
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_EJB")) {
            return 0;
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR")) {
            return 2;
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT")) {
            return 3;
        }
        return -1;
    }

    private String ensureUniqueProjectName(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String newName = projectName;
        int index = 0;
        IProject proj = root.getProject(newName);
        while (proj.exists()) {
            newName = String.valueOf(projectName) + ++index;
            proj = root.getProject(newName);
        }
        return newName;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean notify = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION")) {
            this.updatedJ2EEVersion((Integer)propertyValue);
            return true;
        }
        if (propertyName.startsWith(CREATE_BASE)) {
            this.notifyEnablement(this.convertPropertyNameToInt(propertyName));
        } else if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.EAR_NAME")) {
            this.setDefaultComponentNames((String)propertyValue);
        } else if (this.webModel != null && propertyName.equals("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME")) {
            this.webModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
        } else if (this.clientModel != null && propertyName.equals("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME")) {
            this.clientModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
        } else if (this.ejbModel != null && propertyName.equals("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME")) {
            this.ejbModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
        } else if (this.jcaModel != null && propertyName.equals("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME")) {
            this.jcaModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
        } else if ("DefaultJ2EEComponentCreationDataModel.FACET_RUNTIME".equals(propertyName)) {
            if (this.webModel != null) {
                this.webModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", propertyValue);
            }
            if (this.clientModel != null) {
                this.clientModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", propertyValue);
            }
            if (this.ejbModel != null) {
                this.ejbModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", propertyValue);
            }
            if (this.jcaModel != null) {
                this.jcaModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", propertyValue);
            }
        }
        return notify;
    }

    private void notifyEnablement(int flag) {
        String propertyName = null;
        switch (flag) {
            case 0: {
                propertyName = "DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME";
                break;
            }
            case 1: {
                propertyName = "DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME";
                break;
            }
            case 3: {
                propertyName = "DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME";
                break;
            }
            case 2: {
                propertyName = "DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME";
            }
        }
        if (propertyName != null) {
            this.model.notifyPropertyChange(propertyName, 3);
        }
    }

    private void updatedJ2EEVersion(Integer version) {
        this.setNestedJ2EEVersion(version);
        if (version < 13 && this.model.isPropertySet("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR")) {
            this.model.setProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR", (Object)Boolean.FALSE);
        }
    }

    public IStatus validateModuleNameCollisions() {
        if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.ENABLED")) {
            ArrayList<String> list = new ArrayList<String>();
            String projectName = null;
            String actualProjectName = null;
            boolean errorCollision = false;
            boolean errorNoSelection = true;
            if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT")) {
                actualProjectName = this.clientModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                projectName = WTPPlugin.isPlatformCaseSensitive() ? actualProjectName : actualProjectName.toLowerCase();
                list.add(projectName);
                errorNoSelection = false;
            }
            if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_EJB")) {
                actualProjectName = this.ejbModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                String string = projectName = WTPPlugin.isPlatformCaseSensitive() ? actualProjectName : actualProjectName.toLowerCase();
                if (!list.contains(projectName)) {
                    list.add(projectName);
                } else {
                    errorCollision = true;
                }
                errorNoSelection = false;
            }
            if (!errorCollision && this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_WEB")) {
                actualProjectName = this.webModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                String string = projectName = WTPPlugin.isPlatformCaseSensitive() ? actualProjectName : actualProjectName.toLowerCase();
                if (!list.contains(projectName)) {
                    list.add(projectName);
                } else {
                    errorCollision = true;
                }
                errorNoSelection = false;
            }
            if (!errorCollision && this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR")) {
                actualProjectName = this.jcaModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                String string = projectName = WTPPlugin.isPlatformCaseSensitive() ? actualProjectName : actualProjectName.toLowerCase();
                if (!list.contains(projectName)) {
                    list.add(projectName);
                } else {
                    errorCollision = true;
                }
                errorNoSelection = false;
            }
            if (errorCollision) {
                return J2EEPlugin.newErrorStatus(EARCreationResourceHandler.getString("DuplicateModuleNames", new Object[]{actualProjectName}), null);
            }
            if (errorNoSelection) {
                return J2EEPlugin.newErrorStatus(EARCreationResourceHandler.NoModulesSelected, null);
            }
        }
        return OK_STATUS;
    }

    public IStatus validate(String propertyName) {
        if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT") && propertyName.equals("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME")) {
            return this.clientModel.validateProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        }
        if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_WEB") && propertyName.equals("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME")) {
            return this.webModel.validateProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        }
        if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_EJB") && propertyName.equals("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME")) {
            return this.ejbModel.validateProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        }
        if (this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR") && propertyName.equals("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME")) {
            return this.jcaModel.validateProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        }
        return super.validate(propertyName);
    }

    private void setDefaultNestedComponentName(String name, int flag) {
        IDataModel modModule = this.getNestedModel(flag);
        if (modModule != null) {
            String compName = this.ensureUniqueProjectName(name);
            modModule.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)compName);
        }
    }

    private void setDefaultComponentNames(String base) {
        String componentName = base.endsWith(EJB_SUFFIX) ? base : String.valueOf(base) + EJB_SUFFIX;
        this.setDefaultNestedComponentName(componentName, 0);
        this.setProperty("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME", componentName);
        componentName = base.endsWith(WEB_SUFFIX) ? base : String.valueOf(base) + WEB_SUFFIX;
        this.setDefaultNestedComponentName(componentName, 1);
        this.setProperty("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME", componentName);
        componentName = base.endsWith(CLIENT_SUFFIX) ? base : String.valueOf(base) + CLIENT_SUFFIX;
        this.setDefaultNestedComponentName(componentName, 3);
        this.setProperty("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME", componentName);
        componentName = base.endsWith(CONNECTOR_SUFFIX) ? base : String.valueOf(base) + CONNECTOR_SUFFIX;
        this.setDefaultNestedComponentName(componentName, 2);
        this.setProperty("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME", componentName);
        if (this.webModel != null) {
            this.webModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)base);
        }
        if (this.clientModel != null) {
            this.clientModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)base);
        }
        if (this.ejbModel != null) {
            this.ejbModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)base);
        }
        if (this.jcaModel != null) {
            this.jcaModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)base);
        }
    }

    private void setNestedJ2EEVersion(Object j2eeVersion) {
        IFacetedProjectWorkingCopy fpwc;
        IProjectFacetVersion facetVersion;
        String facetVersionString;
        int j2eeVer = (Integer)j2eeVersion;
        if (this.ejbModel != null && this.ejbFacetModel != null) {
            facetVersionString = J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToEJBVersionID(j2eeVer));
            facetVersion = ProjectFacetsManager.getProjectFacet((String)this.ejbFacetModel.getStringProperty("IFacetDataModelProperties.FACET_ID")).getVersion(facetVersionString);
            this.ejbFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)facetVersion);
            fpwc = (IFacetedProjectWorkingCopy)this.ejbModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            fpwc.changeProjectFacetVersion(facetVersion);
        }
        if (this.webModel != null && this.webFacetModel != null) {
            facetVersionString = J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToWebVersionID(j2eeVer));
            facetVersion = ProjectFacetsManager.getProjectFacet((String)this.webFacetModel.getStringProperty("IFacetDataModelProperties.FACET_ID")).getVersion(facetVersionString);
            this.webFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)facetVersion);
            fpwc = (IFacetedProjectWorkingCopy)this.webModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            fpwc.changeProjectFacetVersion(facetVersion);
        }
        if (this.jcaModel != null && this.jcaFacetModel != null) {
            facetVersionString = J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToConnectorVersionID(j2eeVer));
            facetVersion = ProjectFacetsManager.getProjectFacet((String)this.jcaFacetModel.getStringProperty("IFacetDataModelProperties.FACET_ID")).getVersion(facetVersionString);
            this.jcaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)facetVersion);
            fpwc = (IFacetedProjectWorkingCopy)this.jcaModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            fpwc.changeProjectFacetVersion(facetVersion);
        }
        if (this.clientModel != null && this.clientFacetModel != null) {
            facetVersionString = J2EEVersionUtil.convertVersionIntToString(j2eeVer);
            facetVersion = ProjectFacetsManager.getProjectFacet((String)this.clientFacetModel.getStringProperty("IFacetDataModelProperties.FACET_ID")).getVersion(facetVersionString);
            this.clientFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)facetVersion);
            fpwc = (IFacetedProjectWorkingCopy)this.clientModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            fpwc.changeProjectFacetVersion(facetVersion);
        }
    }

    private IDataModel getNestedModel(int flag) {
        switch (flag) {
            case 0: {
                return this.ejbModel;
            }
            case 1: {
                return this.webModel;
            }
            case 2: {
                return this.jcaModel;
            }
            case 3: {
                return this.clientModel;
            }
        }
        return null;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CONNECTOR_COMPONENT_NAME")) {
            int version = this.getIntProperty("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION");
            return version > 12 && this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CONNECTOR_SUPPORT");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CLIENT_SUPPORT");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.APPCLIENT_NAME")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_EJB")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.EJB_SUPPORT");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.EJB_COMPONENT_NAME")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_EJB");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.CREATE_WEB")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.WEB_SUPPORT");
        }
        if (propertyName.equals("DefaultJ2EEComponentCreationDataModel.WEB_COMPONENT_NAME")) {
            return this.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_WEB");
        }
        return super.isPropertyEnabled(propertyName);
    }

    public void dispose() {
        for (IDataModel dm : this.extendedModelsToDispose) {
            dm.dispose();
        }
        this.extendedModelsToDispose.clear();
        super.dispose();
    }
}

