/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;

public final class ColorMap {
    private boolean _isFrozen;
    private int _lastColorId = -1;
    private final List<String> _id2color = new ArrayList<String>();
    private final Map<String, @Nullable Integer> _color2id = new LinkedHashMap<String, Integer>();

    public ColorMap() {
        this(null);
    }

    public ColorMap(@Nullable List<String> _colorMap) {
        if (_colorMap != null) {
            this._isFrozen = true;
            int i = 0;
            int len = _colorMap.size();
            while (i < len) {
                this._color2id.put(_colorMap.get(i), i);
                this._id2color.add(_colorMap.get(i));
                ++i;
            }
        } else {
            this._isFrozen = false;
        }
    }

    public int getId(@Nullable String _color) {
        if (_color == null) {
            return 0;
        }
        String color = _color.toUpperCase();
        Integer value = this._color2id.get(color);
        if (value != null) {
            return value;
        }
        if (this._isFrozen) {
            throw new TMException("Missing color in color map - " + color);
        }
        value = ++this._lastColorId;
        this._color2id.put(color, value);
        if (value >= this._id2color.size()) {
            this._id2color.add(color);
        } else {
            this._id2color.set(value, color);
        }
        return value;
    }

    public List<String> getColorMap() {
        return new ArrayList<String>(this._color2id.keySet());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (object instanceof ColorMap) {
            void other;
            ColorMap colorMap = (ColorMap)object;
            ColorMap cfr_ignored_0 = (ColorMap)object;
            return this._lastColorId == other._lastColorId && this._color2id.equals(other._color2id);
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 + this._lastColorId) + this._color2id.hashCode();
    }
}

