/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyContentProvider;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyItemLabelProvider;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.navigator.CommonViewerSorter;

public class TypeHierarchyDialog
extends PopupDialog {
    private static boolean showSuperTypes = true;
    private final LanguageServersRegistry.LanguageServerDefinition lsDefinition;
    private final @NonNull IDocument document;
    private final ITextSelection textSelection;

    public TypeHierarchyDialog(@NonNull Shell parentShell, ITextSelection textSelection, @NonNull IDocument document,  @NonNull LanguageServersRegistry.LanguageServerDefinition ls) {
        super(parentShell, 16, true, true, true, false, false, null, null);
        this.lsDefinition = ls;
        this.document = document;
        this.textSelection = textSelection;
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 2048, new PatternFilter(), true, false){

            protected Composite createFilterControls(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 0;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                Composite filterControls = super.createFilterControls(composite);
                filterControls.setLayoutData((Object)new GridData(4, 0, true, false));
                this.createToolBar(composite);
                return composite;
            }

            private void createToolBar(Composite composite) {
                ToolBar toolbar = new ToolBar(composite, 540676);
                final ToolItem hierchyModeItem = new ToolItem(toolbar, 8);
                this.updateHierarchyModeItem(hierchyModeItem, showSuperTypes);
                hierchyModeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        showSuperTypes = !showSuperTypes;
                        this.updateHierarchyModeItem(hierchyModeItem, showSuperTypes);
                        TypeHierarchyDialog.this.setHierarchyMode(this.getViewer(), showSuperTypes);
                    }
                });
            }

            private void updateHierarchyModeItem(ToolItem hierchyModeItem, boolean showSuperTypes) {
                hierchyModeItem.setImage(LSPImages.getImage(showSuperTypes ? "IMG_SUBTYPE" : "IMG_SUPERTYPE"));
                hierchyModeItem.setToolTipText(showSuperTypes ? Messages.typeHierarchy_show_subtypes : Messages.typeHierarchy_show_supertypes);
            }
        };
        TreeViewer viewer = filteredTree.getViewer();
        this.setHierarchyMode(viewer, showSuperTypes);
        viewer.setLabelProvider((IBaseLabelProvider)new TypeHierarchyItemLabelProvider());
        viewer.setAutoExpandLevel(2);
        viewer.addDoubleClickListener(event -> {
            TypeHierarchyItem item = (TypeHierarchyItem)((IStructuredSelection)event.getSelection()).getFirstElement();
            LSPEclipseUtils.open(item.getUri(), item.getSelectionRange());
        });
        CommonViewerSorter sorter = new CommonViewerSorter();
        viewer.setComparator((ViewerComparator)sorter);
        viewer.setUseHashlookup(true);
        viewer.setInput((Object)this.textSelection);
        return filteredTree;
    }

    private void setHierarchyMode(TreeViewer viewer, boolean showSuperTypes) {
        viewer.setContentProvider((IContentProvider)new TypeHierarchyContentProvider(this.lsDefinition, this.document, showSuperTypes));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.typeHierarchy);
        shell.setSize(280, 300);
    }
}

