/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.markdown;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.markdown.ui.preferences.MarkdownPreferences;
import org.eclipse.wildwebdeveloper.ui.preferences.ProcessStreamConnectionProviderWithPreference;

public final class MarkdownLanguageServer
extends ProcessStreamConnectionProviderWithPreference {
    static final String MARKDOWN_LANGUAGE_SERVER_ID = "org.eclipse.wildwebdeveloper.markdown";
    private static final String[] SUPPORTED_SECTIONS = new String[]{"markdown"};
    private static volatile String markdownLanguageServerPath;
    private static volatile String proxyPath;
    private static final ConcurrentHashMap<String, AtomicInteger> SERVER_ROOT_COUNTS;
    private String instanceRootUri;

    static {
        SERVER_ROOT_COUNTS = new ConcurrentHashMap();
    }

    public static Set<String> getServerRoots() {
        return Collections.unmodifiableSet(SERVER_ROOT_COUNTS.keySet());
    }

    private static Path resolveResource(String resourcePath) throws IOException {
        try {
            URL url = FileLocator.toFileURL((URL)MarkdownLanguageServer.class.getResource(resourcePath));
            return Paths.get(url.toURI()).toAbsolutePath();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Failed to resolve resource URI: " + resourcePath, ex);
        }
    }

    public MarkdownLanguageServer() throws IOException {
        super(MARKDOWN_LANGUAGE_SERVER_ID, Activator.getDefault().getPreferenceStore(), SUPPORTED_SECTIONS);
        if (markdownLanguageServerPath == null) {
            markdownLanguageServerPath = MarkdownLanguageServer.resolveResource("/node_modules/vscode-markdown-languageserver/dist/node/workerMain.js").toString();
        }
        if (proxyPath == null) {
            proxyPath = MarkdownLanguageServer.resolveResource("md-lsp-proxy.js").toString();
        }
        this.setCommands(List.of(NodeJSManager.getNodeJsLocation().getAbsolutePath(), proxyPath, markdownLanguageServerPath, "--stdio"));
        this.setWorkingDirectory(System.getProperty("user.dir"));
    }

    public Map<String, Object> getInitializationOptions(URI projectRootUri) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (projectRootUri != null) {
            this.setWorkingDirectory(projectRootUri.getRawPath());
            this.instanceRootUri = projectRootUri.toString();
            SERVER_ROOT_COUNTS.compute(this.instanceRootUri, (k, v) -> {
                if (v == null) {
                    return new AtomicInteger(1);
                }
                v.incrementAndGet();
                return v;
            });
        }
        options.put("markdownFileExtensions", List.of("md", "markdown", "mdown"));
        return options;
    }

    @Override
    protected Object createSettings() {
        return MarkdownPreferences.getGlobalSettings();
    }

    @Override
    public void stop() {
        if (this.instanceRootUri != null) {
            SERVER_ROOT_COUNTS.computeIfPresent(this.instanceRootUri, (k, v) -> v.decrementAndGet() <= 0 ? null : v);
            this.instanceRootUri = null;
        }
        super.stop();
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        ResponseMessage response;
        if (message instanceof ResponseMessage && (response = (ResponseMessage)message).getResult() instanceof InitializeResult) {
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(this.createSettings());
            languageServer.getWorkspaceService().didChangeConfiguration(params);
        }
    }
}

