/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.core.editor.DesignerEditorListener;
import org.eclipse.wb.core.editor.DesignerState;
import org.eclipse.wb.core.editor.IDesignPage;
import org.eclipse.wb.core.editor.IDesignerEditor;
import org.eclipse.wb.core.editor.IEditorPage;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.databinding.Activator;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.DatabindingRootProcessor;
import org.eclipse.wb.internal.core.databinding.parser.ParseState;
import org.eclipse.wb.internal.core.databinding.ui.EditComposite;
import org.eclipse.wb.internal.core.databinding.ui.EditSelection;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public class BindingDesignPage
implements IEditorPage {
    private IDesignerEditor m_designerEditor;
    private IDesignPage m_designPage;
    private Composite m_composite;
    private EditComposite m_editComposite;
    private CLabel m_errorLabel;
    private IDatabindingsProvider m_databindingsProvider;
    private final DesignerEditorListener m_designPageListener = new DesignerEditorListener(){

        public void reparsed() {
            BindingDesignPage.this.handleUpdatePage();
        }
    };

    public static void addPage(List<IEditorPage> pages) {
        for (IEditorPage page : pages) {
            if (!(page instanceof BindingDesignPage)) continue;
            return;
        }
        pages.add(new BindingDesignPage());
    }

    public void initialize(IDesignerEditor designerEditor) {
        this.m_designerEditor = designerEditor;
        this.m_designPage = this.m_designerEditor.getMultiMode().getDesignPage();
    }

    public void dispose() {
        DatabindingRootProcessor.STATES.remove(this.m_designerEditor.getCompilationUnit());
    }

    public void handleActiveState(boolean activate) {
        if (activate) {
            this.m_designPage.setSourceModelSynchronizationEnabled(true);
            this.m_designerEditor.addDesignPageListener(this.m_designPageListener);
            this.handleUpdatePage();
        } else {
            this.m_designerEditor.removeDesignPageListener(this.m_designPageListener);
            this.m_designPage.setSourceModelSynchronizationEnabled(false);
        }
    }

    private void handleUpdatePage() {
        boolean isNew;
        if (this.m_designPage.getDesignerState() != DesignerState.Successful) {
            if (this.m_editComposite != null) {
                this.m_editComposite.dispose();
                this.m_editComposite = null;
            }
            if (this.m_errorLabel != null) {
                this.m_errorLabel.dispose();
            }
            this.m_errorLabel = new CLabel(this.m_composite, 0);
            this.m_errorLabel.setText(Messages.BindingDesignPage_erorrMessage);
            this.m_errorLabel.setImage(Activator.getImage("errors.gif"));
            GridDataFactory.create((Control)this.m_errorLabel).fillH().grabH();
            this.m_databindingsProvider = null;
            this.m_composite.layout();
            return;
        }
        EditSelection selection = this.m_editComposite == null ? null : this.m_editComposite.getEditSelection();
        ParseState state = DatabindingRootProcessor.STATES.get(this.m_designerEditor.getCompilationUnit());
        Assert.isNotNull((Object)state);
        boolean bl = isNew = this.m_databindingsProvider != state.databindingsProvider;
        if (isNew) {
            if (this.m_editComposite != null) {
                this.m_editComposite.dispose();
            }
            if (this.m_errorLabel != null) {
                this.m_errorLabel.dispose();
                this.m_errorLabel = null;
            }
            this.m_databindingsProvider = state.databindingsProvider;
            this.m_databindingsProvider.setBindingPage(this);
            IDialogSettings settings = UiUtils.getSettings(state.plugin.getDialogSettings(), this.m_databindingsProvider.getClass().getName());
            this.m_editComposite = new EditComposite(this.m_composite, 0, state.plugin, this.m_databindingsProvider, settings);
            GridDataFactory.create((Control)this.m_editComposite).fill().grab();
            this.m_composite.layout();
        }
        this.m_editComposite.setInput(!isNew, selection);
    }

    private void handleReparse() {
        this.m_designPage.refreshGEF();
        this.handleUpdatePage();
    }

    public static void handleReparse(final BindingDesignPage bindingPage, JavaInfo javaInfoRoot) {
        if (EnvironmentUtils.isTestingTime()) {
            return;
        }
        javaInfoRoot.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshed2() throws Exception {
                if (bindingPage == null) {
                    IDesignerEditor editor = (IDesignerEditor)DesignerPlugin.getActiveEditor();
                    editor.getMultiMode().getDesignPage().refreshGEF();
                } else {
                    bindingPage.handleReparse();
                }
            }
        });
    }

    public Control createControl(Composite parent) {
        this.m_composite = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)this.m_composite).noMargins().noSpacing();
        return this.m_composite;
    }

    public Control getControl() {
        return this.m_composite;
    }

    public void setFocus() {
        this.m_composite.setFocus();
    }

    public String getName() {
        return Messages.BindingDesignPage_name;
    }

    public Image getImage() {
        return Activator.getImage("paperclip.png");
    }
}

