/* signers.c - maintain signer sets
 *	Copyright (C) 2001 Werner Koch (dd9jn)
 *	Copyright (C) 2003 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "util.h"
#include "context.h"
#include "rungpg.h"

/* The signers are directly stored in the context.
 * So this is quite different to a recipient set.
 */


void
gpgme_signers_clear (gpgme_ctx_t ctx)
{
    int i;
    
    return_if_fail( ctx );    
    if (!ctx->signers)
        return;
    for( i = 0; i < ctx->signers_size; i++ ) {
        if( !ctx->signers[i] )
            break;
        gpgme_key_unref( ctx->signers[i] );
        ctx->signers[i] = NULL;
    }
}


gpgme_error_t
gpgme_signers_add( gpgme_ctx_t ctx, const gpgme_key_t key )
{
    int i = 0;
    
    if (!ctx || !key)
        return mk_error (Invalid_Value);
    
    if (!ctx->signers)
        ctx->signers_size = 0;
    
    for (i=0; i < ctx->signers_size && ctx->signers[i]; i++ )
        ;
    if ( !(i < ctx->signers_size) ) {
        gpgme_key_t *newarr;
        int j;
        int n = ctx->signers_size + 5;
        
        newarr = calloc ( n, sizeof *newarr );
        if ( !newarr )
            return mk_error (Out_Of_Core);
        for (j=0; j < ctx->signers_size; j++ )
            newarr[j] = ctx->signers[j];
        ctx->signers_size = n;
        safe_free (ctx->signers);
        ctx->signers = newarr;
    }
    gpgme_key_ref (key);
    ctx->signers[i] = key;
    return 0;
}


gpgme_key_t
gpgme_signers_enum( const gpgme_ctx_t ctx, int seq )
{
    int i;
    
    return_null_if_fail( ctx );
    return_null_if_fail( seq >= 0 );
    
    if( !ctx->signers )
        ctx->signers_size = 0;
    for( i=0; i < ctx->signers_size && ctx->signers[i]; i++ ) {
        if( i==seq ) {
            gpgme_key_ref (ctx->signers[i]);
            return ctx->signers[i];
        }
    }
    return NULL;
}
