/* wptVerifyFileDlg.cpp - (File Manager) Verify file 
 *	Copyright (C) 2001, 2002, 2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptGPG.h"
#include "wptW32API.h"
#include "wptTypes.h"
#include "wptNLS.h"
#include "wptVersion.h"
#include "wptCommonCtl.h"
#include "wptKeylist.h"
#include "wptTypes.h"
#include "wptKeyserver.h"

static listview_ctrl_t dlg_lv = NULL;
static HWND dlg_wnd = NULL;
static int use_dlg_event = 0;
static HANDLE dlg_event = NULL;
static int dlg_init = 0;


static BOOL CALLBACK
file_verify_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    static listview_ctrl_t lv = NULL;
    int rc = 0;
    
    switch( msg ) {
    case WM_INITDIALOG:
	#ifndef LANG_DE
        SetWindowText (dlg, _("File Verify"));
	#endif
        rc = verlist_build (&lv, GetDlgItem (dlg, IDC_VERIFY_SIGLIST), 1);
	if (rc)
	    BUG (dlg);
	EnableWindow (GetDlgItem (dlg, IDC_VERIFY_SAVE), FALSE);
        SetForegroundWindow (dlg);
        dlg_lv = lv;
        dlg_wnd = dlg;
        dlg_init = 1;
        return TRUE;
        
    case WM_DESTROY:
        if (lv) {
            listview_release (lv);
            lv = NULL;			
        }
        dlg_lv = NULL;
        dlg_wnd = NULL;
        dlg_init = 0;
        return FALSE;

    case WM_NOTIFY:
        NMHDR *notify;
        
        notify = (NMHDR *)lparam;
        if (notify && notify->code == NM_DBLCLK && 
	    notify->idFrom == IDC_VERIFY_SIGLIST) {
	    char buf[64];
	    listview_get_item_text (lv, listview_get_curr_pos (lv), 4, buf, 63);
	    if (strlen (buf) == 10 && buf[0] == '0' && buf[1] == 'x') {
		rc = msg_box (dlg, _("Do you want to retrieve the key?"), _("Verify"), MB_QUEST_ASK);
		if (rc == IDYES) {
		    if (!hkp_recv_key (dlg, default_keyserver, default_keyserver_port, buf, 0, 0))
			keycache_reload (dlg);
		}
	    }

	}
	break;

    case WM_SYSCOMMAND:
	if (LOWORD (wparam) == SC_CLOSE)
	    EndDialog (dlg, TRUE);
	return FALSE;
        
    case WM_COMMAND:
        switch (LOWORD (wparam)) {
        case IDOK:
	    if (use_dlg_event)
		SetEvent (dlg_event);
            EndDialog (dlg, TRUE);
            return TRUE;
        }
        break;
    }
    
    return FALSE;
} /* file_verify_dlg_proc */


static DWORD CALLBACK
file_verify_dlg_thread (void *opaque)
{
    DialogBoxParam (glob_hinst, (LPCTSTR)IDD_WINPT_VERIFY, GetActiveWindow(),
                    file_verify_dlg_proc, NULL);
    if (use_dlg_event) {
	CloseHandle (dlg_event);
	use_dlg_event = 0;
    }
    ExitThread (0);

    return 0;
} /* file_verify_dlg_thread */


int
file_verify_create_dlg (void)
{
    DWORD tid;
    HANDLE thread_hd;
    SECURITY_ATTRIBUTES sec_attr;
    
    if (dlg_init == 1)
        return 0;
    
    memset (&sec_attr, 0, sizeof (sec_attr));
    sec_attr.bInheritHandle = FALSE;
    sec_attr.lpSecurityDescriptor = NULL;
    sec_attr.nLength = sizeof (sec_attr);
    thread_hd = CreateThread (&sec_attr, 0, file_verify_dlg_thread, NULL, 0, &tid);
    if (thread_hd == NULL) {
        msg_box (NULL, "Could not create verify thread.", _("Verify"), MB_ERR);
        return 1;
    }
    
    return 0;
} /* file_verify_create_dlg */


int
file_verify_add_state (siglog_context_t c)
{
    if (dlg_lv)
        return verlist_add_sig_log (dlg_lv, c);
    return 1;
} /* file_verify_add_state */


void
file_verify_use_event (void)
{
    SECURITY_ATTRIBUTES sec_attr;
    
    memset (&sec_attr, 0, sizeof (sec_attr));
    sec_attr.bInheritHandle = FALSE;
    sec_attr.nLength = sizeof (sec_attr);
    dlg_event = CreateEvent (&sec_attr, TRUE, FALSE, NULL);

    use_dlg_event = 1;
} /* file_verify_use_event */


void
file_verify_wait (void)
{
    WaitForSingleObject (dlg_event, INFINITE);
} /* file_verify_wait */
