/////////////////////////////////////////////////////////////////////////////
//
// Format: 8
//
// Used by: Suikoden
//
/////////////////////////////////////////////////////////////////////////////

#include "headers.h"

#include "fmt.h"
#include "rip.h"

/////////////////////////////////////////////////////////////////////////////

int fmt_8_detect(FILE *inf, const char *ext) {
  int score = 50;

  // base the entire test on the file extension for now
  if(!strcasecmp(ext, "8")) return 90;

  return score;
}

/////////////////////////////////////////////////////////////////////////////

int fmt_8_rip(
  FILE *inf,
  struct OPTIONS *opts
) {
  struct OPTIONS myopts;

  if(opts) { memcpy(&myopts, opts, sizeof(myopts)); }
  else { memset(&myopts, 0, sizeof(myopts)); }

  // set .8-specific options
  if(!myopts.use_channels) {
    myopts.use_channels = 1;
    myopts.channels = 2;
  }
  if(!myopts.use_honor_endflag) {
    myopts.use_honor_endflag = 1;
    myopts.honor_endflag = 1;
  }
  if(!myopts.use_samplerate) {
    myopts.use_samplerate = 1;
    myopts.samplerate = 44100;
  }
  if(!myopts.use_interleave) {
    myopts.use_interleave = 1;
    myopts.interleave = 0x4000;
  }

  // now pass these options to rip
  return rip(inf, &myopts, NULL);
}

/////////////////////////////////////////////////////////////////////////////
