/*
 *  hap -- a mail notification program
 * 
 *  copyright 1995 by Eric Fischer, etaoin@uchicago.edu
 * 
 *  copies of hap may be redistributed under the terms of the
 *  GNU public license, copies of which are available from
 *  the Free Software Foundation, 59 Temple Place, Boston, MA
 *  02111 USA.
 *
 */

#include "hap.h"

/****************************************************************************

   IOCTL THINGS

****************************************************************************/

/* return the width of the screen attached to the standard output */

int
screenwid()
{
	extern int tcapcols;
	int cols = 0;

#ifdef TIOCGSIZE
	{	
		struct ttysize buf;

		if ((int) ioctl (1, TIOCGSIZE, &buf) != -1) {
			if (buf.ts_cols > 0) cols = buf.ts_cols;
		}
	}
#else
#   ifdef TIOCGWINSZ
	{
		struct winsize buf;

		if ((int) ioctl (1, TIOCGWINSZ, &buf) != -1) {
			if (buf.ws_col > 0) cols = buf.ws_col;
		}
	}
#   endif
#endif

	if (cols == 0) {
		char *s = getenv ("COLUMNS");

		if (s && atoi(s)) {
			cols = atoi (s);
		}
	}

	if (cols == 0) cols = tcapcols;
	
	return cols;
}

/* return the number of lines on the screen at stdout */

int
screenhigh()
{
	extern int tcaplines;
	int lines = 0;

#ifdef TIOCGSIZE
	{	
		struct ttysize buf;

		if ((int) ioctl (1, TIOCGSIZE, &buf) != -1) {
			if (buf.ts_lines > 0) lines = buf.ts_lines;
		}
	}
#else
#   ifdef TIOCGWINSZ
	{
		struct winsize buf;

		if ((int) ioctl (1, TIOCGWINSZ, &buf) != -1) {
			if (buf.ws_row > 0) lines = buf.ws_row;
		}
	}
#   endif
#endif

	if (lines == 0) {
		char *s = getenv ("LINES");

		if (s && atoi (s)) {
			lines = atoi (s);
		}
	}

	if (lines == 0) lines = tcaplines;
	
	return lines;
}

