/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.freedesktop.cairo;

import org.gnu.glib.Enum;

public class Status extends Enum {
    static final private int _SUCCESS = 0;
    static final public Status SUCCESS = new Status (_SUCCESS);
    static final private int _NO_MEMORY = 1;
    static final public Status NO_MEMORY = new Status (_NO_MEMORY);
    static final private int _INVALID_RESTORE = 2;
    static final public Status INVALID_RESTORE = new Status (_INVALID_RESTORE);
    static final private int _INVALID_POP_GROUP = 3;
    static final public Status INVALID_POP_GROUP = new Status (_INVALID_POP_GROUP);
    static final private int _NO_CURRENT_POINT = 4;
    static final public Status NO_CURRENT_POINT = new Status (_NO_CURRENT_POINT);
    static final private int _INVALID_MATRIX = 5;
    static final public Status INVALID_MATRIX = new Status (_INVALID_MATRIX);
    static final private int _INVALID_STATUS = 6;
    static final public Status INVALID_STATUS = new Status (_INVALID_STATUS);
    static final private int _NULL_POINTER = 7;
    static final public Status NULL_POINTER = new Status (_NULL_POINTER);
    static final private int _INVALID_STRING = 8;
    static final public Status INVALID_STRING = new Status (_INVALID_STRING);
    static final private int _INVALID_PATH_DATA = 9;
    static final public Status INVALID_PATH_DATA = new Status (_INVALID_PATH_DATA);
    static final private int _READ_ERROR = 10;
    static final public Status READ_ERROR = new Status (_READ_ERROR);
    static final private int _WRITE_ERROR = 11;
    static final public Status WRITE_ERROR = new Status (_WRITE_ERROR);
    static final private int _SURFACE_FINISHED = 12;
    static final public Status SURFACE_FINISHED = new Status (_SURFACE_FINISHED);
    static final private int _SURFACE_TYPE_MISMATCH = 13;
    static final public Status SURFACE_TYPE_MISMATCH = new Status (_SURFACE_TYPE_MISMATCH);
    static final private int _PATTERN_TYPE_MISMATCH = 13;
    static final public Status PATTERN_TYPE_MISMATCH = new Status (_PATTERN_TYPE_MISMATCH);
    static final private int _INVALID_CONTENT = 14;
    static final public Status INVALID_CONTENT = new Status (_INVALID_CONTENT);
    static final private int _INVALID_FORMAT = 13;
    static final public Status INVALID_FORMAT = new Status (_INVALID_FORMAT);
    static final private int _INVALID_VISUAL = 13;
    static final public Status INVALID_VISUAL = new Status (_INVALID_VISUAL);
    static final private int _FILE_NOT_FOUND = 13;
    static final public Status FILE_NOT_FOUND = new Status (_FILE_NOT_FOUND);
    static final private int _INVALID_DASH = 14;
    static final public Status INVALID_DASH = new Status (_INVALID_DASH);

    static final private Status[] theInterned = new Status[] {
        SUCCESS, NO_MEMORY, INVALID_RESTORE, INVALID_POP_GROUP, NO_CURRENT_POINT,
        INVALID_MATRIX, INVALID_STATUS, NULL_POINTER, INVALID_STRING, INVALID_PATH_DATA,
        READ_ERROR, WRITE_ERROR, SURFACE_FINISHED, SURFACE_TYPE_MISMATCH, PATTERN_TYPE_MISMATCH,
        INVALID_CONTENT, INVALID_FORMAT, INVALID_VISUAL, FILE_NOT_FOUND, INVALID_DASH
    };
    static private java.util.Hashtable theInternedExtras;
    static final private Status theSacrificialOne = new Status (0);
    static public Status intern (int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        Status already = (Status) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new Status(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Status(int value) {
        value_ = value;
    }

    public boolean test (Status other) {
        return (value_ & other.value_) == other.value_;
    }
    
    public String toString() {
        return cairo_status_to_string(value_);
    }
    
    native static final private String cairo_status_to_string(int status);
}
