/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <stdlib.h>
#include <jni.h>
#include <cairo.h>
#include <cairo-pdf.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_PDFSurface
#define _Included_org_freedesktop_cairo_PDFSurface
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_PDFSurface
 * Method:    cairo_pdf_surface_create
 * Signature: (Ljava/lang/String;DDDD)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_PDFSurface_cairo_1pdf_1surface_1create
  (JNIEnv *env, jclass cls, jstring filename, jdouble width, jdouble height)
{
	char *fn;
	cairo_surface_t *sur;
	
	fn = (char*)(*env)->GetStringUTFChars(env, filename, NULL);
	sur = cairo_pdf_surface_create(fn, width, height);
	(*env)->ReleaseStringUTFChars(env, filename, fn);
	return getHandleFromPointer(env, sur);
}

/*
 * Class:     org_freedesktop_cairo_PDFSurface
 * Method:    cairo_pdf_surface_set_dpi
 * Signature: (Lorg/gnu/glib/Handle;DD)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_PDFSurface_cairo_1pdf_1surface_1set_1dpi
  (JNIEnv *env, jclass cls, jobject sur, jdouble x, jdouble y)
{
	cairo_surface_t *s;
	
	s = getPointerFromHandle(env, sur);
	cairo_pdf_surface_set_dpi(s, x, y);
}


#ifdef __cplusplus
}
#endif
#endif
