/*
 * Java-Gnome Bindings Library
 * 
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 * 
 * The Java-Gnome bindings library is free software distributed under the terms
 * of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

/**
 * This class implements the native methods that are common with both
 * FileChooserDialog and FileChooserWidget.
 */
class FileChooserHelper {

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final void gtk_file_chooser_set_action(int chooser, int action);
	native static final int gtk_file_chooser_get_action(int chooser);
	native static final void gtk_file_chooser_set_folder_mode(int chooser, boolean folderMode);
	native static final boolean gtk_file_chooser_get_folder_mode(int chooser);
	native static final void gtk_file_chooser_set_local_only(int chooser, boolean localOnly);
	native static final boolean gtk_file_chooser_get_local_only(int chooser);
	native static final void gtk_file_chooser_set_select_multiple(int chooser, boolean selectMultiple);
	native static final boolean gtk_file_chooser_get_select_multiple(int chooser);
	native static final void gtk_file_chooser_set_current_name(int chooser, String name);
	native static final String gtk_file_chooser_get_filename(int chooser);
	native static final void gtk_file_chooser_set_filename(int chooser, String filename);
	native static final void gtk_file_chooser_select_filename(int chooser, String filename);
	native static final void gtk_file_chooser_unselect_filename(int chooser, String filename);
	native static final void gtk_file_chooser_select_all(int chooser);
	native static final void gtk_file_chooser_unselect_all(int chooser);
	native static final String[] gtk_file_chooser_get_filenames(int chooser);
	native static final void gtk_file_chooser_set_current_folder(int chooser, String folder);
	native static final String gtk_file_chooser_get_current_folder(int chooser);
	native static final String gtk_file_chooser_get_uri(int chooser);
	native static final void gtk_file_chooser_set_uri(int chooser, String uri);
	native static final void gtk_file_chooser_select_uri(int chooser, String uri);
	native static final void gtk_file_chooser_unselect_uri(int chooser, String uri);
	native static final String[] gtk_file_chooser_get_uris(int chooser);
	native static final void gtk_file_chooser_set_current_folder_uri(int chooser, String uri);
	native static final String gtk_file_chooser_get_current_folder_uri(int chooser);
	native static final void gtk_file_chooser_set_preview_widget(int chooser, int previewWidget);
	native static final int gtk_file_chooser_get_preview_widget(int chooser);
	native static final void gtk_file_chooser_set_preview_widget_active(int chooser, boolean active);
	native static final boolean gtk_file_chooser_get_preview_widget_active(int chooser);
	native static final String gtk_file_chooser_get_preview_filename(int chooser);
	native static final String gtk_file_chooser_get_preview_uri(int chooser);
	native static final void gtk_file_chooser_set_extra_widget(int chooser, int extraWidget);
	native static final int gtk_file_chooser_get_extra_widget(int chooser);
	native static final void gtk_file_chooser_add_filter(int chooser, int filter);
	native static final void gtk_file_chooser_remove_filter(int chooser, int filter);
	native static final int[] gtk_file_chooser_list_filters(int chooser);
	native static final void gtk_file_chooser_set_filter(int chooser, int filter);
	native static final int gtk_file_chooser_get_filter(int chooser);
	native static final boolean gtk_file_chooser_add_shortcut_folder(int chooser, String folder, int[] error);
	native static final boolean gtk_file_chooser_remove_shortcut_folder(int chooser, String folder, int[] error);
	native static final String[] gtk_file_chooser_list_shortcut_folders(int chooser);
	native static final boolean gtk_file_chooser_add_shortcut_folder_uri(int chooser, String uri, int[] error);
	native static final boolean gtk_file_chooser_remove_shortcut_folder_uri(int chooser, String uri, int[] error);
	native static final String[] gtk_file_chooser_list_shortcut_folder_uris(int chooser);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
