
package filechooser;

import org.gnu.gtk.FileChooserAction;
import org.gnu.gtk.FileChooserDialog;
import org.gnu.gtk.FileFilter;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;

/**
 * This is an example that demonstrates the new FileChooser object.
 */
public class FileChooserExample {
	
	public FileChooserExample() {
		FileChooserDialog dialog = new FileChooserDialog("File Chooser", null, FileChooserAction.ACTION_OPEN);
		dialog.addListener(new LifeCycleListener() {
			public void lifeCycleEvent(LifeCycleEvent event) {}
			public boolean lifeCycleQuery(LifeCycleEvent event) {
				if (event.isOfType(LifeCycleEvent.Type.DESTROY) || 
						event.isOfType(LifeCycleEvent.Type.DELETE)) {
						Gtk.mainQuit();
				}
				return false;
			}
		});
		
		FileFilter filter = new FileFilter();
		filter.setName("Java Source File");
		filter.addPattern("*.java");
		dialog.addFilter(filter);
		
		filter = new FileFilter();
		filter.setName("C Source File");
		filter.addPattern("*.c");
		dialog.addFilter(filter);
		
		dialog.showAll();
	}

	public static void main(String[] args) {
		// Initialize GTK 
		Gtk.init(args);

		FileChooserExample example = new FileChooserExample();

		Gtk.main();
	}
}
