/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gtk/gtk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gtk.Plug
 * Method:    gtk_plug_get_type
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Plug_gtk_1plug_1get_1type (JNIEnv *env, jclass cls) 
{
    return (jint)gtk_plug_get_type ();
}

/*
 * Class:     org.gnu.gtk.Plug
 * Method:    gtk_plug_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Plug_gtk_1plug_1new (JNIEnv *env, jclass cls, jint 
    socketId) 
{
    gint32 socketId_g = (gint32) socketId;
    return getHandleFromPointer(env, gtk_plug_new (socketId_g));
}

/*
 * Class:     org.gnu.gtk.Plug
 * Method:    gtk_plug_construct
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Plug_gtk_1plug_1construct (JNIEnv *env, jclass cls, 
    jobject plug, jint socketId) 
{
    GtkPlug *plug_g = (GtkPlug *)getPointerFromHandle(env, plug);
    gint32 socketId_g = (gint32) socketId;
    gtk_plug_construct (plug_g, socketId_g);
}

/*
 * Class:     org.gnu.gtk.Plug
 * Method:    gtk_plug_get_id
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Plug_gtk_1plug_1get_1id (JNIEnv *env, jclass cls, jobject 
    plug) 
{
    GtkPlug *plug_g = (GtkPlug *)getPointerFromHandle(env, plug);
    return (jint)gtk_plug_get_id (plug_g);
}

#ifdef __cplusplus
}

#endif
