/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.netlist.ExportGlobal;
import com.sun.electric.tool.ncc.netlist.ExportGlobalConflict;
import com.sun.electric.tool.user.ncc.ExportConflict;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class NccCellInfo
extends HierarchyEnumerator.CellInfo {
    private NccGlobals globals;
    private boolean gotAnnotations = false;
    private NccCellAnnotations annotations;

    public NccCellInfo(NccGlobals globals) {
        this.globals = globals;
    }

    public NccCellAnnotations getAnnotations() {
        if (!this.gotAnnotations) {
            this.annotations = NccCellAnnotations.getAnnotations(this.getCell());
        }
        this.gotAnnotations = true;
        return this.annotations;
    }

    public Iterator<ExportGlobal> getExportsAndGlobals() {
        String nm;
        HashMap<String, ExportGlobal> nameToExport = new HashMap<String, ExportGlobal>();
        Iterator<PortProto> it = this.getCell().getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            if (this.ignoreExport(e.getName(), this.getAnnotations())) continue;
            int[] expNetIDs = this.getExportNetIDs(e);
            for (int i = 0; i < expNetIDs.length; ++i) {
                nm = e.getNameKey().subname(i).toString();
                if (this.ignoreExport(nm, this.getAnnotations())) continue;
                ExportGlobal eg = new ExportGlobal(nm, expNetIDs[i], e.getCharacteristic(), this.getNetlist().getNetwork(e, i), e);
                nameToExport.put(nm, eg);
            }
        }
        ArrayList<Object> expGlob = new ArrayList<Object>();
        expGlob.addAll(nameToExport.values());
        Global.Set globNets = this.getNetlist().getGlobals();
        for (int i = 0; i < globNets.size(); ++i) {
            Global g = globNets.get(i);
            nm = g.getName();
            if (this.ignoreExport(g.getName(), this.getAnnotations())) continue;
            Network net = this.getNetlist().getNetwork(g);
            int netID = this.getNetID(net);
            PortCharacteristic type = globNets.getCharacteristic(g);
            ExportGlobal eg = (ExportGlobal)nameToExport.get(nm);
            if (eg != null) {
                ExportConflict conf;
                if (eg.netID == netID && eg.type == type) continue;
                if (eg.netID != netID) {
                    this.globals.prln("  Error! Cell: " + this.getCell().libDescribe() + " has both an Export and a global signal named: " + nm + " but their networks differ");
                    conf = new ExportConflict.NetworkConflict(this.getCell(), this.getContext(), nm, eg.network, net);
                    this.globals.getNccGuiInfo().addNetworkExportConflict((ExportConflict.NetworkConflict)conf);
                }
                if (eg.type != type) {
                    this.globals.prln("  Error! Cell: " + this.getCell().libDescribe() + " has both an Export and a global signal named: " + nm + " but their Characteristics differ");
                    conf = new ExportConflict.CharactConflict(this.getCell(), this.getContext(), nm, type.getFullName(), eg.type.getFullName(), eg.getExport());
                    this.globals.getNccGuiInfo().addCharactExportConflict((ExportConflict.CharactConflict)conf);
                }
                throw new ExportGlobalConflict();
            }
            eg = new ExportGlobal(nm, netID, type, net);
            expGlob.add(eg);
        }
        return expGlob.iterator();
    }

    private boolean ignoreExport(String name, NccCellAnnotations ann) {
        if (ann == null) {
            return false;
        }
        Iterator<List<NccCellAnnotations.NamePattern>> patit = ann.getExportsToIgnore();
        while (patit.hasNext()) {
            List<NccCellAnnotations.NamePattern> patterns = patit.next();
            for (NccCellAnnotations.NamePattern pat : patterns) {
                if (!pat.matches(name)) continue;
                return true;
            }
        }
        return false;
    }
}

