/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class LibraryDialog
extends EDialog {
    private JList libList;
    private DefaultListModel libModel;

    public static void getALibrary() {
        Project.pmActive = true;
        String dirName = Project.getRepositoryLocation();
        File dir = new File(dirName);
        File[] filesInDir = dir.listFiles();
        if (filesInDir == null && dirName.length() == 0) {
            Job.getUserInterface().showInformationMessage("No repository location is set.  Use the 'Project Management' Preferences to set it.", "Warning");
            return;
        }
        new LibraryDialog(filesInDir);
    }

    LibraryDialog(File[] filesInDir) {
        super((Frame)null, true);
        this.initComponents(filesInDir);
        this.setVisible(true);
    }

    @Override
    protected void escapePressed() {
        this.doButton(false);
    }

    private void doButton(boolean retrieve) {
        if (retrieve) {
            int index = this.libList.getSelectedIndex();
            String libName = (String)this.libModel.getElementAt(index);
            new RetrieveLibraryFromRepositoryJob(libName);
        }
        this.dispose();
    }

    private void initComponents(File[] filesInDir) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Retrieve a Library from the Repository");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LibraryDialog.this.doButton(false);
            }
        });
        JScrollPane libPane = new JScrollPane();
        this.libModel = new DefaultListModel();
        this.libList = new JList(this.libModel);
        this.libList.setSelectionMode(0);
        libPane.setViewportView(this.libList);
        this.libList.clearSelection();
        this.libList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LibraryDialog.this.doButton(true);
                }
            }
        });
        ArrayList<String> libNames = new ArrayList<String>();
        for (int i = 0; i < filesInDir.length; ++i) {
            File subFile = filesInDir[i];
            if (!subFile.isDirectory()) continue;
            libNames.add(subFile.getName());
        }
        Collections.sort(libNames, new TextUtils.ObjectsByToString());
        for (String libName : libNames) {
            this.libModel.addElement(libName);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)libPane, gbc);
        JButton ok = new JButton("OK");
        this.getRootPane().setDefaultButton(ok);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)ok, gbc);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryDialog.this.doButton(true);
            }
        });
        JButton cancel = new JButton("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)cancel, gbc);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryDialog.this.doButton(false);
            }
        });
        this.pack();
    }

    private static class RetrieveLibraryFromRepositoryJob
    extends Job {
        private ProjectDB pdb = Project.projectDB;
        private String libName;

        private RetrieveLibraryFromRepositoryJob(String libName) {
            super("Retrieve Library from Repository", Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.libName = libName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            Library lib = Library.findLibrary(this.libName);
            if (lib != null) {
                throw new JobException("Library '" + lib.getName() + "' already exists");
            }
            lib = Library.newInst(this.libName, null);
            String projFile = Project.getRepositoryLocation() + File.separator + this.libName + File.separator + "project.proj";
            File pf = new File(projFile);
            if (!pf.exists()) {
                throw new JobException("Cannot find project file '" + projFile + "'...retrieve aborted.");
            }
            lib.newVar(Project.PROJPATHKEY, (Object)projFile, ep);
            ProjectLibrary pl = this.pdb.findProjectLibrary(lib);
            Project.setChangeStatus(true);
            ArrayList<ProjectCell> cellsToGet = new ArrayList<ProjectCell>();
            String lastName = "";
            Iterator<ProjectCell> it = pl.getProjectCells();
            while (it.hasNext()) {
                ProjectCell pc = it.next();
                String name = pc.describe();
                if (pc.getOwner().length() > 0) continue;
                if (name.equals(lastName)) {
                    cellsToGet.remove(cellsToGet.size() - 1);
                }
                cellsToGet.add(pc);
                lastName = name;
            }
            String userName = Project.getCurrentUserName();
            for (ProjectCell pc : cellsToGet) {
                if (pc.getCell() == null) {
                    Project.getCellFromRepository(this.pdb, pc, lib, true, true, ep);
                    if (pc.getCell() == null) {
                        Project.setChangeStatus(false);
                        throw new JobException("Error retrieving old version of cell");
                    }
                }
                if (pc.getCell() == null) continue;
                boolean youOwn = userName.length() > 0 && pc.getOwner().equals(userName);
                Project.markLocked(pc.getCell(), !youOwn, ep);
            }
            Project.setChangeStatus(false);
            System.out.println("Library " + lib.getName() + " has been retrieved from the repository");
            this.fieldVariableChanged("pdb");
            return true;
        }

        @Override
        public void terminateOK() {
            Project.projectDB = this.pdb;
            WindowFrame.wantToRedoLibraryTree();
        }
    }
}

