//////////////////////////////////////////////////////////////////////////////
//
//    CONVERTIMAGESDIALOG.H
//
//    Copyright (C) 2003-2005 Gilles CAULIER <caulier dot gilles at free.fr>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Steet, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////


#ifndef CONVERTIMAGESDIALOG_H
#define CONVERTIMAGESDIALOG_H

// Local includes

#include "kpaboutdata.h"
#include "batchprocessimagesdialog.h"


namespace KIPIBatchProcessImagesPlugin
{

class BatchProcessImagesItem;

class ConvertImagesDialog : public BatchProcessImagesDialog
{
Q_OBJECT

 public:
 
   ConvertImagesDialog( KURL::List images, KIPI::Interface* interface, QWidget *parent=0 );
   ~ConvertImagesDialog();

 private slots:
 
   void slotHelp(void);
   void slotOptionsClicked(void);
   void slotTypeChanged(int type);

 protected:
 
   int                    m_JPEGPNGCompression;
   bool                   m_compressLossLess;
   QString                m_TIFFCompressionAlgo;
   QString                m_TGACompressionAlgo;

   QString makeProcess(KProcess* proc, BatchProcessImagesItem *item,
                       const QString& albumDest, bool previewMode);

   void readSettings(void);
   void saveSettings(void);

   QString oldFileName2NewFileName(QString fileName);
   QString ImageFileExt(QString Ext);

 private:

   KIPIPlugins::KPAboutData *m_about;
};

}  // NameSpace KIPIBatchProcessImagesPlugin

#endif  // CONVERTIMAGESDIALOG_H
