/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2008-09-09
 * Description : a kipi plugin to slide images.
 *
 * Copyright (C) 2008-2009 by Valerio Fuoglio <valerio dot fuoglio at gmail dot com>
 * Copyright (C) 2009      by Andi Clemens <andi dot clemens at gmx dot net>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef MAINDIALOG_H
#define MAINDIALOG_H

// Qt includes

#include <QSvgRenderer>

// KDE includes

#include "kio/previewjob.h"
#include "kurl.h"

// Local includes

#include "common.h"
#include "ui_maindialog.h"

class QTreeWidgetItem;

namespace KIPIPlugins
{
class ImagesList;
}

namespace KIPIAdvancedSlideshowPlugin
{

class SharedData;

class MainDialog : public QWidget, Ui::MainDialog
{
    Q_OBJECT

public:

    MainDialog(QWidget* parent, SharedData* sharedData);
    ~MainDialog();

    void readSettings();
    void saveSettings();
    bool updateUrlList();

private Q_SLOTS:

    void slotOpenGLToggled( void );
    void slotEffectChanged( void );
    void slotDelayChanged( int );
    void slotPrintCommentsToggled( void );
    void slotSelection( void );
    void slotUseMillisecondsToggled( void );
    void slotThumbnail(const KUrl&, const QPixmap&);
    void slotImageListChanged();

    void slotPortfolioDurationChanged ( int );
    void slotImagesFilesSelected(QTreeWidgetItem* item);

Q_SIGNALS :

    void totalTimeChanged( QTime );

private:

    void setupConnections();
    void loadEffectNames();
    void loadEffectNamesGL();

    void showNumberImages();
    void addItems(const KUrl::List& fileList);

private:

    SharedData*              m_sharedData;
    KIO::PreviewJob*         m_thumbJob;
    QTime                    m_totalTime;
    QPixmap                  m_noPreviewPixmap;
    KIPIPlugins::ImagesList* m_ImagesFilesListBox;
};

} // namespace KIPIAdvancedSlideshowPlugin

#endif // MAINDIALOG_H
