//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef KEXIFDATA_H
#define KEXIFDATA_H

#include <qstring.h>
#include <qimage.h>
#include <qptrlist.h>
#include <qdatetime.h>

class KExifIfd;
class KExifDataPriv;

class KExifData
{
public:

    enum ImageOrientation {
        UNSPECIFIED=0,
        NORMAL=1, 
        HFLIP=2, 
        ROT_180=3, 
        VFLIP=4, 
        ROT_90_HFLIP=5, 
        ROT_90=6, 
        ROT_90_VFLIP=7, 
        ROT_270=8
    };

    KExifData();
    ~KExifData();

    bool    readFromFile(const QString& filename);
    bool    readFromData(char* data, int size);

    QImage           getThumbnail() const;
    QString          getUserComment() const;
    ImageOrientation getImageOrientation() const;
    QDateTime        getExifDateTime() const;

    QPtrList<KExifIfd> ifdList() const;

    void saveFile(const QString& filename);

private:

    KExifDataPriv *d;
};

#endif
